#include "GanttCtrl.h"

namespace Upp {
namespace GraphDraw_ns {


MyGanttCtrl::MyGanttCtrl() {
	_B::SetStyle( StyleDefault() );
	GetElementX1GridAxisDraw().SetElementPos(TOP_OF_GRAPH);
	HideTitle();
	HideLegend();
	HideX1Markers();
	HideX1Label();
	HideY1Markers();
	SetY1AxisRectWidth(0);
	HideY1Label();
	GetElementY1GridAxisDraw().GetGridStepManager().setCustomGridSteps(STDBACK(step1_GridStepCalcCbk));
	
	SetLeftMargin(0);
	SetRightMargin(0);
	SetTopMargin(0);
	SetBottomMargin(0);
}
	
void MyGanttCtrl::step1_GridStepCalcCbk(GridStepManager& gridStepManager, CoordinateConverter& coordConv) {
	const unsigned int nbMaxSteps = GridStepManager::NB_MAX_STEPS; //gridStepManager.GetNbMaxSteps();
	GridStepData* gridStepData = gridStepManager.GetGridStepData();
	TypeGraphCoord gridStepValue = 1;
	TypeGraphCoord gridStartValue = GridStepManager::GetGridStartValue( gridStepValue, coordConv.getGraphMin() );

	unsigned int nbSteps = (unsigned int)tabs((coordConv.getGraphMax() - gridStartValue) / gridStepValue);
	
	if (nbSteps > nbMaxSteps) {
		nbSteps = nbMaxSteps;
	}
	gridStepManager.SetNbSteps(nbSteps);

	// fill step values ==> used by gridStepIterator
	for (unsigned int c=0; c<nbSteps+1; ++c) {
		gridStepData[c].stepGraphValue = gridStartValue + gridStepValue*c;
		gridStepData[c].drawTickText = 1;// ==> draw tick text
	}
}





CH_STYLE(MyGanttCtrl, Style, StyleDefault) {
	gdStyle        = MyGanttCtrl::CH_EmptyGraphDraw::StyleGDDefault();
	x1LabelStyle   = MyGanttCtrl::TypeLabelX1::StyleGEXAxisDefault();
	x1AxisStyle    = MyGanttCtrl::TypeGridAxisX1::StyleGEDefault();
	y1LabelStyle   = MyGanttCtrl::TypeLabelY1::StyleGEYAxisDefault();
	y1AxisStyle    = MyGanttCtrl::TypeGridAxisY1::StyleGEDefault();
	titleStyle     = MyGanttCtrl::TypeLabelTitle::StyleGETitleDefault();
	legendStyle    = MyGanttCtrl::TypeLegend::StyleGEDefault();
	x1MarkerStyle  = MyGanttCtrl::TypeMarkerX1::StyleGEDefault();
	y1MarkerStyle  = MyGanttCtrl::TypeMarkerY1::StyleGEDefault();
	
}


} // namespace GraphDraw_ns
} // namespace Upp
