#include "GraphCtrl.h"

namespace Upp {
namespace GraphDraw_ns {

struct SeriesIconGridDisplay : public GridDisplay {
	virtual void Paint(Draw &w, int x, int y, int cx, int cy, const Value &val, dword style,
	                   Color &fg, Color &bg, Font &fnt, bool found = false, int fs = 0, int fe = 0)
	{
		w.DrawRect(x,y,cx,cy, White());
		DrawFatFrame(w,x,y,cx,cy, bg, 3);
		SeriesConfig* currSerie = val.To<SeriesConfig*>();
		ChPaint(w, x,y,cx,cy, currSerie->MakeSerieIcon(Size(cx,cy), 1));
	}
};

struct SeriesIconDisplay : public Display {
	virtual void Paint(Draw& w, const RectScreen& r, const Value& val,
	                   Color ink, Color paper, dword style) const
	{
		w.DrawRect(r,White());
		DrawFatFrame(w,r,paper,3);
		SeriesConfig* currSerie = val.To<SeriesConfig*>();
		ChPaint(w, r, currSerie->MakeSerieIcon(r.GetSize(),1));
	}
};


Id ID_SHOW_COLUMN("SHOW");
Id ID_LEGEND_COLUMN("LEGEND");

void SeriesCtrlDlg::SetModify() {
	seriesHash++;
}

void SeriesCtrlDlg::ClearModify() {
	CombineHash hash;
	for (int c=0; c<series.GetCount(); ++c) {
		hash << series[c];
	}
}

bool SeriesCtrlDlg::IsModified() const {
	CombineHash hash;
	for (int c=0; c<series.GetCount(); ++c) {
		hash << series[c];
	}
	
	RLOG("SeriesCtrlDlg::IsModified() = " << (hash != seriesHash));
	return hash != seriesHash;
}



SeriesCtrlDlg::SeriesCtrlDlg( TypeVectorSeries& s )
: series(s)
, currSelection(-1)
{
	Transparent();
	CtrlLayout(*this);//, "Data Series Properties");
	
	seriesGridCtrl.AddColumn(ID_SHOW_COLUMN, "Show", 23).Ctrls<Option>();
	seriesGridCtrl.AddColumn("Icon", 45).SetDisplay( Single<SeriesIconGridDisplay>() );
	seriesGridCtrl.AddColumn(ID_LEGEND_COLUMN, "Legend", 120);
	seriesGridCtrl.ColumnWidths("23 45 230");
	seriesGridCtrl.SetToolBar();
	
	seriesGridCtrl.WhenBeforeChangeRow = THISBACK(saveConfigToSelectedSerie);
	seriesGridCtrl.WhenChangeRow   =     THISBACK(loadConfigFromSelectedSerie);
	seriesGridCtrl.WhenCtrlsAction = THISBACK(arrayLineEdited);
	show.WhenAction = THISBACK(updateArrayShow);
	legend.WhenAction = THISBACK(updateArrayLegend);
	
	lineDash.WhenAction = THISBACK(saveConfigToSelectedSerie);
	lineThickness.WhenAction = THISBACK(saveConfigToSelectedSerie);
	lineColor.WhenAction = THISBACK(saveConfigToSelectedSerie);
	opacity.WhenAction = THISBACK(saveConfigToSelectedSerie);
	fillColor.WhenAction = THISBACK(saveConfigToSelectedSerie);

	//markstyle.WhenAction = THISBACK(saveConfigToSelectedSerie);
	markWidth.WhenAction = THISBACK(saveConfigToSelectedSerie);
	markColor.WhenAction = THISBACK(saveConfigToSelectedSerie);
	
	ShowAllBt.WhenAction= THISBACK1( showAll, true );
	ClearAllBt.WhenAction= THISBACK1(showAll, false);
	

	serieBackGnd.Color( Color(255, 255, 255) );
	
	
	CombineHash hash;
	for (int c=0; c<series.GetCount(); ++c) {
		SeriesConfig& ser = (series[c]);
		seriesGridCtrl.Add( ser.show, RawToValue(&ser), ser.legend );
	}
	
	if (series.GetCount() > 0) {
		seriesGridCtrl.GoBegin();
		loadConfigFromSelectedSerie();
	}
	
	ClearModify();
}

SeriesCtrlDlg::~SeriesCtrlDlg() {
	saveConfigToSelectedSerie();
}



void SeriesCtrlDlg::showAll(bool showHide) {
	for (int i = 0; i < series.GetCount(); ++i) {
		seriesGridCtrl.Set(i, ID_SHOW_COLUMN, showHide);
	}
	arrayLineEdited();
}


void SeriesCtrlDlg::updateArrayShow(void) {
	seriesGridCtrl.Set(ID_SHOW_COLUMN, ~show);
	saveConfigToSelectedSerie();
}

void SeriesCtrlDlg::updateArrayLegend(void) {
	seriesGridCtrl.Set(ID_LEGEND_COLUMN, ~legend);
	saveConfigToSelectedSerie();
}

void SeriesCtrlDlg::arrayLineEdited(void) {
	for (int c=0; c<seriesGridCtrl.GetCount(); ++c) {
		series[c].show = seriesGridCtrl.Get(c, ID_SHOW_COLUMN);
		series[c].legend = seriesGridCtrl.Get(c, ID_LEGEND_COLUMN);
	}
	show.SetData(seriesGridCtrl.Get(ID_SHOW_COLUMN));
	legend.SetData(seriesGridCtrl.Get(ID_LEGEND_COLUMN));
}


void SeriesCtrlDlg::loadConfigFromSelectedSerie(void) {
	// Load new values
	currSelection = seriesGridCtrl.GetCursor();
	if (currSelection >= 0) {
		SeriesConfig& s = series[currSelection];

		fillColor.SetData(s.fillColor);
		opacity.SetData(s.opacity);
		markColor.SetData(s.markColor);
		lineDash.SetData(s.dash);
		lineColor.SetData(s.color);
		lineThickness.SetData(s.thickness);
		fillColor.SetData(s.fillColor);
		markWidth.SetData(s.markWidth);
		show.SetData(s.show);
		legend.SetData(s.legend);

		updateSeriePreview();
	}
}


void SeriesCtrlDlg::saveConfigToSelectedSerie(void) {
	// save previous modifications
	currSelection = seriesGridCtrl.GetCursor();
	if (currSelection >= 0) {
		SeriesConfig& s = series[currSelection];

		s.fillColor = ~fillColor;
		s.opacity = ~opacity;
		s.markColor = ~markColor;
		s.dash = ~lineDash;
		s.color = ~lineColor;
		s.thickness = ~lineThickness;
		s.fillColor = ~fillColor;
		s.markWidth = ~markWidth;
		s.show = ~show;
		s.legend = ~legend;
		
		updateSeriePreview();
	}
}

void SeriesCtrlDlg::updateSeriePreview(void) {
	if (currSelection >= 0) {
		SeriesConfig& s = series[currSelection];
		seriePreview.SetImage( s.MakeSerieIcon(seriePreview.GetSize(),1) );
	}
}

} // namespace



END_UPP_NAMESPACE
