#include "GraphDraw.h"

namespace Upp {
namespace GraphDraw_ns {

void ScatterDataSource::PaintSerie(BufferPainter& dw, int scale, const CoordinateConverter* xCoordConv, const CoordinateConverter* yCoordConv ) {
	DataSource* dataSrc = PointsData();
	const CoordinateConverter& xConverter = *xCoordConv;
	const CoordinateConverter& yConverter = *yCoordConv;

	if ((show==false) || (!seriesPlot && !markPlot))
		return;


	if ((nbVisiblePoints==0)  &&  ( ! dataSrc->IsExplicit())) {
			nbVisiblePoints = (decltype(nbVisiblePoints))(dataSrc->GetCount());
	}
	
	// ============================================
	//     CREATE  LIST  OF  POINTS  TO  DRAW
	// ============================================
	int inc = 1;
	Upp::int64 nbVisiblePts = 0;
	int imin=0, imax=0;
	double dmin=0, dmax=0;
	
	// =================================
	// figure out data-range
	Rectf logicalRect(xConverter.getGraphMin(), yConverter.getGraphMin(), xConverter.getGraphMax(), yConverter.getGraphMax()); 
	if (dataSrc->IsParam()) {             // It is a param function : x=F(t)  y=G(t)
		imin = 0;
		imax = (decltype(imax)) (dataSrc->GetCount()-1);
	} else if ( dataSrc->IsExplicit() ) { // It is a function :  y=f(x)
		dmin = xConverter.getGraphMin();
		dmax = xConverter.getGraphMax();
	} else {
	    imin = 0;
	    imax = (decltype(imax)) (dataSrc->GetCount()-1);
	    if (sequential) {
			imin = FindIndexX(dataSrc, imin, imax, xConverter.getGraphMin())-1;
			if (imin < 0) imin=0;
			
			int imax2 = FindIndexX(dataSrc, imin, imax, xConverter.getGraphMax())+1;
			if (imax2>imax) imax2 = imax;
			imax = imax2;
		}
	}
	// =================================
	
	p1.Trim(0);
	p1.Reserve(imax-imin+1);
	PointGraph prevPoint = Null;
	bool prevPointIsVisible = true;
	TypeGraphCoord x;
	TypeGraphCoord y;
	
	bool _doFastPaint = false;

	if ( !_doFastPaint )  // DRAW ALL DATA (no partial draw)
	{
		nbVisiblePts = 0;
		bool isSeriesFilled = false;
		if ( !seriesPlot.IsEmpty() && !fillColor.IsNullInstance() ) {
			isSeriesFilled = true;
		}

		if (dataSrc->IsParam())
		{
			const int xmax = imax+1;
			if (!seriesPlot.IsEmpty()) // lines & points will be drawn
			{
				for (double cx=imin; cx<=xmax; ++cx)
				{
					x = dataSrc->x(cx);
					y = dataSrc->y(cx);
					p1.AddPick(PointScreen(xConverter.toScreen( x ), yConverter.toScreen( y )));
					++nbVisiblePts;
				}
			}
			else  // only points will be drawn
			{
				for (double cx=imin; cx<xmax; ++cx)
				{
					x = dataSrc->x(cx);
					y = dataSrc->y(cx);
					if ( logicalRect.Contains(x,y) ) {
						p1.AddPick(PointScreen(xConverter.toScreen( x ), yConverter.toScreen( y )));
						++nbVisiblePts;
					}
				}
			}
		}
		else if ( dataSrc->IsExplicit() )
		{
			double dx = double(dmax - dmin)/(double)xConverter.getScreenRange(); // one point per X pixel
			dmax = dmax+dx;
			double yy, xx;
			if (!seriesPlot.IsEmpty()) // lines & points will be drawn
			{
				for (xx = dmin-dx; xx < dmax; xx += dx)
				{
					yy = dataSrc->f(xx);
					p1.AddPick(PointScreen(xConverter.toScreen( xx ), yConverter.toScreen( yy )));
					++nbVisiblePts;
				}
			}
			else // only points will be drawn
			{
				for ( xx = dmin-dx; xx < dmax; xx += dx)
				{
					yy = dataSrc->f(xx);
					if ( yConverter.IsInGraphVisibleRange(yy) )	{
						p1.AddPick(PointScreen(xConverter.toScreen( xx ), yConverter.toScreen( yy )));
						++nbVisiblePts;
					}
				}
			}
		}
		else
		{
			if (sequential)
			{
				int64 c=imin;
				if (!seriesPlot.IsEmpty())  // lines & points will be drawn
				{
					prevPoint.x = dataSrc->x(c);
					prevPoint.y = dataSrc->y(c);
					for ( ; c<=imax; ++c)
					{
						x = dataSrc->x(c);
						y = dataSrc->y(c);
						addToFullPointsList_withLine( DetectSCrossing_XinRange, p1, x, y, xConverter, yConverter, nbVisiblePts, prevPoint, prevPointIsVisible, isSeriesFilled, logicalRect);
					}
				}
				else // only points will be drawn
				{
					for ( ; c<=imax; ++c)
					{
						x = dataSrc->x(c);
						y = dataSrc->y(c);
						if ( yConverter.IsInGraphVisibleRange(y) )	{
							p1.AddPick(PointScreen(xConverter.toScreen( x ), yConverter.toScreen( y )));
							++nbVisiblePts;
						}
					}
				}
			}
			else
			{
				if (!seriesPlot.IsEmpty()) // lines & points will be drawn
				{
					for (Upp::int64 c=imin; c<=imax; c+=inc)
					{
						x = dataSrc->x(c);
						y = dataSrc->y(c);
						addToFullPointsList_withLine( DetectSCrossing, p1, x, y, xConverter, yConverter, nbVisiblePts, prevPoint, prevPointIsVisible, isSeriesFilled, logicalRect);
					}
				}
				else // only points will be drawn
				{
					for (Upp::int64 c=imin; c<=imax; c+=inc)
					{
						x = dataSrc->x(c);
						y = dataSrc->y(c);
						if ( logicalRect.Contains(x,y) ) {
							p1.AddPick(PointScreen(xConverter.toScreen( x ), yConverter.toScreen( y )));
							++nbVisiblePts;
						}
					}
				}
			}
		}
		nbVisiblePoints = (decltype(nbVisiblePoints)) nbVisiblePts;
	}
	else  // DO FAST DRAW : display 800 points maximum per series
	{
		if (dataSrc->IsParam()) {
			const double xmax = imax+1;
			double x, y;
			double dx = Upp::max(double(xmax - imin)/800. , 1.0);
			for (double cx=imin; cx<=xmax; cx+=dx)
			{
				x = dataSrc->x(cx);
				y = dataSrc->y(cx);
				p1 << PointScreen(xConverter.toScreen( x ), yConverter.toScreen( y ));
			}
		} else if (dataSrc->IsExplicit() ) {
			double dx = double(dmax - dmin)/800.;
			dmax = dmax+dx;
			if (xConverter.getScreenRange()<800.) dx = double(dmax - dmin)/xConverter.getScreenRange();

			for (double xx = dmin; xx < dmax; xx += dx) {
				double yy = dataSrc->f(xx);
				p1 << PointScreen(xConverter.toScreen( xx ), yConverter.toScreen( yy ));
			}
		} else {
			inc = fceil((imax-imin)/800.0);
			if (inc==0) ++inc;
			
			imin -= imin%inc;
			
			for ( Upp::int64 c=imin; c<=imax; c+=inc)
			{
				p1 << PointScreen( xConverter.toScreen( dataSrc->x(c)) , yConverter.toScreen( dataSrc->y(c)) );
			}
		}
	}

	// Draw lines
	if ( !seriesPlot.IsEmpty() && (p1.GetCount()>0))
		seriesPlot->Paint(dw,
                        p1,
                        scale,
                        opacity,
                        fround(thickness),
                        color,
                        dash,
                        Null, //style->plotBckgndStyle,
                        fillColor,
                        xConverter.getScreenRange() / xConverter.getGraphRange(),
                        yConverter.getScreenRange() / yConverter.getGraphRange(),
                        int(yConverter.getScreenRange() * (1 + yConverter.getGraphMin() / yConverter.getGraphRange())),
                        10,
                        false
		);
	// Draw marks
	if (markWidth >= 1 && markPlot && !(markColor.IsNullInstance()) )
	{
		if ( !markPlot.IsEmpty() ) {
			for (int c=0; c<p1.GetCount(); ++c)
			{
				markPlot->Paint(dw,
                            scale,
                            p1[c],
                            markWidth,
                            markColor,
                            markWidth,
                            markColor);
			}
		}
	}
}

}
}