#ifndef _GraphCtrl_StdElementPropertiesDialogs_h_
#define _GraphCtrl_StdElementPropertiesDialogs_h_


template <class ELEMENT, class STYL>
class ElementPropertiesDlg : public WithElementBaseLayout<ElementPropertiesDlgInterface> {
	public:
	CtrlRetriever r1;
	ELEMENT*      elem;
	int           pos;
	int           elementWidth;

	public:
	typedef ElementPropertiesDlg<ELEMENT, STYL>  CLASSNAME;
	typedef WithElementBaseLayout<ElementPropertiesDlgInterface> _B;

	
	ElementPropertiesDlg() : elem(0), pos(100) {
//		CtrlLayoutOKCancel(*this, "");
		CtrlLayout(*this, "");
	}
	virtual ~ElementPropertiesDlg() {}

	
	void InitDlg(ELEMENT& element, STYL* styl=0) {
		//_B::Title(element.GetElementName());
		elem = &element;
		position.SetVertical();
		position.Add(FLOAT_OVER_GRAPH, t_("FLOAT") );
		position.Add(TOP_OF_GRAPH, t_("TOP") );
		position.Add(BOTTOM_OF_GRAPH, t_("BOTTOM") );
		position.Add(LEFT_OF_GRAPH, t_("LEFT") );
		position.Add(RIGHT_OF_GRAPH, t_("RIGHT") );

		for (int c=0; c<position.GetCases().GetCount(); ++c) {
			 const Switch::Case& caseData = position.GetCases()[c];
			if ((elem->_allowedPosMask & caseData.value.To<int>()) == 0 ) position.DisableValue(caseData.value);
		}

		pos = elem->_pos;
		elementWidth = elem->GetElementWidth();

		r1( width, elementWidth)
		  ( hide, elem->_hide)
		  ( stackingPrio, elem->_stackingPriority)
		  ( position, pos)
		  ;
	}
	
	virtual void Retrieve() {
		r1.Retrieve();
		elem->SetElementPos(static_cast<ElementPosition>(pos));
		elem->SetElementWidth(elementWidth);
		elem->_parent->RefreshFromChild( REFRESH_FULL );
	}
};
// ============================================================================================

template <class ELEMENTDRAW, class STYL>
class BlankAreaPropertiesDlg : public WithBlankAreaLayout<ElementPropertiesDlgInterface> {
	public:
	CtrlRetriever r1;
	ELEMENTDRAW*  elem;
	int           elementWidth;
	
	public:
	typedef BlankAreaPropertiesDlg<ELEMENTDRAW, STYL>  CLASSNAME;
	typedef WithBlankAreaLayout<ElementPropertiesDlgInterface>     _B;
	
	BlankAreaPropertiesDlg() {
		CtrlLayoutOKCancel(*this, "");
	}
	
	virtual ~BlankAreaPropertiesDlg() {}

	void InitDlg(ELEMENTDRAW& gda, STYL* styl=0) {
		elem = &gda;
		//Title(elem->_name);
		elementWidth = elem->GetElementWidth();
		r1( width, elementWidth);
	}
		
	virtual void Retrieve() {
		r1.Retrieve();
		elem->SetElementWidth(elementWidth);
	}
};

// ============================================================================================

template <class LABELDRAW, class STYL>
class LabelPropertiesDlg : public WithLabelPropertiesDlgLayout<ElementPropertiesDlgInterface > {
	public:
	CtrlRetriever r2;
	
	public:
	typedef LabelPropertiesDlg<LABELDRAW, STYL>  CLASSNAME;
	typedef WithLabelPropertiesDlgLayout<ElementPropertiesDlgInterface > _B;
	
	LabelPropertiesDlg() {
		SetLayout_LabelPropertiesDlgLayout(*this, true);
		 Size sz = _B::GetLayoutSize();
		 _B::SetMinSize(sz);
		 _B::SetRect(sz);
	}
	
	virtual ~LabelPropertiesDlg() {}

	void InitDlg(LABELDRAW& gda, STYL* styl=0) {
		if (styl) {
			r2( _B::textColor, styl->labelColor)
			  ( _B::textFont,  styl->labelFont)
			  ;
		}
		
		r2 ( _B::labelText, gda._label);
		
		labelBox.SetLabel( gda.GetElementName() );
	}
		
	virtual void Retrieve() {
		r2.Retrieve();
	}
};

// ============================================================================================

template <class MARKERDRAW, class STYL>
class MarkerPropertiesDlg : public WithMarkerPropertiesDlgLayout<ElementPropertiesDlgInterface> {
	public:
		CtrlRetriever r2;

	public:
		typedef MarkerPropertiesDlg CLASSNAME;
		typedef WithMarkerPropertiesDlgLayout<ElementPropertiesDlgInterface > _B;

		MarkerPropertiesDlg() {
			SetLayout_MarkerPropertiesDlgLayout(*this, true);
			 Size sz = _B::GetLayoutSize();
			 _B::SetMinSize(sz);
			 _B::SetRect(sz);
		}

	virtual ~MarkerPropertiesDlg() {}
	
	void InitDlg(MARKERDRAW& gda, STYL* styl=0) {
		if (styl) {
			r2( _B::lineColor, styl->mrkLineColor)
//			  ( _B::lineDash,  styl->mrkLineDash)
			  ( _B::lineWidth, styl->mrkLineWidth)
			  ( _B::tickColor, styl->mrkTickColor)
			  ;
		}
	}
		
	virtual void Retrieve() {
		r2.Retrieve();
	}
	
};


// ============================================================================================


// Default GridAxisPropertiesDlg  class
// it opens the minimal dialog for the CoordConverter beeing used
template <class GRIDAXISDRAW, class STYL, class COORDCONVERTER>
class GridAxisPropertiesDlg : public WithGridAxisPropertiesBaseLayout<ElementPropertiesDlgInterface > {
	public:
	COORDCONVERTER* converter;
	CtrlRetriever r2;
	double gMin;
	double gMax;
	
	public:
	typedef GridAxisPropertiesDlg<GRIDAXISDRAW, STYL, COORDCONVERTER>  CLASSNAME;
	typedef WithGridAxisPropertiesBaseLayout<ElementPropertiesDlgInterface > _B;
	
	GridAxisPropertiesDlg() : converter(0) {
		SetLayout_GridAxisPropertiesBaseLayout(*this, true);
		 Size sz = _B::GetLayoutSize();
		 _B::SetMinSize(sz);
		 _B::SetRect(sz);
		 _B::max << THISBACK(WhenMinMaxChange);
		 _B::min << THISBACK(WhenMinMaxChange);
	}
	
	virtual ~GridAxisPropertiesDlg() {}
	
	void WhenMinMaxChange() {
		_B::range = _B::max - _B::min;
	}

	void InitDlg(GRIDAXISDRAW& gda, COORDCONVERTER& conv, STYL* styl=0) {
		converter = &conv;
		gMin = converter->getGraphMin();
		gMax = converter->getGraphMax();
		
		//scaleType.Hide();
		if (styl) {
			r2( _B::axisLineColor,     styl->axisColor)
			  ( _B::axisTextColor,     styl->axisTextColor)
			  ( _B::axisTickColor,     styl->axisTickColor)
			  ( _B::axisWidth,         styl->axisWidth)
			  ( _B::gridColor,         styl->gridColor)
			  ;
		}
		r2( _B::min, gMin)
		  ( _B::max, gMax)
		  ;
		  WhenMinMaxChange();
	}
		
	virtual void Retrieve() {
		r2.Retrieve();
		converter->UpdateGraphSize(gMin, gMax);
	}
};

// specialized class  for   CoordinateConverter
template <class GRIDAXISDRAW, class STYL>
class GridAxisPropertiesDlg<GRIDAXISDRAW, STYL, CoordinateConverter> : public WithGenericGridAxisPropertiesLayout< ElementPropertiesDlgInterface >
{
	public:
	int iscaleType;
	typedef CoordinateConverter COORDCONVERTER;
	COORDCONVERTER* converter;
	GridAxisDraw* gridAxisDraw;
	bool invertAxis;
	CtrlRetriever r2;
	double gMin;
	double gMax;
	
	public:
	typedef GridAxisPropertiesDlg<GRIDAXISDRAW, STYL, CoordinateConverter>  CLASSNAME;
	typedef WithGenericGridAxisPropertiesLayout<ElementPropertiesDlgInterface > _B;
	

	GridAxisPropertiesDlg() : converter(0), gridAxisDraw(0)  {
		SetLayout_GenericGridAxisPropertiesLayout(*this, true);
		 Size sz = _B::GetLayoutSize();
		 _B::SetMinSize(sz);
		 _B::SetRect(sz);
		 _B::scaleType.SetVertical();
		 _B::scaleFormat.SetVertical();
		 _B::max << THISBACK(WhenMinMaxChange);
		 _B::min << THISBACK(WhenMinMaxChange);
	}
	
	virtual ~GridAxisPropertiesDlg() {}

	void WhenMinMaxChange() {
		_B::range = _B::max - _B::min;
	}

	void InitDlg(GRIDAXISDRAW& gda, COORDCONVERTER& conv, STYL* styl=0) {
		converter = &conv;
		gridAxisDraw = &gda;
		gMin = converter->getGraphMin();
		gMax = converter->getGraphMax();
		iscaleType = converter->GetScaleType();
		invertAxis = gridAxisDraw->IsAxisInverted();
		

		_B::scaleType.Add(CoordinateConverter::AXIS_SCALE_STD,   t_("Std") );
		_B::scaleType.Add(CoordinateConverter::AXIS_SCALE_LOG,   t_("Log") );
		_B::scaleType.Add(CoordinateConverter::AXIS_SCALE_POW10, t_("Pow10") );
		if ( gMin <= 0) {
			_B::scaleType.DisableValue( CoordinateConverter::AXIS_SCALE_LOG);
		}
		
		if (styl) {
			r2( _B::axisLineColor,        styl->gdStyle.axisColor)
			  ( _B::axisTextColor,        styl->gdStyle.axisTextColor)
			  ( _B::axisTickColor,        styl->gdStyle.axisTickColor)
			  ( _B::axisLineThickness,    styl->gdStyle.axisWidth)
			  ( _B::gridColor,            styl->gdStyle.gridColor)
			  ( _B::gridLineThickness,    styl->gdStyle.gridThickness)
			  ( _B::gridLineDash,         styl->gdStyle.gridDash)
			  ;
		}
		r2   ( _B::min, gMin)
			  ( _B::max, gMax)
			  ( _B::scaleType, iscaleType)
			  ( _B::axisInvert, invertAxis)
			  ;

		  WhenMinMaxChange();
	}
		
	virtual void Retrieve() {
		r2.Retrieve();
		converter->SetScaleType(iscaleType);
		gridAxisDraw->SetAxisInverted(invertAxis);
		converter->UpdateGraphSize(gMin, gMax);
	}
};



#endif
