#ifndef _GraphCtrl_ElementCtrlBase_h_
#define _GraphCtrl_ElementCtrlBase_h_





// ============================================================================================


template<class TYPES, class ELEMENT_CLASS>
class GraphElementCtrl_Base : public ELEMENT_CLASS {
	public:
		typedef GraphElementCtrl_Base<TYPES, ELEMENT_CLASS> CLASSNAME;
		typedef ELEMENT_CLASS _B;
	
		Function<void()> whenOpenPropertiesDlgCB;
		Function<ElementPropertiesDlgInterface* (Value&)> MakePropertiesCtrl;
		
	template <class STYL, class GE>
	void TOpenPropertiesDlg(GE& lmnt, const STYL** pStyle) {
		STYL styl = **pStyle;
		hash_t hash1 = memhash(&styl, sizeof(styl) );
		PropertiesBaseDlg dlg;
		int baseOffset = dlg.commonParamsBox.GetSize().cy;
		CtrlRetriever r1;
		int elementWidth;
		int           pos;
		int yOffset = baseOffset;
		int minWidth=0;
		
		
		//_B::Title(element.GetElementName());
		auto elem = this;
		dlg.position.SetVertical();
		dlg.position.Add(FLOAT_OVER_GRAPH, t_("FLOAT") );
		dlg.position.Add(TOP_OF_GRAPH, t_("TOP") );
		dlg.position.Add(BOTTOM_OF_GRAPH, t_("BOTTOM") );
		dlg.position.Add(LEFT_OF_GRAPH, t_("LEFT") );
		dlg.position.Add(RIGHT_OF_GRAPH, t_("RIGHT") );

		for (int c=0; c<dlg.position.GetCases().GetCount(); ++c) {
			 const Switch::Case& caseData = dlg.position.GetCases()[c];
			if ((elem->_allowedPosMask & caseData.value.To<int>()) == 0 ) dlg.position.DisableValue(caseData.value);
		}

		pos = elem->_pos;
		elementWidth = elem->GetElementWidth();

		r1( dlg.width, elementWidth)
		  ( dlg.hide, elem->_hide)
		  ( dlg.stackingPrio, elem->_stackingPriority)
		  ( dlg.position, pos)
		  ;
		
		dlg.AddSubElement(3, minWidth, yOffset, lmnt, styl);
		dlg.AdjustSize(minWidth, yOffset-baseOffset);
		if ( dlg.Execute()==IDOK) {
			r1.Retrieve();
			elem->SetElementPos(static_cast<ElementPosition>(pos));
			elem->SetElementWidth(elementWidth);
			elem->_parent->RefreshFromChild( REFRESH_FULL );

			dlg.Retrieve();
			hash_t hash2 = memhash(&styl, sizeof(styl) );
			if (hash1 != hash2) // Style has been modified
			{
				_B::_parent->RequestChStyleLocal();
				* const_cast<STYL*>(*pStyle) = styl;
				_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_DEFAULT );
			}
		}
	}


	protected:
		template <  class ELEMENT_CTRL, template <class T1, class T2> class DLG>
		ElementPropertiesDlgInterface* TMakePropertiesCtrl(Value& v)
		{
			typedef DLG<ELEMENT_CTRL,typename ELEMENT_CTRL::StyleGE> CtrlType;
			if ( v.Is<typename ELEMENT_CTRL::StyleGE*>() ) {
				typename ELEMENT_CTRL::StyleGE* st =  v.To<typename ELEMENT_CTRL::StyleGE*>();
				CtrlType* ctrl = new CtrlType();
				ctrl->InitDlg(* dynamic_cast<ELEMENT_CTRL*>(this), st);
				return ctrl;
			}
			return 0;
		}
	
	public:
		GraphElementCtrl_Base() { 
			//whenOpenPropertiesDlgCB = THISBACK( TOpenPropertiesDlg<ElementPropertiesDlg> );
			//MakePropertiesCtrl = [=](Value& v) ->ElementPropertiesDlgInterface* { return 0; };
		}
		virtual ~GraphElementCtrl_Base() {}
	
		template <class PARAM>
		GraphElementCtrl_Base(PARAM& p) : ELEMENT_CLASS(p) { }//whenOpenPropertiesDlgCB = THISBACK( TOpenPropertiesDlg<ElementPropertiesDlg> ); }
		
		template <class PARAM1, class PARAM2>
		GraphElementCtrl_Base(PARAM1& p1, PARAM2 p2) : ELEMENT_CLASS(p1, p2) {}// whenOpenPropertiesDlgCB = THISBACK( TOpenPropertiesDlg<ElementPropertiesDlg> ); }
		
		template <class PARAM1, class PARAM2, class PARAM3>
		GraphElementCtrl_Base(PARAM1& p1, PARAM2 p2, PARAM3 p3) : ELEMENT_CLASS(p1, p2, p3) {}// whenOpenPropertiesDlgCB = THISBACK( TOpenPropertiesDlg<ElementPropertiesDlg> ); }
		
	public:

		virtual void OpenPropertiesDlg(void) {
			whenOpenPropertiesDlgCB();
		}
		
		//virtual bool Contains(PointScreen p) const                { return (_B::_frame.Contains(p)); }
		virtual void LeftDouble (PointScreen p, dword keyflags)   { OpenPropertiesDlg(); }
		virtual void ContextMenu(Bar& bar)                  { bar.Add(t_("Edit properties"), THISBACK(OpenPropertiesDlg)); }
		virtual void RightDown(PointScreen p, dword keyflags)     { MenuBar::Execute(THISBACK(ContextMenu)); }
		virtual Image  CursorImage(PointScreen p, dword keyflags) { return GraphCtrlImg::ACTIVE_CROSS(); }
};




#include "ElementCtrlDecorators.h"


#endif
