#ifndef _GraphCtrl_PropertiesDlgBase_h_
#define _GraphCtrl_PropertiesDlgBase_h_


// ============================================================================================
//                        ElementPropertiesDlgInterface
// ============================================================================================

class ElementPropertiesDlgInterface : public Ctrl {
	public:
		ElementPropertiesDlgInterface() {}
		virtual ~ElementPropertiesDlgInterface() {}
		virtual void Retrieve() = 0;

		typedef Vector<ElementPropertiesDlgInterface*> VList;
};


template <class BASE>
class ElementPropertiesContainer : public BASE {
	private:
		ElementPropertiesDlgInterface::VList elemPropDlgList;

	public:
		ElementPropertiesContainer() {}
		virtual ~ElementPropertiesContainer() {
			ElementPropertiesDlgInterface::VList::Iterator  iter = elemPropDlgList.begin();
			while(iter != elemPropDlgList.end()) {
				delete (*iter);
				++iter;
			}
		}

		int GetCountSubElement() const { return elemPropDlgList.GetCount(); }
		
		template <class ELEMENT, class ESTYLE>
		void AddSubElement(int sepWidth, int& minWidth, int& yOffset, ELEMENT& ELEM_, ESTYLE& STYL_) {
			auto ps = &STYL_;
			Value v = RawToValue(ps);
			
			ElementPropertiesDlgInterface* sdlg = ELEM_.MakePropertiesCtrl( v );
			if (sdlg) {
				sdlg->Transparent();
				elemPropDlgList.Add(sdlg);
				int tmp = sdlg->GetSize().cy;
				minWidth = Upp::max(minWidth, sdlg->GetSize().cx);
				sdlg->HSizePos(sepWidth, sepWidth).TopPos( yOffset, tmp);
				yOffset += tmp + sepWidth;
				BASE::Add(*sdlg);
			}
		}

		template <class ELEMENT, class ESTYLE>
		void AddSubElement(int sepWidth, int& yOffset, ELEMENT& ELEM_, ESTYLE& STYL_) {
			int minWidth = 0;
			AddSubElement<ELEMENT, ESTYLE>(sepWidth, minWidth, yOffset, ELEM_, STYL_);
		}
		
		
		virtual void Retrieve() {
			ElementPropertiesDlgInterface::VList::Iterator iter = elemPropDlgList.begin();
			while(iter != elemPropDlgList.end()) {
				(*iter)->Retrieve();
				++iter;
			}
		}
};

class PropertiesTabBase : public WithElementDlgLayout<ElementPropertiesContainer<ElementPropertiesDlgInterface> > {
	public:
		PropertiesTabBase() { Transparent(); }
		virtual ~PropertiesTabBase() {}
};



class PropertiesBaseDlg : public WithElementPropertiesLayout<ElementPropertiesContainer<TopWindow> > {
	public:
		PropertiesBaseDlg() {
			CtrlLayoutOKCancel(*this, t_("Properties"));
		}
		
		void AdjustSize(int xSize, int propertiesHeight) {
			Size sz = GetSize();
			sz.cy += propertiesHeight;
			sz.cx = xSize;
			this->SetMinSize(sz);
		}
		
		
		virtual ~PropertiesBaseDlg() {}
};


#endif
