#include "CustomGantt.h"

namespace Upp {
namespace GraphDraw_ns {

static const char* DAY_CHAR_SHORT[7] = {"S", "M", "T", "W", "T", "F", "S"};
static const char* DAY_CHAR_LONG[7] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
static const char* MON_CHAR_SHORT[12] = {"J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"};

int QtrNum(int month) {
	int qtr;
	switch(month) {
		case 4 : qtr = 1; break;
		case 7 : qtr = 2; break;
		case 10 : qtr = 3; break;
		case 1 : qtr = 4; break;
		default: qtr = Null;
	}
	return qtr;
}

GanttCtrl::GanttCtrl() {
	_B::SetStyle(StyleDefault());
	
	SetFrame(ThinInsetFrame());

	HideTitle();
	HideX1Markers();
	HideX1Label();
	HideY1Markers();
	HideY1Label();
	HideLegend();

//	SetTopMargin(1).SetLeftMargin(1).SetBottomMargin(1).SetRightMargin(1);
	SetTopMargin(0).SetLeftMargin(0).SetBottomMargin(0).SetRightMargin(0);
	DisableYScroll(true);
	DisableYZoom(true);
	GetElementX1GridAxisDraw().SetElementPos(TOP_OF_GRAPH);
	GetElementY1GridAxisDraw().setAxisInverted();//.SetElementWidth(0);
//	SetYAxisRectWidth(0); // same as GetY1GridAxisDraw().SetElementWidth(0)?
//	GetY1GridAxisDraw().SetMajorTickLength(0); // to hide tickmarks, doesn't work!
}

CH_STYLE(GanttCtrl, Style, StyleDefault) {
	gdStyle        = GanttCtrl::CH_EmptyGraphDraw::StyleGDDefault();
	x1LabelStyle   = GanttCtrl::TypeLabelX1::StyleGEXAxisDefault();
	x1AxisStyle    = GanttCtrl::TypeGridAxisX1::StyleGEDefault();
	y1LabelStyle   = GanttCtrl::TypeLabelY1::StyleGEYAxisDefault();
	y1AxisStyle    = GanttCtrl::TypeGridAxisY1::StyleGEDefault();
	titleStyle     = GanttCtrl::TypeLabelTitle::StyleGETitleDefault();
	legendStyle    = GanttCtrl::TypeLegend::StyleGEDefault();
	x1MarkerStyle  = GanttCtrl::TypeMarkerX1::StyleGEDefault();
	y1MarkerStyle  = GanttCtrl::TypeMarkerY1::StyleGEDefault();
}


GanttBar::GanttBar(int row, const S_ACTIVITIES* ac) : _B(row, ac) {
	pl_bar.left = GetSysDate().Get(); //act->START_DATE_PL.Get();
	pl_bar.right = GetSysDate().Get()+10; //act->END_DATE_PL.Get();
	pl_bar.top = row_num + 0.2;
	pl_bar.bottom = row_num + 0.8;

	ac_bar.left = pr_bar.left = GetSysDate().Get(); //act->START_DATE_AC.Get();
	ac_bar.right = GetSysDate().Get()+10; // act->END_DATE_AC.Get();
	ac_bar.top = row_num + 0.3;
	ac_bar.bottom = row_num + 0.7;
	
	Date progDt = GetSysDate(); //AddWorkDays(act->START_DATE_AC, fround(act->PROGRESS * act->DURATION_AC / 100));
	pr_bar.right = progDt.Get();
	pr_bar.top = row_num + 0.45;
	pr_bar.bottom = row_num + 0.55;
}

bool GanttBar::Intersects(const RectGraph& graphView) const {
	return graphView.Intersects(pl_bar) || graphView.Intersects(ac_bar);
}

bool GanttBar::Contains(const PointGraph& pt) const {
//	return pl_bar.Contains(pt) || ac_bar.Contains(pt);
	return false;
}

void GanttBar::PaintDataPoint(BufferPainter& dw, int scale,
		const CoordinateConverter* xCoordConv, const CoordinateConverter* yCoordConv) {
			
//	const TypeScreenCoord pl_left = xCoordConv->toScreen(pl_bar.left);
//	const TypeScreenCoord pl_right = xCoordConv->toScreen(pl_bar.right);
//	const TypeScreenCoord pl_top = yCoordConv->toScreen(pl_bar.top);
//	const TypeScreenCoord pl_bottom = yCoordConv->toScreen(pl_bar.bottom);
//	Rect pl_r(pl_left, pl_top, pl_right, pl_bottom);
//	ChPaint(dw, pl_r, IsNull(act->CHI_IDS) ? LtBlue() : Gray());
//
//	const TypeScreenCoord ac_left = xCoordConv->toScreen(ac_bar.left);
//	const TypeScreenCoord ac_right = xCoordConv->toScreen(ac_bar.right);
//	const TypeScreenCoord ac_top = yCoordConv->toScreen(ac_bar.top);
//	const TypeScreenCoord ac_bottom = yCoordConv->toScreen(ac_bar.bottom);
//	Rect ac_r(ac_left, ac_top, ac_right, ac_bottom);
//	ChPaint(dw, ac_r, IsNull(act->CHI_IDS) ? Blue() : Black());
//
//	const TypeScreenCoord pr_left = xCoordConv->toScreen(pr_bar.left);
//	const TypeScreenCoord pr_right = xCoordConv->toScreen(pr_bar.right);
//	const TypeScreenCoord pr_top = yCoordConv->toScreen(pr_bar.top);
//	const TypeScreenCoord pr_bottom = yCoordConv->toScreen(pr_bar.bottom);
//	Rect pr_r(pr_left, pr_top, pr_right, pr_bottom);
//	ChPaint(dw, pr_r, act->PROGRESS == 100 ?  LtGreen() : Yellow());
}

GanttArrow::GanttArrow(int row, const S_ACTIVITIES* ac, Vector<int> predRows,
	Vector<Date> predDates) : _B(row, ac) {
	
//	for(int i = 0; i < predRows.GetCount(); i++) { // each predecessor row
//		int predRow = predRows[i];
//		RectGraph r;
//		r.top = predRow + 0.5;
//		r.bottom = row_num + (predRow < row_num ? 0.2 : 0.8);
//		r.left = predDates[i].Get();
//		r.right = act->START_DATE_PL.Get();
////		if(r.left == r.right) r.right += 0.5;
//		arrow_rects.Add(r);
//	}
}

bool GanttArrow::Intersects(const RectGraph& graphView) const {
//	for(int i = 0; i < arrow_rects.GetCount(); i++) { // each arrow rect
//		RectGraph r = arrow_rects[i];
//		if(graphView.Intersects(r)) return true;
//	}
	return false;
}

void GanttArrow::PaintDataPoint(BufferPainter& dw, int scale, const CoordinateConverter* xCoordConv, const CoordinateConverter* yCoordConv) {

//	for(int i = 0; i < arrow_rects.GetCount(); i++) { // each arrow rect
//		RectGraph rg = arrow_rects[i];
//		
//		TypeScreenCoord left = xCoordConv->toScreen(rg.left);
//		TypeScreenCoord right = xCoordConv->toScreen(rg.right) + 5;
//		TypeScreenCoord top = yCoordConv->toScreen(rg.top);
//		TypeScreenCoord bottom = yCoordConv->toScreen(rg.bottom);
//
//		Color arrowCol = GrayColor(64);
//		Rect rs(left, top, right, bottom);
//		dw.DrawLine(rs.TopLeft(), rs.TopRight(), 1, arrowCol);
//		dw.DrawLine(rs.TopRight(), rs.BottomRight()-Point(0,4), 1, arrowCol);
//		
//		Vector<Point> arrow;
//		int dn = sgn(rs.top - rs.bottom);
//		arrow << rs.BottomRight() << rs.BottomRight()+Point(-2,dn*4)
//			<< rs.BottomRight()+Point(2,dn*4);
//		dw.DrawPolygon(arrow, arrowCol);
//	}
}

void GanttBarSeries::DrawBars(){
//	if(!gantt_bars.IsEmpty()) gantt_bars.Clear();
//	for(int i = 0; i < array->GetCount(); i++)
//		gantt_bars.Add(GanttBar(i, &ActById(array->Get(i, ACT_ID))));
}

void GanttArrowSeries::DrawArrows() {
//	if(!gantt_arrows.IsEmpty()) gantt_arrows.Clear();
//	for(int i = 0; i < array->GetCount(); i++) {
//		int actID = array->Get(i, ACT_ID);
//		String sPredIDs = ActById(actID).PRE_IDS;
//		if(IsNull(sPredIDs)) continue;
//		
//		Vector<int> predIDs = StrToVec(sPredIDs);
//		Vector<int> predRows;
//		Vector<Date> predDates;
//		for(int predID : predIDs) {
//			predRows << array->Find(predID, ACT_ID); // time consuming?
//			predDates << ActById(predID).END_DATE_PL;
//		}
//		DUMP(predRows);
//		DUMP(predDates);
//		gantt_arrows.Add(GanttArrow(i, &ActById(actID), pick(predRows), pick(predDates)));
//	}
}

void GanttXGridAxisDraw::SetGanttGridSteps(){
	DUMP("SetGanttGridSteps");

	setAxisTextFormat(THISBACK(FormatAsDateCbk));
	GetGridStepManager().setCustomGridSteps(THISBACK(GanttGridStepCalcCbk));
}

void GanttXGridAxisDraw::FormatAsDateCbk(const const_GridStepIterator& iter, String& output){
	DUMP("FormatAsDateCbk");

	if(iter->drawTickText) {
		Date d;
		d.Set(int(iter->stepGraphValue));
		
		if(gridMode == LONG_WEEK || gridMode == SHORT_WEEK) {
			int dw = DayOfWeek(d);
			if(iter->tickLevel == 3)
				output = Format(d);
			else {
				if(gridMode == LONG_WEEK)
					output << DAY_CHAR_LONG[dw];
				else if(gridMode == SHORT_WEEK)
					output << DAY_CHAR_SHORT[dw];
			}
		}
		else if(gridMode == LONG_MONTH || gridMode == SHORT_MONTH) {
			if(iter->tickLevel == 3)
				output = Format("%Mon/%d", d.month, d.year);
			else
				output = Format("%02d", d.day);
		}
		else if(gridMode == QUARTER) {
			if(iter->tickLevel == 3)
				output << "Qtr " << QtrNum(d.month) << " " << d.year;
			else
				output << Format("%Mon", d.month);
		}
		else if(gridMode == LONG_YEAR) {
			if(iter->tickLevel == 3)
				output << d.year;
			else
				output << MON_CHAR_SHORT[d.month-1];
		}
		else if(gridMode == SHORT_YEAR) {
			if(iter->tickLevel == 3)
				output << d.year;
			else
				output << "Q" << QtrNum(d.month);
		}
	}
}


void GanttXGridAxisDraw::GanttGridStepCalcCbk(GridStepManager& gridStepManager, CoordinateConverter& coordConv){
		
	DUMP("GanttGridStepCalcCbk");

	Date graphStartDate;
	graphStartDate.Set((int)coordConv.getGraphMin());
	Date graphEndDate;
	graphEndDate.Set((int)coordConv.getGraphMax());
	GridStepData* gridStepData = gridStepManager.GetGridStepData();

	int graphStart = coordConv.toScreen(graphStartDate.Get());
	daySpacing = coordConv.toScreen((graphStartDate + 1).Get())	- graphStart;
	int weekSpacing = coordConv.toScreen((graphStartDate + 7).Get()) - graphStart;
	int monthSpacing = coordConv.toScreen((graphStartDate + 30).Get()) - graphStart;
	int yearSpacing = coordConv.toScreen((graphStartDate + 365).Get()) - graphStart;

	if(daySpacing > 30) gridMode = LONG_WEEK;
	else if(daySpacing > 17) gridMode = SHORT_WEEK;
	else if(weekSpacing > 70) gridMode = LONG_MONTH;
	else if(weekSpacing > 25) gridMode = SHORT_MONTH;
	else if(monthSpacing > 28) gridMode = QUARTER;
	else if(yearSpacing > 220) gridMode = LONG_YEAR;
	else gridMode = SHORT_YEAR;
	
	int c = 0;
	Date d(graphStartDate + 1);
	for (; (d <= graphEndDate) && (c < GridStepManager::NB_MAX_STEPS); ++d)	{
		int dw = DayOfWeek(d);

		if(gridMode == SHORT_WEEK || gridMode == LONG_WEEK) {
			gridStepData[c].drawTickText = true;
			gridStepData[c].tickLevel = 2; // tick level 2 for days
			gridStepData[c++].stepGraphValue = d.Get();
	
			if(dw == 1) {
				gridStepData[c].drawTickText = true;
				gridStepData[c].tickLevel = 3; // tick level 3 for weeks
				gridStepData[c++].stepGraphValue = d.Get();
			}
		}
		else if(gridMode == SHORT_MONTH || gridMode == LONG_MONTH) {
			if((gridMode == SHORT_MONTH && dw == 1) ||
				(gridMode == LONG_MONTH && (dw == 1 || dw == 3 || dw == 5))) {
				gridStepData[c].drawTickText = true;
				gridStepData[c].tickLevel = 2; // tick level 2 for dates
				gridStepData[c++].stepGraphValue = d.Get();
			}

			if(d.day == 1) {
				gridStepData[c].drawTickText = true;
				gridStepData[c].tickLevel = 3; // tick level 3 for months
				gridStepData[c++].stepGraphValue = d.Get();
			}
		}
		else if(gridMode == QUARTER) {
			if(d.day == 1) {
				gridStepData[c].drawTickText = true;
				gridStepData[c].tickLevel = 2; // tick level 2 for months
				gridStepData[c++].stepGraphValue = d.Get();
			}

			if(d.day == 1 && (d.month == 1 || d.month == 4 || d.month == 7 || d.month == 10)) {
				gridStepData[c].drawTickText = true;
				gridStepData[c].tickLevel = 3; // tick level 3 for quarter
				gridStepData[c++].stepGraphValue = d.Get();
			}
		}
		else if(gridMode == LONG_YEAR) {
			if(d.day == 1) {
				gridStepData[c].drawTickText = true;
				gridStepData[c].tickLevel = 2; // tick level 2 for months
				gridStepData[c++].stepGraphValue = d.Get();
			}

			if(d.day == 1 && d.month == 1) {
				gridStepData[c].drawTickText = true;
				gridStepData[c].tickLevel = 3; // tick level 3 for year
				gridStepData[c++].stepGraphValue = d.Get();
			}
		}
		else if(gridMode == SHORT_YEAR) {
			if(d.day == 1&& (d.month == 1 || d.month == 4 || d.month == 7 || d.month == 10)) {
				gridStepData[c].drawTickText = true;
				gridStepData[c].tickLevel = 2; // tick level 2 for quarter
				gridStepData[c++].stepGraphValue = d.Get();
			}

			if(d.day == 1 && d.month == 1) {
				gridStepData[c].drawTickText = true;
				gridStepData[c].tickLevel = 3; // tick level 3 for year
				gridStepData[c++].stepGraphValue = d.Get();
			}
		}

		if(d == GetSysDate()) {
			gridStepData[c].drawTickText = false;
			gridStepData[c].tickLevel = 4; // tick level 4 for today
			gridStepData[c++].stepGraphValue = d.Get();
		}

		if(gridMode < 4 && IsHoliday(d)) {
			gridStepData[c].drawTickText = false;
			gridStepData[c].tickLevel = 5; // tick level 5 for holiday
			gridStepData[c++].stepGraphValue = d.Get();
		}
	}
	
	gridStepManager.SetNbSteps(c-1);
}

void GanttXGridAxisDraw::PaintAxisTop(Draw& dw, const int scale, const_GridStepIterator iter, const_GridStepIterator endIter) {
		
	Font scaledAxisTextFont(style->axisTextFont);
	if (scale>1) scaledAxisTextFont.Height(scale*scaledAxisTextFont.GetHeight());

	dw.DrawLineOp(_coordConverter.getScreenMin(), _B::GetElementWidth()*scale,
		_coordConverter.getScreenMax(), _B::GetElementWidth()*scale,
		style->axisWidth*scale, style->axisColor);

	dw.DrawLineOp(_coordConverter.getScreenMin(), _B::GetElementWidth()/2*scale,
		_coordConverter.getScreenMax(), _B::GetElementWidth()/2*scale, 1, style->axisColor);

	while (iter != endIter) {
		if(iter->tickLevel == 2) {
			TypeScreenCoord x;
			x = iter;

			dw.DrawLineOp(x, _B::GetElementWidth()*scale, x, _B::GetElementWidth()/2*scale,
				1, style->axisColor);
			
			String text;
			_formatTextCbk(iter, text);
			Size sz = GraphDraw_ns::GetSmartTextSize(text, scaledAxisTextFont, scale);
			GraphDraw_ns::DrawSmartText(dw, x+1, _B::GetElementWidth()*scale*3/4-(sz.cy/2),
				sz.cx, text, scaledAxisTextFont, style->axisTextColor, scale);
		}
		else if(iter->tickLevel == 3) {
			TypeScreenCoord x;
			x = iter;

			dw.DrawLineOp(x, 0, x, _B::GetElementWidth()*scale/2, 1, style->axisColor);
			
			String text;
			_formatTextCbk(iter, text);
			Size sz = GraphDraw_ns::GetSmartTextSize(text, scaledAxisTextFont, scale);
			GraphDraw_ns::DrawSmartText(dw, x+1, _B::GetElementWidth()*scale/4-(sz.cy/2),
				sz.cx, text, scaledAxisTextFont, style->axisTextColor, scale);
		}
		else if (iter->tickLevel >= NB_TICKMARKS || _tickMarks[iter->tickLevel].IsEmpty()) {
			PaintTickText(dw, TOP_OF_GRAPH, iter, iter.toScreen(),
				(_B::GetElementWidth()-4)*scale, style->axisTextColor, scaledAxisTextFont, scale);
		}
		else {
			_tickMarks[iter->tickLevel]->Paint(dw, TOP_OF_GRAPH, scale, iter,
				_B::GetElementWidth()*scale, style->axisTickColor );

			PaintTickText(dw, TOP_OF_GRAPH, iter, iter.toScreen(),
				(_B::GetElementWidth()-_tickMarks[0]->GetTickLength()-2)*scale,
					style->axisTextColor, scaledAxisTextFont, scale);
		}
		
		++iter;
	}
}

void GanttXGridAxisDraw::PaintHGrid(Draw& dw, int yRange, const_GridStepIterator iter,
	const_GridStepIterator endIter) {
		
	if (!style->gridColor.IsNullInstance())	{
		while(iter != endIter) {
			if(iter->tickLevel == 4)
				dw.DrawLineOp(iter, 0, iter, yRange, PEN_DOT, Green());
			if(iter->tickLevel == 5) {
				int gridThick = Upp::max(1, daySpacing - 1);
				dw.DrawLineOp(iter+daySpacing/2, 0, iter+daySpacing/2, yRange,
					gridThick, style->gridColor);
			}
			
			++iter;
		}
	}
}

void GanttYGridAxisDraw::SetGanttGridSteps(){
	GetGridStepManager().setCustomGridSteps(THISBACK(GanttGridStepCalcCbk));
}

void GanttYGridAxisDraw::GanttGridStepCalcCbk(GridStepManager& gridStepManager,
	CoordinateConverter& coordConv) {
	
	int graphStartRow = (int)coordConv.getGraphMin();
	int graphEndRow = (int)coordConv.getGraphMax();
	GridStepData* gridStepData = gridStepManager.GetGridStepData();

	int c = 0;
	for (int i = graphStartRow+1; (i <= graphEndRow) && (c < GridStepManager::NB_MAX_STEPS); ++i){
		gridStepData[c].tickLevel = 6; // to hide tick marks; should have better way with cham
		gridStepData[c].stepGraphValue = i;
		gridStepData[c++].drawTickText = false;
	}
	gridStepManager.SetNbSteps(c-1);
}

} // namespace GraphDraw_ns
} // namespace Upp
