#ifndef _GraphDraw_ScatterDataSource_h_
#define _GraphDraw_ScatterDataSource_h_

namespace GraphDraw_ns {
	// =========================================================
	//    TEST CLASSES
	// =========================================================
	class ScatterData : public CustomData {
		public:
			DataSource* pD;

			
//			ScatterData(double deb, double fin, int prio=0, double haut=10, Value style=Color(113, 255, 255) )
//			{
//			}
			
			ScatterData()
			{
			}
			
			void Init()
			{
			}
			
			virtual ~ScatterData() {}

			virtual bool Intersects(const RectGraph& graphView) const { return false; };
			virtual bool Contains(const PointGraph& pt) const { return false; };
			virtual void PaintDataPoint(BufferPainter& dw, int scale, const CoordinateConverter* xCoordConv, const CoordinateConverter* yCoordConv ) const {};
	};
	
	class ScatterDataSource : public CustomDataSource
	{
		private:
			DataSource* pD;
			bool owns;
			
			ScatterData scatterData; // TODO  a corriger
		
		public:
			bool sequential;
			unsigned int sequentialPointsRangeMin;
			unsigned int sequentialPointsRangeMax;

			unsigned int nbVisiblePoints;

			String legend;
			int id;
			CoordinateConverter* xConverter;
			CoordinateConverter* yConverter;
			bool show;
			
			// plot
			One<SeriesPlot> seriesPlot;
			double thickness;
			Color color;
			String dash;

			// Mark
			One<MarkPlot> markPlot;
			double markWidth;
			Color markColor;
			
			// Filling
			Color fillColor;
			double opacity;
			
			Image serieIcon; // image shown in LEGENDs & MENUs

			Vector< PointGraph > p1;

		public:
			ScatterDataSource()
			{
				owns = false;
				pD = 0;
				color = Null;
				thickness = 1;
				legend = "";
				opacity = 1;
				sequential = true;
				sequentialPointsRangeMin = 0;
				sequentialPointsRangeMax = 0;
				nbVisiblePoints = 0;
				dash = LINE_SOLID;
//				seriesPlot;// = new LineSeriesPlot();
//				markPlot;  // = new CircleMarkPlot();
				markWidth = 8;
				markColor = Null;
				fillColor = Null;
				xConverter = 0;
				yConverter = 0;
				show = true;
			}
			
			virtual ~ScatterDataSource() { if(pD && owns) delete pD; }
			
			virtual unsigned int GetCount() const { if (pD) return (unsigned int)(pD->GetCount()); else return 0; }
			virtual const CustomData& Get(unsigned int dataIndex) const { return scatterData; } // TODO  a corriger
			virtual       CustomData& Get(unsigned int dataIndex)       { return scatterData; } // TODO  a corriger
			
			virtual void PaintSerie(BufferPainter& dw, int scale, const CoordinateConverter* xCoordConv, const CoordinateConverter* yCoordConv );
			virtual void PaintOne(unsigned int index, int style, BufferPainter& dw, int scale, const CoordinateConverter* xCoordConv, const CoordinateConverter* yCoordConv ) const	{}
			virtual bool Contains(PointGraph p, unsigned int& pIndexOut) const {	return false; }

			//ScatterData& operator[](int dataIndex) { return data[dataIndex]; }

//			virtual bool IsCtrlable() const { return true; }
//			virtual bool LeftDown   (unsigned int pIndex, PointGraph p, dword keyflags); // select / unselect
//			virtual bool LeftDouble (unsigned int pIndex, PointGraph p, dword keyflags);
//			virtual bool CursorImage(unsigned int pIndex, PointGraph p, dword keyflags, Image& outImg ) const;

			ScatterDataSource& SetSerieDataSource(DataSource *pointsData, bool ownsData = true) {
				pD = pointsData;
				owns = ownsData;
				//_isDataModified = true;
				return *this;
			}

			inline const DataSource *PointsData() const	{ return pD; }
			inline       DataSource *PointsData() { return pD; }

		public:
			
			hash_t GetHashValue() const {
				CombineHash hash;
				hash << color << thickness << opacity << dash << legend << pD;
				hash << markWidth << markColor << fillColor << show;
				return hash;
			}
			
			void Init(int id, bool setDefaultStyles)
			{
				color = GetNewColor(id);
				markColor = Color(max(color.GetR()-30, 0), max(color.GetG()-30, 0), max(color.GetB()-30, 0));
				if (setDefaultStyles) SetDefaultStyles(id);
			}

			void SetDefaultStyles(int id)
			{
				dash = GetNewDash(id);
				markPlot = GetNewMarkPlot(id);
				seriesPlot = GetNewPlotStyle(id);
			}

			Image MakeSerieIcon( Size sz, const int scale ) {
				RGBA bckgColor;   bckgColor.r = 0; bckgColor.g = 0; bckgColor.b = 0; bckgColor.a = 0;
				int width = sz.cx;
				int height = sz.cy;
				ImageBuffer ib( sz );
				Fill( ib.Begin(), bckgColor, ib.GetLength() );

				Vector< PointGraph > pts;
				int painterMode = MODE_ANTIALIASED;
				if ( !seriesPlot.IsEmpty() && !color.IsNullInstance() ) {
					// draw multiple points ONLY if lines are drawn
					pts << PointScreen((width*2)/32,(height*2)/32) << PointScreen((width*10)/32,(height*20)/32) << PointScreen((width*20)/32,(height*12)/32) << PointScreen((width*30)/32,(height*30)/32);
				}
				else {
					// lines not drawn ==> only one point in serie ( CENTERED )
					pts << PointScreen(width/2,height/2);
					painterMode = MODE_SUBPIXEL;
				}

				BufferPainter dw(ib, painterMode );
				
				// Draw lines
				if ( !seriesPlot.IsEmpty() ) {
					seriesPlot->Paint(dw,
	                                 pts,
	                                 scale,
	                                 opacity,
	                                 fround(thickness),
	                                 color,
	                                 dash,
	                                 Null,
	                                 fillColor,
	                                 1,
	                                 1,
	                                 32,
					                 10, false);
				}
				// Draw marks
				if ( markWidth >= 1 && markPlot && !markPlot.IsEmpty()) {
					for (int c=0; c<pts.GetCount(); ++c)
					{
						markPlot->Paint(dw,
		                               scale,
		                               pts[c],
		                               markWidth,
		                               markColor,
		                               markWidth,
		                               markColor);
					}
				}
				return ib;
			}
			
			Image MakeSerieIcon( int width=16, const int scale=1 ) {
				return MakeSerieIcon(Size(width, width), scale);
			}

			
			const Image& UpdateSerieImage() {
				serieIcon = MakeSerieIcon();
				return serieIcon;
			}
	
			inline const Image& GetSerieIcon() { return serieIcon; }



        // =====================================================
        // =====================================================

			CustomDataSource& AddSeries(DataSource &data) {
//				SeriesConfig &s = series.Add();
//				s.Init(series.GetCount()-1, _setDefaultStylesOnCreate);
//				s.SetSerieDataSource(&data, false);
//				ASSERT(_currentXConverter!=0);
//				s.xConverter = _currentXConverter;
//				ASSERT(_currentYConverter!=0);
//				s.yConverter = _currentYConverter;
//				_isDataModified = true;
				return *this;
			}
			
			CustomDataSource& _AddSeries(DataSource *data) {
//				SeriesConfig &s = series.Add();
//				s.Init(series.GetCount()-1, _setDefaultStylesOnCreate);
//				s.SetSerieDataSource(data);
//				ASSERT(_currentXConverter!=0);
//				s.xConverter = _currentXConverter;
//				ASSERT(_currentYConverter!=0);
//				s.yConverter = _currentYConverter;
//				_isDataModified = true;
				return *this;
			}
	
			template <class C, class ...Targs>
			CustomDataSource& AddSeries(Targs&... args) 	{ return _AddSeries(new C(args...)); }
	
			template <class Y>
			CustomDataSource& AddSeries(Vector<Y> &yData)		{return _AddSeries(new VectorY<Y>(yData));}
			template <class Y>
			CustomDataSource& AddSeries(Upp::Array<Y> &yData)	{return _AddSeries(new ArrayY<Y>(yData));}
			template <class X, class Y>
			CustomDataSource& AddSeries(VectorMap<X, Y> &data)	{return _AddSeries(new VectorMapXY<X, Y>(data));}
			template <class X, class Y>
			CustomDataSource& AddSeries(ArrayMap<X, Y> &data)	{return _AddSeries(new ArrayMapXY<X, Y>(data));}
	};
};



#endif
