#include "main.h"

#define IMAGEFILE <ezcomm/ezcomm.iml>
#include <Draw/iml_source.h>

ezcommwin::ezcommwin() : HIST_DROP_NUM(10)
{
	CtrlLayout(*this, "EZ Comm");
	hist_ip_out.SetDropLines(HIST_DROP_NUM);
	text_out <<= THISBACK(Text_out);
	butt_out <<= THISBACK(Butt_out);
	hist_ip_out.WhenAction = THISBACK(Hist_ip_out);
	hist_port_out.WhenAction = THISBACK(Hist_port_out);
	hist_text_out.WhenAction = THISBACK(Hist_text_out);
}

/*
return value:	true: different; false: duplicate
*/
bool ezcommwin::strict_exam_diff(const DropList &list, const WString &str)
{
	hist_drop_num_t drop_index;

	for (drop_index = 0; drop_index < list.GetCount(); drop_index++)
		if (list.GetValue(drop_index) == str)
			break;
	if (drop_index >= list.GetCount())
		return true;
	return false;
}

bool ezcommwin::HotKey(dword key)
{
	switch (key)
	{
		case 0xd:
			Butt_out();
			return true;
	}
	return false;
}

void ezcommwin::Hist_ip_out()
{
	ip_out.SetText(hist_ip_out.GetValue().ToString());
	ip_out.SetFocus();
}

void ezcommwin::Hist_port_out()
{
	port_out.SetText(hist_port_out.GetValue().ToString());
	port_out.SetFocus();
}

void ezcommwin::Hist_text_out()
{
	text_out.Clear();
	text_out.Set(hist_text_out.GetValue().ToString());
	text_out.SetFocus();
}

void ezcommwin::Butt_out()
{
	if ((0 == ip_out.GetLength()) || (0 == port_out.GetLength()))
	{
		 info.SetLabel("Input IP & port!");
		 if (0 == ip_out.GetLength())
		     ip_out.SetFocus();
		 else
		     port_out.SetFocus();
	}
	else
	{
		if (strict_exam_diff(hist_ip_out, ip_out.GetText()))
			hist_ip_out.Add(ip_out.GetText());
		if (strict_exam_diff(hist_port_out, port_out.GetText()))
			hist_port_out.Add(port_out.GetText());
		hist_text_out.Add(text_out.Get());
	}
}

void ezcommwin::Text_out()
{
	 info.SetLabel("");
}

GUI_APP_MAIN
{
	ezcommwin ezcw;

	ezcw.Run();
}

