#include <Windows.h>
#include <iostream>
#include <string>
#include <sstream>
#include <fstream>
#include <vector>
#include <stdio.h>
#include <stdlib.h>     /* atoi */
#include <exception>
#include "PracticalSocket.h"
#include <chrono>
#include <ctime>
#include <thread>
#include <direct.h>
#include <io.h>
#include <map>


#define BUFFLEN					1024
#define MSG_SEPARATOR ","
char comms_buffer[BUFFLEN];
#define SIGNAL_STATUS_PORT		40001

struct SignalStatus
{
	int sg_ID;
	int sg_Color;
	int sg_Elapsed;
};


//using namespace std;


int main(int argc, char* argv[])
{

	std::cout << "Program Start!!!" << endl;

	UDPSocket signalStatusReceiveSocket(SIGNAL_STATUS_PORT);
	signalStatusReceiveSocket.setNonBlockingMode(true);

	//UDPSocket inSignalSock(Signal_UDP_PORT);
	char inSignalStatusBuf[300];			  // Buffer for echo string
	int recvMsgSize;                  // Size of received message
	string sourceAddress;             // Address of datagram source
	unsigned short sourcePort;        // Port of datagram source

	vector<SignalStatus> signalStatus;

	while (true) {

		try {
			memset(inSignalStatusBuf, 0, 300);
			recvMsgSize = signalStatusReceiveSocket.recvFrom(inSignalStatusBuf, 300, sourceAddress, sourcePort);

			if (recvMsgSize > 0)
			{
				char*p;
				vector<string> tokens;
				double time = 0.0;

				cout << "New Data received is :" << inSignalStatusBuf << endl;
				p = strtok(inSignalStatusBuf, MSG_SEPARATOR);
				while (p != NULL)
				{
					tokens.push_back(string(p));
					p = strtok(NULL, MSG_SEPARATOR);
				}


				if (atoi(tokens[0].c_str()) == 30) {
					int No_SG = atoi(tokens[4].c_str());
					time = atof(tokens[2].c_str());
					signalStatus.clear();

					//for (size_t i = 0; i < No_SG; i++)
					//{
					//	SignalStatus ss_temp;
					//	ss_temp.sg_ID = atoi(tokens[3 * i + 5].c_str());
					//	ss_temp.sg_Color = atoi(tokens[3 * i + 6].c_str());
					//	ss_temp.sg_Elapsed = atoi(tokens[3 * i + 7].c_str());
					//	signalStatus.push_back(ss_temp);
					//}
					cout << "New Signal Status Received at time " << time << endl;
				}
			}


		}
		catch (SocketException &e) {

		}

	}

	system("pause");
	return 0;
	//END HERE!///////////////////////////////////////////////////////////////////////////////////////////
}
