#include <Windows.h>
#include <iostream>
#include <string>
#include <sstream>
#include <fstream>
#include <vector>
#include <stdio.h>
#include <stdlib.h>     /* atoi */
#include <exception>
#include "PracticalSocket.h"
#include <chrono>
#include <ctime>
#include <thread>
#include <direct.h>
#include <io.h>
#include <map>


#define BUFFLEN					1024
#define MSG_SEPARATOR ","
char comms_buffer[BUFFLEN];
#define SIGNAL_STATUS_PORT		40001
#define LOOP_DETECTOR_PORT      6000
#define Signal_UDP_PORT			6001
#define NEW_SIGNAL_REQUEST      6003
#define MSG_TYPE_NEW_MESSAGE    35

struct SignalStatus
{
	int sg_ID;
	int sg_Color;
	int sg_Elapsed;
};

struct LoopCount
{
	int loop_ID;
	int count;
};

//using namespace std;


int main(int argc, char* argv[])
{

	std::cout << "Program Start!!!" << endl;

	UDPSocket signalStatusReceiveSocket(SIGNAL_STATUS_PORT), loopReceiveSocket(LOOP_DETECTOR_PORT), newSignalRequestSocket(NEW_SIGNAL_REQUEST), signalSendSocket;
	signalStatusReceiveSocket.setNonBlockingMode(true);
	signalSendSocket.setNonBlockingMode(true);
	loopReceiveSocket.setNonBlockingMode(true);
	newSignalRequestSocket.setNonBlockingMode(true);

	//UDPSocket inSignalSock(Signal_UDP_PORT);
	char inSignalStatusBuf[300];			  // Buffer for echo string
	int recvMsgSize;                  // Size of received message
	string sourceAddress;             // Address of datagram source
	unsigned short sourcePort;        // Port of datagram source

	vector<SignalStatus> signalStatus;
	vector<LoopCount> loopCount;

	vector<vector<int>> signalSchedules;

	string line;
	ifstream ifs("SignalSchedules.txt");
	while (getline(ifs, line)) {
		int idata;
		std::istringstream iss(line);
		vector<int> signalTemp;
		int temp;
		for (int i = 0; i < 4; i++)
		{
			iss >> idata;
			iss >> temp;
			signalTemp.push_back(idata);
		}
		signalSchedules.push_back(signalTemp);
	}

	//cout << signalSchedules.size() << endl;

	//for (size_t i = 0; i < signalSchedules.size(); i++)
	//{
	//	vector<int> signalTemp = signalSchedules[i];
	//	for (size_t j = 0; j < signalTemp.size(); j++)
	//	{
	//		cout << signalTemp[j] << " ";
	//	}
	//	cout << endl;
	//}

	vector<int> signalSchedule;

	int cycleNo = 0;
	signalSchedule = signalSchedules[cycleNo];

	bool SignalReceived = false;


	//system("pause");
	//return 0;

	while (true) {

		try {
			memset(inSignalStatusBuf, 0, 300);
			recvMsgSize = signalStatusReceiveSocket.recvFrom(inSignalStatusBuf, 300, sourceAddress, sourcePort);

			if (recvMsgSize > 0)
			{
				char*p;
				vector<string> tokens;
				double time = 0.0;

				p = strtok(inSignalStatusBuf, MSG_SEPARATOR);
				while (p != NULL)
				{
					tokens.push_back(string(p));
					p = strtok(NULL, MSG_SEPARATOR);
				}


				if (atoi(tokens[0].c_str()) == 30) {
					int No_SG = atoi(tokens[4].c_str());
					time = atof(tokens[2].c_str());
					signalStatus.clear();

					for (size_t i = 0; i < No_SG; i++)
					{
						SignalStatus ss_temp;
						ss_temp.sg_ID = atoi(tokens[3 * i + 5].c_str());
						ss_temp.sg_Color = atoi(tokens[3 * i + 6].c_str());
						ss_temp.sg_Elapsed = atoi(tokens[3 * i + 7].c_str());
						signalStatus.push_back(ss_temp);
					}
					cout << "New Signal Status Received at time " << time << endl;
				}
			}


		}
		catch (SocketException &e) {

		}

		try {
			memset(inSignalStatusBuf, 0, 300);
			recvMsgSize = loopReceiveSocket.recvFrom(inSignalStatusBuf, 300, sourceAddress, sourcePort);

			if (recvMsgSize > 0)
			{
				char*p;
				vector<string> tokens;
				double time = 0.0;

				p = strtok(inSignalStatusBuf, MSG_SEPARATOR);
				while (p != NULL)
				{
					tokens.push_back(string(p));
					p = strtok(NULL, MSG_SEPARATOR);
				}


				if (atoi(tokens[0].c_str()) == 31) {
					int No_SG = atoi(tokens[3].c_str());
					time = atof(tokens[2].c_str());
					loopCount.clear();

					for (size_t i = 0; i < No_SG; i++)
					{
						LoopCount lc_temp;
						lc_temp.loop_ID = atoi(tokens[2 * i + 4].c_str());
						lc_temp.count = atoi(tokens[2 * i + 5].c_str());
						loopCount.push_back(lc_temp);
					}
					cout << "New Loop Count Received at time " << time << endl;
				}
			}


		}
		catch (SocketException &e) {

		}

		try {
			memset(inSignalStatusBuf, 0, 300);
			recvMsgSize = newSignalRequestSocket.recvFrom(inSignalStatusBuf, 300, sourceAddress, sourcePort);

			if (recvMsgSize > 0)
			{
				//cout << inSignalStatusBuf << endl;
				

				char*p;
				vector<string> tokens;
				double time = 0.0;

				p = strtok(inSignalStatusBuf, MSG_SEPARATOR);
				while (p != NULL)
				{
					tokens.push_back(string(p));
					p = strtok(NULL, MSG_SEPARATOR);
				}

				if (atoi(tokens[0].c_str()) == 34) {
					int sg_requested = atoi(tokens[1].c_str());
					if (sg_requested == 1) {
						SignalReceived = true;

						cout << " Received New signal requested with message ID of 34" << endl;
					}
				}
			}


		}
		catch (SocketException &e) {

		}

		if (SignalReceived) {
			stringstream ss;

			ss << MSG_TYPE_NEW_MESSAGE << MSG_SEPARATOR << signalSchedule.size() << MSG_SEPARATOR;

			for (size_t i = 0; i < signalSchedule.size(); i++)
			{
				ss << MSG_SEPARATOR << signalSchedule[i];
			}

			string signalToSend = ss.str();
			memset(comms_buffer, 0, BUFFLEN);
			sprintf_s(comms_buffer, BUFFLEN, "%s\n",
				signalToSend.c_str());

			signalSendSocket.sendTo(comms_buffer, strlen(comms_buffer) + 1, "localhost", Signal_UDP_PORT);
			SignalReceived = false;
			cout << " New signal schedule sent" << endl;

			if (cycleNo < signalSchedules.size()-1) {
				cycleNo++;
				signalSchedule = signalSchedules[cycleNo];
			}
		}


	}

	system("pause");
	return 0;
	//END HERE!///////////////////////////////////////////////////////////////////////////////////////////
}
