#include <CtrlLib/CtrlLib.h>
using namespace Upp;

#define LAYOUTFILE <MtAltExample1/MainWindow.lay>
#include <CtrlCore/lay.h>
#include <Urr/Urr.h>

//thread GUI (main application thread)
class MainWindow : public WithMainWindowLayout<TopWindow>
{
public: //thread GUI
	MainWindow();
	
public: //thread Worker
private:
	void UDPRpcServerRecvSignalStatusThread();
};


MainWindow::MainWindow()
{
	CtrlLayout(*this);

	Thread udprpcRecvSigStatus;
	udprpcRecvSigStatus.Run(callback(this, &MainWindow::UDPRpcServerRecvSignalStatusThread));
}

void MainWindow::UDPRpcServerRecvSignalStatusThread()
{
	UrrServer urr;
	
	urr.Create(40001);  //7593<==
	//Cout() << "URR Ping server\n";
	//while(false)
	for(;;) 
	{
		UrrRequest r;
		if(urr.Accept(r)) 
		{
			String signalStatus = ~r;
			
			log.Set(log.Get()+signalStatus);
		}
		//Sleep(200);
	}
}


GUI_APP_MAIN
{
	MainWindow().Sizeable().Run();
}

