#include "Order.h"

#include "util.h"

using namespace std;

Order::Order() {
	rows = new vector<OrderRow*>();
}

Order::~Order() {
	util::cleanVector(*rows);
	delete rows;
}

int Order::getOrderNumber(){
	return order_number;
}

time_t Order::getOrderDate(){
	return this->order_date;
}

time_t Order::getDeliveryDate() {
	return this->delivery_date;
}

int Order::getLastRowLineNumber(){

	int lineNumber=0;

	for (OrderRow * row: * this->rows) {
		int current=row->getRowNumber();
		if(current>lineNumber) lineNumber=current;
	}
	return lineNumber;
}

string Order::getCustomer(){
	return this->customer;
}

time_t Order::getCustomerOrderDate(){
	return this->customer_order_date;
}

string Order::getCustomerOrderNumber(){
	return this->customer_order_number;
}

string Order::getNotes(){
	return this->notes;
}

string Order::getIncoterms(){
	return this->incoterms;
}

string Order::getPayment(){
	return this->payment;
}

string Order::getSalesAgent(){
	return this->sales_agent;
}

double Order::getAgencyOverhead()
{
	return this->agency_overhead;
}

double Order::getDeliveryCosts(){
	return this->delivery_costs;
}

vector<OrderRow*>* Order::getRows() {
	return rows;
}

double Order::getTotalValue(){
	double result=0;
	for(OrderRow* row: *rows){
		result+=row->getQuantity()*row->getUnitPrice();
	}
	return result;
}

int Order::getTotalQuantity()
{
	int result=0;
	for(OrderRow* row: *rows){
		result+=row->getQuantity();
	}
	return result;
}
