#include "testDocumentMapping.h"
#include "testDbSql.h"
#include "util.h"

using namespace std;
using namespace Upp;

Upp::ValueMap * OrderHeaderToMap(Order * order)
{
	int id_header = order->getOrderNumber();
	time_t document_date = order->getOrderDate();
	time_t delivery_date = order->getDeliveryDate();
	string customer = order->getCustomer();
	string customer_order_number = order->getCustomerOrderNumber();
	time_t customer_order_date = order->getCustomerOrderDate();
	string sales_agent = order->getSalesAgent();
	string incoterms = order->getIncoterms();
	string payment = order->getPayment();
	double delivery_cost = order->getDeliveryCosts();
	string notes = order->getNotes();

	ValueMap* map = new ValueMap;

	if(id_header>0) map->Add(Id_Header,id_header);
	if(document_date>0) map->Add(DocumentDate,util::StandardTimeToUppDate(document_date));
	if(delivery_date>0) map->Add(DeliveryDate,util::StandardTimeToUppDate(delivery_date));
	if(!customer.empty()) map->Add(Customer,String(customer));
	if(!customer_order_number.empty()) map->Add(CustomerOrderNumber,String(customer_order_number));
	if(customer_order_date>0) map->Add(CustomerOrderDate,util::StandardTimeToUppDate(customer_order_date));
	if(!sales_agent.empty()) map->Add(SalesAgent,String(sales_agent));
	if(!incoterms.empty()) map->Add(Incoterms,String(incoterms));
	if(!payment.empty()) map->Add(Payment,String(payment));
	if(delivery_cost>0) map->Add(DeliveryCost,delivery_cost);
	if(!notes.empty()) map->Add(Notes,String(notes));

	return map;
}

Upp::ValueMap * OrderBodyToMap(Order *order, OrderRow * row)
{
	int id_header=order->getOrderNumber();
	int row_number = row->getRowNumber();
	string item_code = row->getItemCode();
	int quantity = row->getQuantity();
	double unit_price = row->getUnitPrice();
	string comments = row->getComments();

	ValueMap* map = new ValueMap;

	if(id_header>0) map->Add(Id_Header,id_header);
	if(row_number>0) map->Add(RowNumber,row_number);
	if(!item_code.empty()) map->Add(ItemCode,String(item_code));
	if(quantity>0) map->Add(Quantity,quantity);
	if(unit_price>0) map->Add(UnitPrice,unit_price);
	if(!comments.empty()) map->Add(Comments,String(comments));

	return map;
}
