USE [TestCase]
GO

/****** Object:  Table [dbo].[Header]    Script Date: 24/05/2021 14:52:25 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[Header](
	[Id_Header] [int] NOT NULL,
	[DocumentDate] [smalldatetime] NULL,
	[DeliveryDate] [smalldatetime] NULL,
	[Customer] [char](7) NULL,
	[CustomerOrderNumber] [char](30) NOT NULL,
	[CustomerOrderDate] [smalldatetime] NOT NULL,
	[SalesAgent] [char](30) NULL,
	[Incoterms] [char](3) NOT NULL,
	[Payment] [char](4) NOT NULL,
	[DeliveryCost] [numeric](18, 6) NULL,
	[Notes] [text] NULL,
PRIMARY KEY CLUSTERED 
(
	[Id_Header] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO


USE [TestCase]
GO

/****** Object:  Table [dbo].[Lines]    Script Date: 24/05/2021 14:53:11 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[Lines](
	[RowNumber] [int] NOT NULL,
	[Id_Header] [int] NOT NULL,
	[ItemCode] [char](30) NULL,
	[Quantity] [numeric](18, 6) NULL,
	[UnitPrice] [numeric](18, 6) NULL,
	[Comments] [char](80) NULL,
 CONSTRAINT [PK_Lines] PRIMARY KEY CLUSTERED 
(
	[RowNumber] ASC,
	[Id_Header] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[Lines]  WITH CHECK ADD  CONSTRAINT [FK_Lines_Header] FOREIGN KEY([Id_Header])
REFERENCES [dbo].[Header] ([Id_Header])
GO

ALTER TABLE [dbo].[Lines] CHECK CONSTRAINT [FK_Lines_Header]
GO


