#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>

#include "TestCaseController.h"
#include "Order.h"
#include "CreateOrder.h"

#include <string>
#include <vector>

using namespace std;
using namespace Upp;

#define LAYOUTFILE "testcase.lay"

#include <CtrlCore/lay.h>

using namespace Upp;

int i = 0;

void execute() {
	TestCaseController test;
	i++;
	Order * order = CreateOrder::create(i);
	vector<string> * err_messages = new vector<string>;
	bool result = test.run(order,err_messages);
	PromptOK(AsString(result));

	delete order;
	delete err_messages;
}

GUI_APP_MAIN
{
	WithTestCaseLayout<TopWindow> app;
	CtrlLayoutOK(app, "Microsoft SQL Server test case");
	app.ok.WhenPush = [=] { execute(); };

	app.Run();
}
