#include "TestDAO.h"
#include "TestDocumentMapping.h"
#include "util.h"

using namespace std;
using namespace Upp;

TestDAO::TestDAO(vector<string> * err_messages){
	this->err_messages=err_messages;
}

TestDAO::~TestDAO(){

	if(test_db.IsOpen()){
		test_db.Close();
	}
}

bool TestDAO::OpenDB(){

	String username = "sa";
	String pwd = "icanttel";
	String dbname = "TestCase";
	String server = "myserver\\myinstance";
	String cs = "Driver={SQL Server};Server=" + server +
					";UID=" + username + ";PWD=" + pwd + ";Database=" + dbname + ";";
	if(!test_db.Connect(cs))
	{
		string err="Unable to connect to Arca database due to the following error: " + test_db.GetLastError().ToStd();
		this->err_messages->push_back(err);
		return false;
	}

	test_db.ThrowOnError();
	test_db.LogErrors();
	test_db.SetTrace();

	return true;
}

bool TestDAO::InsertDocument(Order * order) {

	if(order==nullptr) return false;

	ValueMap * vm;
	Sql query(test_db);
	query.ClearError();

	vector<string> lines;
	bool ok = CheckNotes(order,lines);
	if(!ok) return false;

	vm=OrderHeaderToMap(order);
	if(vm!=nullptr){
		InsertDocumentHeader(query,vm);
		delete vm;
	} else {
		return false;
	}

	vector<OrderRow*> * rows=order->getRows();
	int last_line_n=0;
	if(rows==nullptr) return false;
	for(vector<OrderRow*>::iterator it = rows->begin(); it != rows->end(); ++it) {
		vm=OrderBodyToMap(order,*it);
		if(vm!=nullptr){
			InsertDocumentBody(query,vm);
			delete vm;
		last_line_n=(*it)->getRowNumber();
		}
	}

	if(query.WasError()){
		string err="Failed to perform the query, error code: " + query.GetLastError().ToStd();
		this->err_messages->push_back(err);
		return false;
	}

	return true;
}

void TestDAO::InsertDocumentHeader(Sql &sql, ValueMap * vm){
	try{
		sql * Insert(Header)(*vm);
	} catch(SqlExc) {
		string err=sql.GetLastError().ToStd();
		this->err_messages->push_back(err);
	}
}

void TestDAO::InsertDocumentBody(Sql &sql, ValueMap * vm){
	try{
		sql * Insert(Lines)(*vm);
	} catch(SqlExc) {
		string err=sql.GetLastError().ToStd();
		this->err_messages->push_back(err);
	}
}

bool TestDAO::CheckNotes(Order * order, vector<string> & lines)
{
	bool success=true;
	string to_be_checked = order->getNotes();
	to_be_checked.erase(remove(to_be_checked.begin(), to_be_checked.end(), '\r'), to_be_checked.end());
	util::divideByDelimiter(to_be_checked,'\n',lines);
	int i=0;
	for(string line: lines) {
		i++;
		if(line.size()>MAX_CHARS_DESCRIPTION){
			success=false;
			string msg="Line "+to_string(i)+" of invoice notes is too long";
			this->err_messages->push_back(msg);
		}
	}
	return success;
}
