#ifndef _sqlservertestcase_TestDAO_h_
#define _sqlservertestcase_TestDAO_h_

#include <vector>
#include <string>

#include <Core/Core.h>
#include <Sql/Sql.h>
#include <ODBC/ODBC.h>
#include <MSSQL/MSSQL.h>


#include "Order.h"
#include "TestDbSql.h"

class TestDAO {

	private:
		Upp::MSSQLSession test_db;
		std::vector<std::string> * err_messages;

	public:
		TestDAO(std::vector<std::string> * err_messages);
		~TestDAO();

		bool OpenDB();
		bool InsertDocument(Order * order);


	private:
		void InsertDocumentHeader(Upp::Sql &sql, Upp::ValueMap * vm);
		void InsertDocumentBody(Upp::Sql &sql, Upp::ValueMap * vm);
		bool CheckNotes(Order * order, std::vector<std::string> & lines);

};

#endif
