#ifndef _Orders_Order_h_
#define _Orders_Order_h_

#include <ctime>
#include <string>
#include <vector>
#include <Core/Core.h>

#include "util.h"
#include "OrderRow.h"

class Order {

	private:
		int order_number=-1;
		time_t order_date = -1;
		time_t delivery_date = -1;
		std::string customer;
		std::string customer_order_number;
		time_t customer_order_date = -1;
		std::string sales_agent;
		double agency_overhead = 0;
		std::string incoterms;
		std::string payment;
		double delivery_costs = 0;
		std::string notes;

		std::vector<OrderRow*>* rows;

	public:
	
		Order();
		~Order();
		int getOrderNumber();
		time_t getOrderDate();
		time_t getDeliveryDate();
		int getLastRowLineNumber();
		std::string getCustomer();
		time_t getCustomerOrderDate();
		std::string getCustomerOrderNumber();
		std::string getNotes();
		std::string getIncoterms();
		std::string getPayment();
		std::string getSalesAgent();
		double getAgencyOverhead();
		double getDeliveryCosts();
		std::vector<OrderRow*>* getRows();
	
		int getTotalQuantity();
		double getTotalValue();

	friend class CreateOrder;

};



#endif
