#ifndef _sqlservertestcase_util_h_
#define _sqlservertestcase_util_h_

#include <string>
#include <vector>

#include <Core/Core.h>

namespace util {
	void divideByDelimiter(std::string &s, char delimiter, std::vector<std::string>& elements);
	void trim(std::string &str);

	template <class T>
	void cleanVector(std::vector<T*>& deleteme) {
	    while(!deleteme.empty()) {
	        delete deleteme.back();
	        deleteme.pop_back();
	    }
	    deleteme.clear();
	}

	static Upp::Date StandardTimeToUppDate(time_t time) {
		struct tm ptm;
		#ifdef _WIN32
			localtime_s(&ptm, &time);
		#else
			localtime_r(&time, &ptm);
		#endif
		return Upp::Date(ptm.tm_year+1900, ptm.tm_mon+1, ptm.tm_mday);
	}

}

#endif
