#include <Core/Core.h>
#include <iostream>

using namespace Upp;

// -------------------------------------------------------------
String cleanup(String s) {	// removes all white spaces
	String ret = "";
	for(int i = 0; i < s.GetLength(); i++) {
		if((s[i] == ' ') || (s[i] == '\t')) {
		} else {
			ret += s[i];
		}
	}
	return ret;
}
// -------------------------------------------------------------
Vector<String>	getLines(String s) {	// new line at \n
	s = cleanup(s);
	Vector<String> vs;
	vs = Split(s.Begin(), '\n', true);			// split by lines
	return vs;	
}
// -------------------------------------------------------------
String load(char* filename) {
	return LoadFile(GetDataFile(filename));
}
// -------------------------------------------------------------
bool 			save(const char *filename, const String& data) {
	SaveFile(GetDataFile(filename), data);
}
// -------------------------------------------------------------
String 			ToString(const Vector<String>& vs) {
	String 	s;
	int		n = vs.GetCount();
	for(int i = 0; i < n; i++) {
		s += vs[i] + '\n';
	}
	return s;
}
// -------------------------------------------------------------
Vector<String>	transpose(const Vector<String>& vs) {
	Vector<String>				res;	// result
	Vector< Vector<String> > 	ar;		// array
	int							nx, ny;

	// --- splitting up the input -----------------
	nx = vs.GetCount();
	for(int i = 0; i < nx; i++) {
		ar.Add(Split(vs[i], ',', true));	
	}
		
	// --- assembling new output ------------------
	ny = ar[0].GetCount();
	for(int j = 0; j < ny; j++) {
		String s;
		for(int i = 0; i < nx; i++) {
			s += ar[i][j];
			if(i < nx - 1) {s += ",";} // comma, unless last element
		}
		res.Add(s);
	}
	
	return res;
}
// -------------------------------------------------------------


CONSOLE_APP_MAIN
{
	String 			origTable	=
	 load("Tables/input.txt");
	Vector<String>	lines 		= getLines(origTable);	// line-wise
	Vector<String>	trans		= transpose(lines);		// row-wise
	save("Tables/output.txt", ToString(trans));
}

