#include "QrEncode_test.h"

#define IMAGECLASS QrEncode_testImg
#define IMAGEFILE <QrEncode_test/QrEncode_test.iml>
#include <Draw/iml_source.h>


#include <QrEncode_loc/QrEncode.h>
QrEncode_test::QrEncode_test()
{
	CtrlLayoutOK(*this, "QrEncode_test");
	Sizeable().Zoomable();
	str << THISBACK(ImageRecalc);
	im.SetImage(QrEncode_testImg::qrencode());
	Icon(QrEncode_testImg::qrencode());
	str <<= "AIM1234";
	savepng << THISBACK(ImageSavePng);
	
	errorlevel <<= 3;
	version <<= 4;
	pixelsize <<= 4;
	casesensitive <<= true;
	layer <<= 0;
	border <<= 0;
	
	errorlevel << THISBACK(ImageRecalc);
	version << THISBACK(ImageRecalc);
	pixelsize << THISBACK(ImageRecalc);
	casesensitive << THISBACK(ImageRecalc);
	layer << THISBACK(ImageRecalc);
	border << THISBACK(ImageRecalc);

	Refresh();
	
}

void QrEncode_test::ImageSavePng(){
	PNGEncoder png;
	FileSel fs;
	fs.MkDirOption();
	fs.DefaultExt("png");
	fs.Type("PNG image","png");
	fs.AllFilesType();
	if(!fs.ExecuteSaveAs(t_("Enter File Name to save PNG Image")))
		return;
	png.SaveFile(~fs, image);

}

void QrEncode_test::ImageRecalc() {
	Single<QrEncode>().PixelSize(~pixelsize);
	Single<QrEncode>().Border(~border);
	Single<QrEncode>().Layer(~layer);
	
	Single<QrEncode>().ErrorLevel(~errorlevel);
	Single<QrEncode>().Version(~version);
	Single<QrEncode>().CaseSensitive(~ casesensitive);
	int maxqrsize_ = ~maxqrsize;
	if(maxqrsize_ >10) Single<QrEncode>().MaxQrSize(maxqrsize_);
	
	image = Single<QrEncode>().QrEncode_To_Image(~str);
	Error <<= Single<QrEncode>().GetError();
	im.SetImage(image);
	im.Refresh();
	im.Sync();
}

GUI_APP_MAIN
{
	QrEncode_test().Run();
}

