#include "test_custom_fx_sqlite.h"

#include <Core/Core.h>
#include <plugin/sqlite3/Sqlite3.h>
#include <sqlite3.h>


using namespace Upp;


//#ifdef __cplusplus
extern "C" {
//#endif
	void Sqlite3itmCalc(sqlite3_context *context, int argc, sqlite3_value **argv) {
		double n;  
		String t=(const char*)sqlite3_value_text(argv[0]);
		double s= (double)sqlite3_value_double(argv[1]);
		double f= (double)sqlite3_value_double(argv[2]);
		double k = (double)sqlite3_value_double(argv[3]);
		if (t=="C") { n=f*k -s; } 
		else if (t=="P") { n=s- f*k; }

		sqlite3_result_double(context, n);
		return;
	}
//#ifdef __cplusplus
}
//#endif

void RegisterSqliteFunctions(Sqlite3Session& session){
    // all sqlite3_create_function() can be registered here
	::sqlite3* db = (::sqlite3*)(Sqlite3Session::sqlite3*)session;
	// MY FX
	sqlite3_create_function(db, "itmCalc", 4, SQLITE_ANY, 0, Sqlite3itmCalc, 0, 0);
}


CONSOLE_APP_MAIN
{
	Sqlite3Session sqlite3;
	if(!sqlite3.Open(ConfigFile("simple.db"))) {
		Cout() << "Can't create or open database file\n";
		return;
	}
	
#ifdef _DEBUG
	sqlite3.SetTrace();
#endif

	SQL = sqlite3;
	
		// register UDF
		RegisterSqliteFunctions(sqlite3);
	
	SQL.Execute("drop table TEST");
	SQL.ClearError();
	SQL.Execute("create table TEST (ID INTEGER, varT TEXT, varS DOUBLE, varF DOUBLE, varK DOUBLE)");

	for(int i = 0; i < 10; i++) {
		if (i%2==0) {
			SQL.Execute("insert into TEST(ID, varT, varS, varF, varK) values (?, ?, ?, ?, ?)", i, "C", i*100, i, 10);
		}
		else {
			SQL.Execute("insert into TEST(ID, varT, varS, varF, varK) values (?, ?, ?, ?, ?)", i, "P", i*100, i, 10);
		}
	}

	Sql sql;
	sql.Execute("SELECT t.ID, ROUND(itmCalc(t.varT, t.varS, t.varF, t.varK),2) AS IT FROM TEST t");	
	//sql* Select(itmCalc(itmCalc(varT, varS, varF, varK)).From("TEST");		// Model needed !
	//sql* Update(j)(IT, itmCalc(itmCalc(t.varT, t.varS, t.varF, t.varK));
	
	for(int i = 0; i < sql.GetColumns(); i++)
		Cout() << sql.GetColumnInfo(i).name << '\n';
	
	while(sql.Fetch())
		Cout() << sql[0] << " \'" <<sql[1] << "\'\n";		
}

