#include "ScrollBar.h"
//
namespace Upp {

#define LLOG(x) // LOG(x)
// the seven sections on a typical ScrollBar
//enum SBSection{PREV,LEFT=PREV, PREV2, LEFT2=PREV2, UPPER, THUMB, LOWER, 
//	NEXT2,RIGHT2=NEXT2, NEXT, RIGHT=NEXT};
void Sb2(Button::Style& bs, const Image& img)
{
	bs = Button::StyleNormal();
	ChLookWith(bs.look, img, bs.monocolor);
}

#ifndef USE_SCROLLBAR_STYLE
CH_STYLE(SkrollBar, Style, StyleDefault)
{
	arrowsize = ScrollBarArrowSize();
	barsize = FrameButtonWidth();
	thumbmin = 16;
	overthumb = 0;
	through = false;
	CtrlsImageLook(vupper, CtrlsImg::I_SBVU);
	CtrlsImageLook(vthumb, CtrlsImg::I_SBVT, CtrlsImg::SBVI());
	CtrlsImageLook(vlower, CtrlsImg::I_SBVL);
	CtrlsImageLook(hupper, CtrlsImg::I_SBHU);
	CtrlsImageLook(hthumb, CtrlsImg::I_SBHT, CtrlsImg::SBHI());
	CtrlsImageLook(hlower, CtrlsImg::I_SBHL);
	Sb2(up, CtrlsImg::UA());
	Sb2(up2, CtrlsImg::UA());
	Sb2(down, CtrlsImg::DA());
	Sb2(down2, CtrlsImg::DA());
	Sb2(left, CtrlsImg::LA());
	Sb2(left2, CtrlsImg::LA());
	Sb2(right, CtrlsImg::RA());
	Sb2(right2, CtrlsImg::RA());
	isup2 = isdown2 = isleft2 = isright2 = false;
	thumbwidth = Null;
	bgcolor = SColorPaper();
}
#endif

SkrollBar::SkrollBar() {
	minthumb = DPI(16);
	pagepos = pagesize = totalsize = 0;
	linesize = 1;
	autohide = false;
	autodisable = true;
	jump = false;
	track = true;
	horz = false;
	disabled = false;
	thumbsize = 8;
	thumbpos = 0;
	push = light = -1;
	NoWantFocus();
	style = NULL;
	SetStyle(StyleDefault());
	BackPaint();
	is_active = false;
}

SkrollBar::~SkrollBar() {}

void SkrollBar::GetSectionInfo(SectionInfo& info)const
{
	Size sz = GetSize();
	int  s[7], // width/height of each section ,with s[6]=s[0]
		 total;

	int sbo = style->overthumb;
	int ts = thumbsize;
	if(ts < style->thumbmin)
		ts = 0;

	s[2] = thumbpos;
	s[3] = ts + 2 * sbo;
	bool isleft, isright;

	if(IsHorz()) {
		total = sz.cx;
		isleft = style->isleft2;
		isright = style->isright2;
	}
	else {
		total = sz.cy;
		isleft = style->isup2;
		isright = style->isdown2;
	}
	s[0] = s[6] = total > (3 + isleft + isright) * style->arrowsize ? style->arrowsize : 0;
	s[1] = isleft ? s[0] : 0;
	s[5] = isright ? s[0] : 0;
	s[4] = total - 2 * s[0] - s[1] -s[2] - s[3] -s[5] ;
	info.starts[0]=0;
	for( int i=0; i<7; ++i)
		info.starts[i+1] = info.starts[i] + s[i];

}


Rect SkrollBar::Slider(int& cc) const
{
	Size sz = GetSize();
	Rect r;
	if(IsHorz()) {
		cc = sz.cx > (3 + style->isleft2 + style->isright2) * style->arrowsize ? style->arrowsize : 0;
		r = RectC(cc, 0, sz.cx - 2 * cc, sz.cy);
		if(style->isleft2)
			r.right -= cc;
		if(style->isright2)
			r.left += cc;
	}
	else {
		cc = sz.cy > (3 + style->isup2 + style->isdown2) * style->arrowsize ? style->arrowsize : 0;
		r = RectC(0, cc, sz.cx, sz.cy - 2 * cc);
		if(style->isup2)
			r.bottom -= cc;
		if(style->isdown2)
			r.top += cc;
	}
	return r;
}

Rect SkrollBar::Slider() const
{
	int dummy;
	return Slider(dummy);
}

int& SkrollBar::HV(int& h, int& v) const
{
	return IsHorz() ? h : v;
}

int SkrollBar::GetHV(int h, int v) const {
	return IsHorz() ? h : v;
}

Rect SkrollBar::GetPartRect(int p) const {
	Rect h = Slider();
	int sbo = style->overthumb;
	int off = GetHV(h.left, h.top);
	int ts = thumbsize;
	if(ts < style->thumbmin)
		ts = 0;
	switch(p) {
	case 0:
		HV(h.right, h.bottom) = thumbpos - sbo + ts / 2 + off;
		break;
	case 1:
		HV(h.left, h.top) = thumbpos + ts / 2 + sbo + off;
		break;
	case 2:
		if(!IsNull(style->thumbwidth))
			h.Deflate((style->barsize - style->thumbwidth) / 2);
		HV(h.left, h.top) = thumbpos - sbo + off;
		HV(h.right, h.bottom) = thumbpos + ts + sbo + off;
		break;
	}
	return h;
}

void SkrollBar::Paint(Draw& w) {
	SectionInfo info;
	GetSectionInfo(info);
	
	w.DrawRect(GetSize(), style->bgcolor);

	int cc;
	Size sz = style->through ? GetSize() : Slider(cc).GetSize();
	Rect rectslider=sz;
	
	light = GetMousePart();
	int light2=-1;
	if(HasMouseIn(GetSize())){
		Point pt = GetMouseViewPos();
		
		light2 = info.WhichSection(GetHV(pt.x, pt.y));
//		DUMP(light2);
//		DUMP(GetPointSection(pt));
		
	}
//	DUMP(light2);
//	DUMP(light);
	int p = push;
	if(!HasCapture())
		p = -1;
	const Value *hl[] = { style->hlower, style->hupper, style->hthumb };
	const Value *vl[] = { style->vupper, style->vlower, style->vthumb };

	const Value **l = IsHorz() ? hl : vl;

	
	if(!disabled){
		for(int i = 0; i < 3; i++) {
			Rect pr = GetPartRect(i);
			if(i != 2) {
				w.Clip(pr);
				pr = style->through ? GetSize() : Slider();
			}
			if(i != 2 || thumbsize >= style->thumbmin)
				ChPaint(w, pr, l[i][p == i ? CTRL_PRESSED : light == i ? CTRL_HOT : CTRL_NORMAL]);
			if(i != 2)
				w.End();
		}
	}
	else
		if(style->through)
			ChPaint(w, sz, l[0][CTRL_DISABLED]);
		else
		if(IsHorz())
			ChPaint(w, cc, 0, sz.cx, sz.cy, l[0][CTRL_DISABLED]);
		else
			ChPaint(w, 0, cc, sz.cx, sz.cy, l[0][CTRL_DISABLED]);
		
	
	auto vs=[&](int i){
		if(disabled)return CTRL_DISABLED;
		if(light2 == i)return HasCapture() ? CTRL_PRESSED : CTRL_HOT;
		return CTRL_NORMAL;
	};
	if(IsVert())
	{
		Rect r(0,0, info.End(0), cc);
		ChPaint(w, r, style->up.look[vs(0)]);
		if(style->isup2){
			r.top=info.Start(1); r.bottom = info.End(1);
			ChPaint(w, r, style->up2.look[vs(1)]);
		}
		if(style->isdown2)
		{
			r.top=info.Start(5); r.bottom = info.End(5);
			ChPaint(w, r, style->down2.look[vs(5)]);
		}
		r.top = info.Start(6); r.bottom = info.End(6);
		ChPaint(w, r, style->down.look[vs(6)]);
	}else{
		Rect r(0,0, cc, info.End(0));
		ChPaint(w, r, style->left.look[vs(0)]);
		if(style->isleft2){
			r.left=info.Start(1); r.right = info.End(1);
			ChPaint(w, r, style->left2.look[vs(1)]);
		}
		if(style->isright2)
		{
			r.left=info.Start(5); r.right = info.End(5);
			ChPaint(w, r, style->right2.look[vs(5)]);
		}
		r.left = info.Start(6); r.right = info.End(6);
		ChPaint(w, r, style->right.look[vs(6)]);
	}
}

int  SkrollBar::GetMousePart(int pos)const
{
	int q = -1;
	for(int i = 2; i >= 0; i--)
		if(HasMouseIn(GetPartRect(i))) {
			q = i;
			break;
		}
	return q;
}

int  SkrollBar::GetMousePart()
{
	int q = -1;
	for(int i = 2; i >= 0; i--)
		if(HasMouseIn(GetPartRect(i))) {
			q = i;
			break;
		}
	return q;
}

int  SkrollBar::GetRange() const {
	Size sz = Slider().GetSize();
	return GetHV(sz.cx, sz.cy);
}

void SkrollBar::Bounds() {
	int maxsize = GetRange();
	if(thumbsize > maxsize)
		thumbsize = maxsize;
	if(thumbpos + thumbsize > maxsize)
		thumbpos = maxsize - thumbsize;
	if(thumbpos < 0)
		thumbpos = 0;
}

bool SkrollBar::SetThumb(int _thumbpos, int _thumbsize) {
	int ts = thumbsize;
	int tp = thumbpos;
	thumbsize = _thumbsize;
	thumbpos = _thumbpos;
	Bounds();
	if(thumbsize != ts || thumbpos != tp) {
		Refresh();
		return true;
	}
	return false;
}

void SkrollBar::Drag(Point p) {
	if(SetThumb(max(0, IsHorz() ? p.x - delta : p.y - delta), thumbsize) && track)
		Position();
}

void SkrollBar::LeftDown(Point p, dword) {
	SectionInfo info;
	GetSectionInfo(info);
	//int m; // mouse section
	
	{
		Point pt = this->GetMouseViewPos();
		int mpos = GetHV(pt.x, pt.y);
		push = info.WhichSection(mpos);
	}

	LLOG("SkrollBar::LeftDown(" << p << ")");
	LLOG("MousePos = " << GetMousePos() << ", ScreenView = " << GetScreenView()
	<< ", rel. pos = " << (GetMousePos() - GetScreenView().TopLeft()));
	LLOG("GetWorkArea = " << GetWorkArea());
	LLOG("VisibleScreenView = " << GetVisibleScreenView());
	LLOG("PartRect(0) = " << GetPartRect(0));
	LLOG("PartRect(1) = " << GetPartRect(1));
	LLOG("PartRect(2) = " << GetPartRect(2));
	LLOG("SkrollBar::LeftDown: mousepart = " << (int)push << ", rect = " << GetPartRect(push)
		<< ", overthumb = " << style->overthumb << ", slider = " << Slider());
	LLOG("thumbpos = " << thumbpos << ", thumbsize = " << thumbsize);
	switch(push)
	{
	case 0:
	case 1:
		PrevLine();  break;
	case 2:
	case 4:
		if(jump) {
			delta = thumbsize / 2;
			Drag(p);
		}
		else
			if(push==2){
				PrevPage();
			}else
				NextPage();
		break;

	case 3:
		delta = GetHV(p.x, p.y) - thumbpos; break;
	case 5:
	case 6:
		NextLine();
	}
	SetCapture();
	Refresh();
	WhenLeftClick();
}

void SkrollBar::MouseMove(Point p, dword) {
#ifdef _DEBUG
	WhenMouseMove(p);
#endif
	if(HasCapture() && push == 3)
		Drag(p);
	else
	if(light != GetMousePart())
		Refresh();
}

void SkrollBar::MouseEnter(Point p, dword)
{
	Refresh();
}

void SkrollBar::MouseLeave()
{
	Refresh();
}

void SkrollBar::LeftUp(Point p, dword) {
	ReleaseCapture();
	if(!track)
		Position();
	Refresh();
	push = -1;
}

void SkrollBar::LeftRepeat(Point p, dword) {
	if(jump || push < 0 || push == 3) return;
	switch(push)
	{
	case 0:
	case 1:
		PrevLine();  break;
	case 2:
		PrevPage(); break;
	case 4:
		NextPage(); break;
	case 5:
	case 6:
		NextLine();
	}

	Refresh();
}

void SkrollBar::MouseWheel(Point p, int zdelta, dword keyflags)
{
	Wheel(zdelta);
}

void SkrollBar::CancelMode() {
	push = light = -1;
}

bool  SkrollBar::Set(int apagepos) {
	int op = pagepos;
	pagepos = apagepos;
	if(pagepos > totalsize - pagesize) pagepos = totalsize - pagesize;
	if(pagepos < 0) pagepos = 0;
	int slsize = GetRange();
	int mint = max(minthumb, style->thumbmin);
	if(totalsize <= 0)
		SetThumb(0, slsize);
	else {
		double thumbsize = slsize * pagesize / (double) totalsize;
		double rest = slsize * pagesize - thumbsize * totalsize;
		double ts, ps;
		if(thumbsize >= slsize || thumbsize < 0) {
			ts = slsize;
			ps = 0;
		}
		else
		if(thumbsize <= mint) {
			ps = ((slsize - mint) * (double)pagepos + rest) / (double) (totalsize - pagesize);
			ts = mint;
		}
		else {
			ps = (slsize * (double)pagepos + rest) / (double) totalsize;
			ts = thumbsize;
		}
		SetThumb(ffloor(ps), fceil(ts));
    }
	if(pagepos != op) {
		Refresh();
		WhenScroll();
		return true;
	}
	return false;
}

void SkrollBar::Set(int _pagepos, int _pagesize, int _totalsize) {
	pagesize = _pagesize;
	totalsize = _totalsize;
	is_active = totalsize > pagesize && pagesize > 0;
	if(autohide && is_active != IsShown()) {
		Show(is_active);
		WhenVisibility();
	}
	if(autodisable) {
		disabled=!is_active;
	}
	Set(_pagepos);
}

void SkrollBar::SetPage(int _pagesize) {
	Set(pagepos, _pagesize, totalsize);
}

void SkrollBar::SetTotal(int _totalsize) {
	Set(pagepos, pagesize, _totalsize);
}

void SkrollBar::Position() {
	int slsize = GetRange();
	int mint = max(minthumb, style->thumbmin);
	if(slsize < mint || totalsize <= pagesize)
		pagepos = 0;
	else
	if(thumbpos == slsize - thumbsize)
		pagepos = totalsize - pagesize;
	else
	if(thumbsize == mint)
		pagepos = iscale(thumbpos, (totalsize - pagesize), (slsize - mint));
	else
		pagepos = iscale(thumbpos, totalsize, slsize);
	Action();
	WhenScroll();
}

void SkrollBar::Uset(int a) {
	if(Set(a))
		Action();
}

void SkrollBar::PrevLine() {
	Uset(pagepos - linesize);
}

void SkrollBar::NextLine() {
	Uset(pagepos + linesize);
}

void SkrollBar::PrevPage() {
	Uset(pagepos - max(pagesize - linesize, 1));
}

void SkrollBar::NextPage() {
	Uset(pagepos + max(pagesize - linesize, 1));
}

void SkrollBar::Wheel(int zdelta, int lines) {
	Uset(pagepos - lines * linesize * zdelta / 120);
}

void SkrollBar::Wheel(int zdelta) {
	Wheel(zdelta, GUI_WheelScrollLines());
}

bool SkrollBar::VertKey(dword key, bool homeend) {
	if(!IsVisible() || !IsEnabled() || GetRect().IsEmpty())
		return false;
	switch(key) {
	case K_PAGEUP:
		PrevPage();
		break;
	case K_PAGEDOWN:
		NextPage();
		break;
	case K_UP:
		PrevLine();
		break;
	case K_DOWN:
		NextLine();
		break;
	case K_HOME:
		if(!homeend) break;
	case K_CTRL_HOME:
	case K_CTRL_PAGEUP:
		Begin();
		break;
	case K_END:
		if(!homeend) break;
	case K_CTRL_END:
	case K_CTRL_PAGEDOWN:
		End();
		break;
	default:
		return false;
	}
	return true;
}

void SkrollBar::Begin()
{
	Uset(0);
}

void SkrollBar::End()
{
	Uset(max(0, totalsize - pagesize));
}

bool SkrollBar::HorzKey(dword key) {
	if(!IsVisible() || !IsEnabled() || GetRect().IsEmpty())
		return false;
	switch(key) {
	case K_CTRL_LEFT:
		PrevPage();
		break;
	case K_CTRL_RIGHT:
		NextPage();
		break;
	case K_LEFT:
		PrevLine();
		break;
	case K_RIGHT:
		NextLine();
		break;
	case K_HOME:
		Begin();
		break;
	case K_END:
		End();
		break;
	default:
		return false;
	}
	return true;
}

void SkrollBar::Layout() {
	Set(pagepos);
	Refresh();
}

bool SkrollBar::ScrollInto(int pos, int _linesize) {
	int new_pos = pagepos;
	if(pos > new_pos + pagesize - _linesize)
		new_pos = pos - pagesize + _linesize;
	if(pos < new_pos)
		new_pos = pos;
	return Set(new_pos);
}

Size SkrollBar::GetStdSize() const {
	int a = HeaderCtrl::GetStdHeight();
	return Size(a, a);
}

void SkrollBar::FrameLayout(Rect& r)
{
	(IsHorz() ? LayoutFrameBottom : LayoutFrameRight)(r, this, SkrollBarSize());
}

void SkrollBar::FrameAddSize(Size& sz)
{
	(IsHorz() ? sz.cy : sz.cx) += SkrollBarSize();
}

Size SkrollBar::GetViewSize() const {
	if(IsChild() && InFrame()) {
		Size sz = GetParent()->GetSize();
		if(IsShown())
			(IsVert() ? sz.cx : sz.cy) += SkrollBarSize();
		return sz;
	}
	return Size(0, 0);
}

Size SkrollBar::GetReducedViewSize() const {
	if(IsChild() && InFrame()) {
		Size sz = GetParent()->GetSize();
		if(!IsShown())
			(IsVert() ? sz.cx : sz.cy) -= SkrollBarSize();
		return sz;
	}
	return Size(0, 0);
}

SkrollBar& SkrollBar::AutoHide(bool b) {
	autohide = b;
	if(b)
		SetTotal(totalsize);
	else
		Show();
	WhenVisibility();
	return *this;
}

SkrollBar& SkrollBar::AutoDisable(bool b) {
	autodisable = b;
	
	if(!b)
		disabled=false;
	return *this;
}

SkrollBar& SkrollBar::SetStyle(const Style& s)
{
	if(style != &s) {
		style = &s;
		RefreshLayout();
		Refresh();
	}
	return *this;
}

// return the height(width) of prev/next pseudo button in
// a vert(horz) ScrollBar
int	SkrollBar::ht()const
{
	Size sz=GetSize();
	int a,b;
	if(IsHorz()){
		a=sz.cx;
		b=style->isleft2 + style->isright2;
	}else{
		a=sz.cy;
		b=style->isup2 + style->isdown2;
	}
	b+=3;
	return a > b * style->arrowsize ? style->arrowsize : 0;
}

}//eons Upp