#ifndef _SKROLLBAR_SCROLLBAR_H
#define _SKROLLBAR_SCROLLBAR_H

#include <CtrlLib/CtrlLib.h>

#define USE_SCROLLBAR_STYLE

NAMESPACE_UPP
struct SectionInfo{
	int Width(int section)const{
		ASSERT(section>=0 && section<=6);
		return starts[section+1]-starts[section];
	}
	int Start(int section)const{
		ASSERT(section>=0 && section<=7);
		return starts[section];
	}
	int End(int section)const{
		ASSERT(section>=0 && section<=6);
		return starts[section+1];
	}
	String ToString()const{
		String s;
		s << '[' << Width(0);
		for(int i = 1; i < 7; ++i)
		{
			s << ',' << Width(i);
		}
		s << ']';
		return s;
	}
	int WhichSection(int p)const
	{
		int i,q=-1;
		for(i=0; i<8; ++i)
		{
			if(p<starts[i])
				break;
			++q;
		}
		if(q==7)
			q=-1;
		return q;
	}
	int starts[8];
};

class SkrollBar : public FrameCtrl<Ctrl> {
public:
	virtual Size GetStdSize() const;
	virtual void Paint(Draw& draw);
	virtual void LeftDown(Point p, dword);
	virtual void MouseMove(Point p, dword);
	virtual void MouseEnter(Point p, dword);
	virtual void MouseLeave();
	virtual void LeftUp(Point p, dword);
	virtual void LeftRepeat(Point p, dword);
	virtual void MouseWheel(Point p, int zdelta, dword keyflags);
	virtual void CancelMode();
	virtual void Layout();

	virtual void FrameLayout(Rect& r);
	virtual void FrameAddSize(Size& sz);

public:
#ifndef USE_SCROLLBAR_STYLE
	struct Style : ChStyle<Style> {
		Color bgcolor;
		int barsize, arrowsize, thumbmin, overthumb, thumbwidth;
		bool through;
		Value vupper[4], vthumb[4], vlower[4];
		Value hupper[4], hthumb[4], hlower[4];
		Button::Style up, down, left, right;
		Button::Style up2, down2, left2, right2;
		bool          isup2, isdown2, isleft2, isright2;
	};
#else
	typedef Upp::ScrollBar::Style Style; // save the effor for now.
#endif

private:
	int     thumbpos;
	int     thumbsize;
	int     delta;
	int     pagepos;
	int     pagesize;
	int     totalsize;
	int     linesize;
	int     minthumb;

	int8    push;
	int8    light;
	bool    horz:1;
	bool    jump:1;
	bool    track:1;
	bool    autohide:1;
	bool    autodisable:1;
	bool    is_active:1;
	bool	disabled:1;

	const Style *style;

	Rect    Slider(int& cc) const;
	Rect    Slider() const;
	
	void    GetSectionInfo(SectionInfo& info)const;
	
	int&    HV(int& h, int& v) const;
	int     GetHV(int h, int v) const;
	Rect    GetPartRect(int p) const;
	Rect    GetPartRect2(int p) const;
	void    Bounds();
	bool    SetThumb(int _thumbpos, int _thumbsize);
	void    Drag(Point p);
	int     GetMousePart();
	int		GetMousePart(int pos)const;
	int     GetRange() const;

	void    Position();
	void    Uset(int a);

	int     SkrollBarSize() const           { return style->barsize; }
	
	int		ht()const; // return the height(width) of prev/next pseudo button in
						// a vert(horz) ScrollBar
#ifdef _DEBUG
public:
#endif
	int GetPointSection(Point p)
	{
		if(Rect(GetSize()).Contains(p))
		{
			SectionInfo info;
			GetSectionInfo(info);
			int pos=GetHV(p.x,p.y);
			return info.WhichSection(pos);
		}
		return -1;
	}

public:
	Event<>  WhenScroll;
	Event<>  WhenVisibility;
	Event<>  WhenLeftClick;
#ifdef _DEBUG
	Event<Point> WhenMouseMove;
#endif

	bool    IsHorz() const                  { return horz; }
	bool    IsVert() const                  { return !horz; }

	void    Set(int pagepos, int pagesize, int totalsize);

	bool    Set(int pagepos);
	void    SetPage(int pagesize);
	void    SetTotal(int totalsize);
	
	bool    IsActive() const                { return is_active; }

	bool    ScrollInto(int pos, int linesize);
	bool    ScrollInto(int pos)             { return ScrollInto(pos, linesize); }

	bool    VertKey(dword key, bool homeend = true);
	bool    HorzKey(dword key);

	void    PrevLine();
	void    NextLine();
	void    PrevPage();
	void    NextPage();
	void    Begin();
	void    End();

	void    Wheel(int zdelta, int lines);
	void    Wheel(int zdelta);

	Size    GetViewSize() const;
	Size    GetReducedViewSize() const;

	int     Get() const                     { return pagepos; }
	int     GetPage() const                 { return pagesize; }
	int     GetTotal() const                { return totalsize; }
	int     GetLine() const                 { return linesize; }

	static const Style& StyleDefault()
#ifdef USE_SCROLLBAR_STYLE
	{ return Upp::ScrollBar::StyleDefault(); }
#else
	;
#endif

	SkrollBar& Horz(bool b = true)          { horz = b; Refresh(); RefreshLayout(); return *this; }
	SkrollBar& Vert()                       { return Horz(false); }

	SkrollBar& SetLine(int _line)           { linesize = _line; return *this; }

	SkrollBar& Track(bool b = true)         { track = b; return *this; }
	SkrollBar& NoTrack()                    { return Track(false); }
	SkrollBar& Jump(bool b = true)          { jump = b; return *this; }
	SkrollBar& NoJump(bool b = true)        { return Jump(false); }
	SkrollBar& AutoHide(bool b = true);
	SkrollBar& NoAutoHide()                 { return AutoHide(false); }
	bool       IsAutoHide() const           { return autohide; }
	SkrollBar& AutoDisable(bool b = true);
	SkrollBar& NoAutoDisable()              { return AutoDisable(false); }
	SkrollBar& MinThumb(int sz)             { minthumb = sz; return *this; }
	SkrollBar& SetStyle(const Style& s);

	operator int() const                    { return pagepos; }
	int operator=(int pagepos)              { Set(pagepos); return pagepos; }

	SkrollBar();
	virtual ~SkrollBar();
};

inline int SkrollBarSize()                  { return SkrollBar::StyleDefault().barsize; }//!!

END_UPP_NAMESPACE
#endif