#include "CharMap.h"


CharMap::CharMap()
{
	CtrlLayout(*this, "Upp Char Map");
	
	char_list.RowMode().ItemWidth(34).ItemHeight(34);
	char_list.WhenLeftClick = [=]{PreviewChar();};
	
	preview.AlignCenter();
	
	for (int i = 0 ; i < Font::GetFaceCount() ; i++){
		fnt_list.Add(Font::GetFaceName(i));
	}
	fnt_list.SetIndex(0);
	
	fnt_list << [=]{ShowCharMap();};
	ShowCharMap();
}

void CharMap::ShowCharMap(){
	char_list.Clear();
	fnt.Face(fnt_list.GetIndex());
	
	work.Run([=] {
	FontTypeReader r;
	r.Open(fnt);
	char_range.Clear();
	
		for(auto r : r.ranges) {
			for(int c = r.a; c <= r.b; c++) {
				char_range.Add(c);
				GuiLock __;
				char_list.Add(AttrText(WString(c, 1)).SetFont(fnt(20)));
			}
		}
	});
}

void CharMap::PreviewChar(){
	
	fnt.Height(200);
	preview.SetFont(fnt);
	
	int i = char_list.GetCursor();
	String s = char_list.GetValue(i).ToString();
	preview.SetText(s);
	String c = "0x" + FormatIntHex(char_range[i],4);
	uni_lbl.SetText(c);
}

GUI_APP_MAIN
{
	CharMap().Run();
}
