#include "TextToSvgPath.h"

extern int FONT_SIZE;
//#define MARGIN (FONT_SIZE * .5)

struct TextToSvg : FontGlyphConsumer
{
	String t; // here we accumulate the SVG path text

	void Put ( Pointf p );

	virtual void Move ( Pointf p );
	virtual void Line ( Pointf p );
	virtual void Quadratic ( Pointf p1, Pointf p2 );
	virtual void Cubic ( Pointf p1, Pointf p2, Pointf p3 );
	virtual void Close();
};

void TextToSvg::Put ( Pointf p )
{
	t << Format ( "%.2f %.2f ", p.x, p.y );
}

void TextToSvg::Move ( Pointf p )
{
	t << 'M';
	Put ( p );
}

void TextToSvg::Line ( Pointf p )
{
	t << 'L';
	Put ( p );
}

void TextToSvg::Quadratic ( Pointf p1, Pointf p )
{
	t << 'Q';
	Put ( p1 );
	Put ( p );
}

void TextToSvg::Cubic ( Pointf p1, Pointf p2, Pointf p )
{
	t << 'C';
	Put ( p1 );
	Put ( p2 );
	Put ( p );
}

void TextToSvg::Close()
{
	t << 'Z';
}

String TextToSvgPath ( double x, double y, const char *text, Font fnt, bool singleline )
{
	WString ws = ToUnicode ( text, CHARSET_DEFAULT );
	TextToSvg tts;
	LOG ( ".." );

	for ( const wchar *s = ~ws; *s; s++ )
	{
		fnt.Render ( tts, x, y, *s );
		x += fnt[*s]; // move the reference point

		if ( !singleline )
			tts.t << "\n";

		LOG ( "Ch_ : " << Format ( "%04X", *s ) );
	}

	return tts.t;
}

String TextToHbSvgPath ( double x, double y, const char *text, Font fnt, bool singleline )
{
	const char *fontfile;
	TextToSvg tts;

#ifdef LangDEVANAGARI
	fontfile = "/usr/share/fonts/truetype/noto/NotoSans-Regular.ttf";
	int i1 = Font::FindFaceNameIndex("NotoSans");
#endif

#ifdef LangKANNADA
	fontfile = "/usr/share/fonts/truetype/noto/NotoSansKannada-Regular.ttf";
	int i1 = Font::FindFaceNameIndex("NotoSansKannada");
#endif

	Font fntIndic ; //= Font(i1,FONT_SIZE);
	fntIndic = Font(i1,FONT_SIZE);
	
	LOG ( fontfile );

	FT_Library ft_library;
	FT_Face ft_face;
	FT_Error ft_error;
	
	if ( ( ft_error = FT_Init_FreeType ( &ft_library ) ) )
		abort();

	if ( ( ft_error = FT_New_Face ( ft_library, fontfile, 0, &ft_face ) ) )
		abort();
	
	if ( ( ft_error = FT_Set_Char_Size ( ft_face, FONT_SIZE * 64, FONT_SIZE * 64, 0, 0 ) ) )
		abort();

	hb_font_t *hb_font;

	hb_font = hb_ft_font_create ( ft_face, NULL );

	/* Create hb-buffer and populate. */
	hb_buffer_t *hb_buffer;

	hb_buffer = hb_buffer_create ();

	hb_buffer_add_utf8 ( hb_buffer, text, -1, 0, -1 );

	hb_buffer_guess_segment_properties ( hb_buffer );

	/* Shape it! */
	hb_shape ( hb_font, hb_buffer, NULL, 0 );

	/* Get glyph information and positions out of the buffer. */
	unsigned int len = hb_buffer_get_length ( hb_buffer );
	hb_glyph_info_t *info = hb_buffer_get_glyph_infos ( hb_buffer, NULL );
	hb_glyph_position_t *pos = hb_buffer_get_glyph_positions (hb_buffer, NULL);

	for ( unsigned int i = 0; i < len; i++ )
	{
		hb_codepoint_t gid   = info[i].codepoint;
		fntIndic.hbRender ( tts, x, y, gid );
		x += pos[i].x_advance/64.0; // move the reference point

		if ( !singleline )
			tts.t << "\n";
	}
	return tts.t;
}


/*
Devanagari
सन्निहित अन्तर्राष्ट्रीय प्रणाली सम्पत्ति धर्म अनुच्छेद स्थिति अंतर्राष्ट्रीयकरण गतिविधि
वेब की सम्पूर्ण क्षमता के उपयोग की दिशा में अग्रणी

kannada
ಅಂಕಾರಯುತವಾಗಿಯೂ ಕೆತ್ತಲ್ಪಟ್ಟಿವೆ.
*/
