#include "TextToSvgPath.h"
int FONT_SIZE;

void Preview::Paint(Draw& w)
{
	DrawPainter sw(w, GetSize());
	sw.Clear(SWhite());
	sw.Path(svgpath).Fill(SBlue());
}

TextToSvgPathDlg::TextToSvgPathDlg()
{
	CtrlLayout(*this, "Text to SVG path converter");
	
    for(int i = 1; i < Font::GetFaceCount(); i++)
        if(Font::GetFaceInfo(i) & Font::SCALEABLE)
            face.Add(i, Font::GetFaceName(i));

	face <<= Font::SANSSERIF;
#ifdef LangDEVANAGARI
	int fontNoto = Font::FindFaceNameIndex("NotoSans");
	text.SetData(" अ न्त र्रा ष्ट्री य   ग ति  वि  धि    प्र णा ली   स म्प  त्ति   0123456789 ");
#endif

#ifdef LangKANNADA
	int fontNoto = Font::FindFaceNameIndex("NotoSansKannada");
	text.SetData(" ಕನ್ನಡ_ಅಕ್ಷರಮಾಲೆ  0123456789 ");
#endif

	face.SetIndex(fontNoto-1);
	
	height.MinMax(6, 500);
	
	for(int i = 4; i < 500; i += i < 16 ? 1 : i < 32 ? 4 : i < 48 ? 8 : 16)
		height.AddList(i);
	height <<= 32;
	FONT_SIZE = height;
	
	svgpath.SetReadOnly();
	preview.SetFrame(ViewFrame());

	hb_svgpath.SetReadOnly();
	hb_preview.SetFrame(ViewFrame());

	for(Ctrl *q = GetFirstChild(); q; q = q->GetNext())
		if(!dynamic_cast<Button *>(q))
			*q << [=] {
				Font fnt(~face, ~height);
				fnt.Bold(~bold);
				fnt.Italic(~italic);
			
				svgpath <<= preview.svgpath = TextToSvgPath(0, 0, (String)~text, fnt, ~singleline);
				preview.Refresh();
				
				FONT_SIZE = ~height;
				
				hb_svgpath <<= hb_preview.svgpath = TextToHbSvgPath(0, 0, (String)~text, fnt, ~singleline);
				hb_preview.Refresh();
				
			 };
	
	copy.SetImage(CtrlImg::copy());
	copy << [=] {
		WriteClipboardText(preview.svgpath);
	};

	Sizeable().Zoomable();
	text.Action();
}


GUI_APP_MAIN
{
	TextToSvgPathDlg().Run();
}


/*
Devanagari Text
अ न्त र्रा ष्ट्री य   ग ति  वि  धि    प्र णा ली   स म्प  त्ति 

Kannada Text
ಕನ್ನಡ_ಅಕ್ಷರಮಾಲೆ
*/