--- uppsrc/Core/Stream.cpp.orig	Sat Feb 11 17:52:17 2006
+++ uppsrc/Core/Stream.cpp	Sat Feb 11 17:53:21 2006
@@ -1205,15 +1205,15 @@
 void FileStream::SetStreamSize(int64 pos)
 {
 	if(handle < 0) return;
-	loff_t cur = lseek64(handle, 0, SEEK_CUR);
+	off_t cur = lseek(handle, 0, SEEK_CUR);
 	if(cur < 0) {
 		SetLastError();
 		return;
 	}
-	loff_t len = lseek64(handle, 0, SEEK_END);
+	off_t len = lseek(handle, 0, SEEK_END);
 	if(len < 0) {
 		SetLastError();
-		lseek64(handle, cur, SEEK_SET);
+		lseek(handle, cur, SEEK_SET);
 		return;
 	}
 	while(pos > len) {
@@ -1222,24 +1222,24 @@
 		int chunk = (diff > sizeof(buffer) ? sizeof(buffer) : (int)diff);
 		if(write(handle, buffer, chunk) != chunk) {
 			SetLastError();
-			lseek64(handle, cur, SEEK_SET);
+			lseek(handle, cur, SEEK_SET);
 			return;
 		}
 		len += chunk;
 	}
 	if(pos < len) {
 		if(cur > pos)
-			lseek64(handle, cur = pos, SEEK_SET);
-		if(ftruncate64(handle, pos) < 0)
+			lseek(handle, cur = pos, SEEK_SET);
+		if(ftruncate(handle, pos) < 0)
 			SetLastError();
 	}
-	if(lseek64(handle, cur, SEEK_SET) < 0)
+	if(lseek(handle, cur, SEEK_SET) < 0)
 		SetLastError();
 }
 
 void FileStream::SetPos(int64 pos) {
 	ASSERT(IsOpen());
-	if(lseek64(handle, pos, SEEK_SET) < 0)
+	if(lseek(handle, pos, SEEK_SET) < 0)
 		SetLastError();
 }
 
