--- uppsrc/ide/Install.cpp.orig	Mon Feb 13 00:08:00 2006
+++ uppsrc/ide/Install.cpp	Mon Feb 13 00:03:55 2006
@@ -250,6 +250,7 @@
 	String supp;
 	ChkSupp(GetHomeDirFile("upp"), supp);
 	ChkSupp("/usr/local/share/upp", supp);
+	ChkSupp("/usr/X11R6/share/upp", supp);
 	ChkSupp("/usr/local/lib/upp", supp);
 	ChkSupp("/usr/local/bin/upp", supp);
 	ChkSupp("/usr/share/upp", supp);
@@ -260,7 +261,23 @@
 		return true;
 	}
 	Progress pi;
+#ifdef PLATFORM_FREEBSD
+	String upp = FromSystemCharset(getenv("UPP_DIR"));
+	if(IsNull(upp)) {
+	  upp = AppendFileName(FromSystemCharset(getenv("HOME")), "upp");
+	  if (DirectoryExists(upp)) {
+	    Exclamation("Personal Ultimate`+`+ directory not found. Please set variable $UPP`_DIR appropriately.");
+	    return false;
+	  }
+	} else {
+	  if (DirectoryExists(upp)) {
+	    Exclamation("Directory defined in variable $UPP`_DIR already exists. Please define another directory for Ultimate`+`+");
+	    return false;
+	  }
+	}
+#else
 	String upp = GetHomeDirFile("upp");
+#endif
 	String uppsrc;
 	String pp;
 	String out = AppendFileName(upp, "out");
