#include "DrawImageTest.h"

DrawImageTest::DrawImageTest()
{
	CtrlLayout(*this, "DrawImage Test");
	convert_btn << [=] {Convert();};
}

void DrawImageTest::Convert()
{
	FileSel fs_o;
	fs_o.Type("png","*.png");
	if(!fs_o.ExecuteOpen()) return;
	
	Image img = StreamRaster::LoadFileAny(~fs_o);

	int w = img.GetSize().cx;
	int h = img.GetSize().cy;

	PdfDraw draw(w,h);
	draw.DrawImage(0,0,w,h,img);


	FileSel fs_s;
	fs_s.Type("pdf","*.pdf");
	if(!fs_s.ExecuteSaveAs()) return;
	//SaveFile(~fs_s+".pdf", draw.Finish());
	SaveFile(~fs_s, draw.Finish());
	
	
	
}

GUI_APP_MAIN
{
	DrawImageTest().Run();
}
