#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <DeadMutex/DeadMutex.lay>
#include <CtrlCore/lay.h>

class DeadMutex : public WithDeadMutexLayout<TopWindow> {
	
	typedef DeadMutex CLASSNAME;
	
public:
	DeadMutex()
	{
		CtrlLayout(*this, "Window title");
		start.WhenPush = THISFN(Start);
		stop.WhenPush = [this]{ stop_requested = true; };
		WhenClose = [this]{ ShutdownThreads(); Break(); };
	}
	
	
	void Start(){
		static int cnt;
		if( cnt!= 0 )
			return;
		++ cnt;
		stop_requested = false;
		log.Clear();
		badguy.Run([this]{
			log.Append("Badguy running...\n");
			Mutex::Lock _(mut);
			log.Append("Badguy now owns the Mutex.\n");
			while(!stop_requested && !IsShutdownThreads() ){
				Sleep(50);
			}
			log.Append("Stop requested, Badguy exiting and releasing the Mutex...\n");
		});

		// wait for badguy to acquire the mutex
		while(mut.TryEnter()){
			mut.Leave();
			ProcessEvents();
			Sleep(100);
		}

		log.Append("Trying to acquire the mutex...\n");
		GuiAcquireMutex();
		--cnt;
	}
	
	
private:
	Mutex	mut;
	Thread badguy;
	bool stop_requested;


	void GuiAcquireMutex(){
		int i = 0;
		while( !mut.TryEnter() ){
			log.Append(String().Cat()<< "Effort " << ++i << " : failed!\n");
			log.ScrollEnd();
			ProcessEvents();
			Sleep(50);
		}
		log.Append("Successfully acquired mutex!");
		log.Append("But I am releasing it now");
		mut.Leave();
	}
};

GUI_APP_MAIN
{
	DeadMutex().Run();
}
