/***************************************************************************
                          ezcommon  -  description
                             -------------------
    begin                : Aug. 2, 2007
    copyright            : (C) 2007 by Allen
    email                : bon_ami_@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   Explicit Distribution Limitation                                      *
 *   This rule overrides others below.                                     *
 *   This program may not be modified or used by, or, if possible,         *
 *   redistributed to people described as below,                           *
 *   1.Japanese who hold hostility against Chinese.                        *
 *   2.or, those who discriminate against people based solely on race,     *
 *     gender or sexual orientation.                                       *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 *	source code of EZ Comm Project Ultimate++ functionalities
 */

#include "main.h"

#define IMAGEFILE <ezcomm/ezcomm.iml>
#include <Draw/iml_source.h>

ezcommwin::ezcommwin()
{
	/* interface */
	msg.Add("Have a nice day.");
	msg.Add("Bonjour.");
	msg.Add("Salut");
	msg.Add("hallo");
	msg.Add("ciao");
	msg.Add("hola");
	msg.Add("written by Allen");
	msg.Add("a sub-project of EZ Project");
	msg.Add("http://ezproject.sourceforge.net/");
	msg.Add("Windows or Linux, Text or Graphical.");
	msg.Add("Anti-Discrimination");
	msg.Add("under GPL with a couple of exception rules");
	msg.Add("cannot be used by Japanese who hold hostility against Chinese");
	msg.Add("cannot be used by those who have race discrimination");
	msg.Add("cannot be used by those who have gender discrimination");
	msg.Add("cannot be used by those who have sexual orientation discrimination");
	changes = 0;
	Icon(IMAGECLASS::Get("ico"), IMAGECLASS::Get("ico"));
	arr_r.SetImage(IMAGECLASS::Get("arrow_r"));
	arr_l.SetImage(IMAGECLASS::Get("arrow_l"));
	arr_o.SetImage(IMAGECLASS::Get("arrow_r"));
	arr_i.SetImage(IMAGECLASS::Get("arrow_l"));
	comm_type.EnableCase(0);
	comm_type.Tip("select communication method");
	port_out.Min(1);
	port_out.Max(65535);
	port_lcl.Min(1);
	port_lcl.Max(65535);
	CtrlLayout(*this, "EZ Comm");

	/* callbacks */
	ip_out <<= THISBACK(Ip_out);
	port_out <<= THISBACK(Port_out);
	port_lcl <<= THISBACK(Port_lcl);
	ip_lcl <<= THISBACK(Ip_lcl);
	hist_text_out.WhenAction = THISBACK(Hist_text_out);
	butt_clr <<= THISBACK(Butt_clr);
	butt_out <<= THISBACK(Butt_out);
	butt_in <<= THISBACK(Butt_in);
	WhenClose = THISBACK(WClose);
	comm_type <<= THISBACK(Comm_type);

	/* styles */
	lowlight_style = EditField::StyleDefault();
	highlighted_ctrl = NULL;
	
	/* members */
	ezcomm = NULL;
}

bool ezcommwin::HotKey(dword key)
{
	switch (key)
	{
		case K_ENTER:
		case K_CTRL_ENTER:
			Butt_out();
			return true;
	}
	return false;
}

/*	more to do after construction	*/
int ezcommwin::Run(bool appmodal)
{
	WSADATA wsaData;

	WSAStartup(MAKEWORD(2,2), &wsaData);
	comm_type.Set(0, COMM_TYPE_UDP, "UDP");
	comm_type.Set(1, COMM_TYPE_TCP, "TCP");
	comm_type.DisableCase(1);

	TopWindow::Run();
}

void ezcommwin::WClose()
{
	/* validate controls */
	port_out.Clear();
	port_lcl.Clear();

	/* resource release */
	WSACleanup();
	delete ezcomm;

	/* go on termination */
	Close();
}

void ezcommwin::Ip_out()
{
	lowlight_ctrl(&ip_out);
	changes |= CHANGES_RMT;
}

void ezcommwin::Port_out()
{
	lowlight_ctrl(&port_out);
	changes |= CHANGES_RMT;
}

void ezcommwin::Port_lcl()
{
	lowlight_ctrl(&port_lcl);
	changes |= CHANGES_LCL;
}

void ezcommwin::Ip_lcl()
{
	changes |= CHANGES_LCL;
}

void ezcommwin::Hist_text_out()
{
	text_out.Set(hist_text_out.GetValue().ToString());
	text_out.SetFocus();
}

using namespace ezproject;

void ezcommwin::Comm_type()
{
	disp(ezoi::OILVL_WARN, "TCP not supported yet...");
	changes |= CHANGES_TYPE;
}

void ezcommwin::highlight_ctrl(EditField *ctrl)
{
	lowlight_ctrl(NULL);
	if (ctrl)
	{
		EditField::Style highlight_style = lowlight_style;
		highlight_style.paper = Red();
		ctrl->SetStyle(highlight_style);
		ctrl->SetFocus();
	}
	highlighted_ctrl = ctrl;
}

/*
parameter:	ctrl: NULL: reset highlighted one; non-NULL: reset the control
	if it is highlighted
*/
void ezcommwin::lowlight_ctrl(EditField *ctrl)
{
	if (highlighted_ctrl)
	{
		if (!ctrl || (ctrl == highlighted_ctrl))
		{
			highlighted_ctrl->SetStyle(lowlight_style);
			highlighted_ctrl = NULL;
			if (ctrl)
				Butt_clr();
		}
	}
}

void ezcommwin::disp(ezoi::eoilvl lvl, const char *cnt)
{
	Font ft(info.GetFont());

	switch (lvl)
	{
		case ezoi::OILVL_FATAL:
			ft.Bold();
			ft.NoItalic();
			ft.Underline();
			break;
		case ezoi::OILVL_WARN:
			ft.Bold();
			ft.Italic();
			ft.NoUnderline();
			break;
		case ezoi::OILVL_INFO:
			ft.NoBold();
			ft.NoItalic();
			ft.NoUnderline();
			break;
		case ezoi::OILVL_NA:
			ft.NoBold();
			ft.Italic();
			ft.NoUnderline();
			break;
	}
	info.SetFont(ft);
	info.SetLabel(cnt ? "\1this is a long line. hope it works"/*cnt*/ : "");
}

void ezcommwin::func_rcv(void *)
{
}

cbRecieved ezcommwin::cb_rcv()
{
}

#include <stdio.h>
#include "winsock2.h"

void ezcommwin::Butt_out()
{
	if ((0 == ip_out.GetLength()) || (0 == port_out.GetLength()))
	{
		disp(ezoi::OILVL_FATAL, "Input destination's IP & port!");
		if (0 == ip_out.GetLength())
		{
			highlight_ctrl(&ip_out);
		}
		else
			highlight_ctrl(&port_out);
	}
	else
	{
		String ip;
		int port;

		if (changes & CHANGES_TYPE)
		{
			delete ezcomm;
			ezcomm = NULL;
			changes &= ~CHANGES_TYPE;
		}
		switch (comm_type)
		{
			case COMM_TYPE_UDP:
				if (!ezcomm)
				{
					if (thread_rcv.GetCount() < 1)
					{
						thread_rcv.Run(callback1(this, &ezcommwin::func_rcv, static_cast<void *>(NULL)));
					}
					ezcomm = new ezUdp(NULL, NULL);
				}
				if (changes & CHANGES_LCL)
				{
					ezcommSocket *local = new(ezcommSocket);

					ip = ip_lcl.GetData();
					if (port_lcl.GetLength())
						port = port_lcl.GetData();
					else
						port = 0;
					local->set(ip, port);
					ezcomm->setLocal(local);
					changes &= ~CHANGES_LCL;
				}
				if (changes & CHANGES_RMT)
				{
					ezcommSocket *remote = new(ezcommSocket);

					ip = ip_out.GetData();
					port = port_out.GetData();
					remote->set(ip, port);
					ezcomm->setRemote(remote);
					changes &= ~CHANGES_RMT;
				}

				try
				{
					ezcomm->establish();
					switch (ezcomm->transmit(text_out.Get()))
					{
						case RTTP_RGHT:
							disp(ezoi::OILVL_INFO, "data sent.");
							break;
						case RTTP_MNER:
							disp(ezoi::OILVL_WARN, "data partially sent.");
							break;
						default:
							disp(ezoi::OILVL_FATAL, "this is a bug!");
					}
				}
				catch (std::string msg)
				{
					disp(ezoi::OILVL_FATAL, msg.c_str());
				}
				ezcomm->disconnect();
				break;
			case COMM_TYPE_TCP:
				break;
		}
		ip_out.AddHistory(HIST_DROP_NUM);
		port_out.AddHistory(HIST_DROP_NUM);
		hist_text_out.Add(text_out.Get());
		text_out.SetCursor(0);
	}
}

void ezcommwin::Butt_in()
{
	if (0 == port_lcl.GetLength())
	{
		disp(ezoi::OILVL_FATAL, "Input local port!");
		highlight_ctrl(&port_lcl);
	}
	else
	{
		disp(ezoi::OILVL_INFO, "listening...");
	}
}

void ezcommwin::Butt_clr()
{
	disp(ezoi::OILVL_NA, msg.At(rand() % msg.GetCount()));
}

GUI_APP_MAIN
{
	ezcommwin ezcw;

	ezcw.Run();
}

