/***************************************************************************
                          ezcommon  -  description
                             -------------------
    begin                : Aug. 2, 2007
    copyright            : (C) 2007 by Allen
    email                : bon_ami_@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   Explicit Distribution Limitation                                      *
 *   This rule overrides others below.                                     *
 *   This program may not be modified or used by, or, if possible,         *
 *   redistributed to people described as below,                           *
 *   1.Japanese who hold hostility against Chinese.                        *
 *   2.or, those who discriminate against people based solely on race,     *
 *     gender or sexual orientation.                                       *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 *	header of EZ Comm Project UDP functionalities
 */

#include <sstream>
#include "ezudp.h"
/*#include <stdio.h>
#include <stdlib.h>
#ifdef OLD_IOSTREAM
#include <iostream.h>
#else
#include <iostream>
#endif
#include <signal.h>
#include <string.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <errno.h>
#include <pthread.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>*/

using namespace ezproject;

void ezUdp::establish()
{
	socketID = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);

	socketStatus = SOCKET_OPENED;
	if (!localSocket)
	{
	/*	localSocket = new ezcommSocket;
		int port;

		do
		{
			localSocket->set("", port);
		} while (bind(socketID, localSocket->sock(), localSocket->size()) < 0);
		if (0)
	*/		throw std::string("no available socket!");
	}
	else if (bind(socketID, localSocket->sock(), localSocket->size()) < 0)
	{
		std::stringstream msg;

		msg << "failed to bind to " << localSocket->ip() << ":"
			<< localSocket->port();
		throw msg.str();
	}
	if (connect(socketID, remoteSocket->sock(), remoteSocket->size()) < 0)
		throw std::string("failed to connect!");
	socketStatus = SOCKET_CONNECTED;
}

bool ezUdp::serve()
{
}

void ezUdp::disconnect()
{
	if (socketStatus != SOCKET_CLOSED)
	{
		closesocket(socketID);
		socketStatus = SOCKET_CLOSED;
	}
}

void ezUdp::neglect()
{
}

erttp ezUdp::transmit(std::string content)
{
	if (!socketID)
		throw std::string("no socket yet");

	int bytesSent;

	if ((bytesSent = send(socketID, content.c_str(), content.length() + 1, 0))
	    <= 0)
		throw std::string("failed to send!");
	if (content.length() + 1/*\0*/ != bytesSent)
		return RTTP_MNER;
	return RTTP_RGHT;
}
