/***************************************************************************
                          ezcommon  -  description
                             -------------------
    begin                : Aug. 2, 2007
    copyright            : (C) 2007 by Allen
    email                : bon_ami_@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   Explicit Distribution Limitation                                      *
 *   This rule overrides others below.                                     *
 *   This program may not be modified or used by, or, if possible,         *
 *   redistributed to people described as below,                           *
 *   1.Japanese who hold hostility against Chinese.                        *
 *   2.or, those who discriminate against people based solely on race,     *
 *     gender or sexual orientation.                                       *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 *	header of EZ Comm Project Ultimate++ functionalities
 */

#ifndef _ezcomm_ezcomm_h
#define _ezcomm_ezcomm_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <ezcomm/ezcomm.lay>
#include <CtrlCore/lay.h>

#define IMAGEFILE <ezcomm/ezcomm.iml>
#include <Draw/iml_header.h>

#include <ezcommon/ezcommon.h>
#include <ezcomm/ezudp.h>

class ezcommwin : public WithezcommwinLayout<TopWindow> {
private:
	enum	/* communication type, this must be syncronized with layout(comm_type) control */
	{
		COMM_TYPE_UDP,
		COMM_TYPE_TCP
	};
	static const unsigned char HIST_DROP_NUM = 8;
	EditField *highlighted_ctrl;
	EditField::Style lowlight_style;
	Array<String> msg;
	typedef unsigned char changes_t;	/* bitset */
	changes_t changes;
	static const changes_t CHANGES_TYPE = 1;
	static const changes_t CHANGES_LCL = 2;
	static const changes_t CHANGES_RMT = 4;
	ezproject::ezComm *ezcomm;

	/* interface */
	void highlight_ctrl(EditField *);
	void lowlight_ctrl(EditField *);
	void disp(ezproject::ezoi::eoilvl, const char *);
	bool HotKey(dword key);
	void WClose();

	/* interface callbacks */
	void Ip_out();
	void Port_out();
	void Port_lcl();
	void Ip_lcl();
	void Hist_text_out();
	void Butt_clr();
	void Butt_out();
	void Butt_in();
	void Comm_type();
	
	/* threads and userclass callbacks */
	Thread thread_rcv;
	void func_rcv(void *useless);
	ezproject::cbRecieved cb_rcv();

public:
	typedef ezcommwin CLASSNAME;
	ezcommwin();
	int Run(bool appmodal = false);
};

#endif

