#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>

using namespace Upp;

class icon_t : public Value::Void {
  private:

  public:
    int icon_x;
    int icon_y;
    int icon_width;
    int icon_height;

    int icon_inner_x;
    int icon_inner_y;
    int icon_inner_w;
    int icon_inner_h;

    void Paint(BufferPainter* sw, Point pos) {
      pos.x = icon_x - pos.x;
      pos.y = icon_y - pos.y;

	  sw->Rectangle(pos.x, pos.y, icon_width, icon_height).Fill(RGBAZero()).Stroke(2, Blue());
	  sw->Rectangle(pos.x + icon_inner_x, pos.y + icon_inner_y, icon_inner_w, icon_inner_h).Fill(RGBAZero()).Stroke(2, Black());
      sw->Rectangle(pos.x + icon_inner_x - 1, pos.y + icon_inner_y - 1, icon_inner_w + 2, icon_inner_h + 2).Clip();
      sw->Move(pos.x + 4, pos.y + 4).Line(pos.x + icon_width - 4, pos.y + icon_height - 4).Stroke(2, Red());
      sw->Move(pos.x + icon_width - 4, pos.y + 4).Line(pos.x + 4, pos.y + icon_height - 4).Stroke(2, Red());
    }

    void icon_set_location(int x, int y) {
      icon_x = x;
      icon_y = y;
    }

    icon_t() {
      icon_x       = 0;
      icon_y       = 0;
      icon_width   = 90;
      icon_height  = 130;

      icon_inner_x = 5;
      icon_inner_y = 5;
      icon_inner_w = 80;
      icon_inner_h = 120;
    }
};

class DrawCrash : public TopWindow {
public:
	virtual void   Paint(Draw& w);
	virtual void   MouseMove(Point p, dword keyflags);
	virtual void   Layout();

protected:
	Size       imagesize;

	MenuBar    menu;
	ScrollBars scroll;
	StatusBar  status;
	icon_t     icon;

	void    Scroll();

public:
	typedef DrawCrash CLASSNAME;

	DrawCrash();
};

void DrawCrash::Paint(Draw& w)
{
    Size sz = GetSize();
    Point pos = scroll;
    ImageBuffer ib(sz);
    BufferPainter sw(ib, MODE_ANTIALIASED);
    
    sw.Clear(White());
	sw.Begin();
	icon.Paint(&sw, pos);
    sw.End();
	w.DrawImage(0, 0, ib);
}

void DrawCrash::MouseMove(Point p, dword keyflags)
{
	p += scroll;
	icon.icon_set_location(p.x, p.y);
	Refresh();
}


void DrawCrash::Layout()
{
	scroll.SetPage(GetSize());
	scroll.SetTotal(imagesize);
}

void DrawCrash::Scroll()
{
	SetFocus();
	Refresh();
}

DrawCrash::DrawCrash()
{
	imagesize = Size(32767, 32767);
	Title("DrawCrash").Zoomable().Sizeable();
	AddFrame(InsetFrame());
	AddFrame(status);
	AddFrame(scroll);
	scroll.WhenScroll = THISBACK(Scroll);
	scroll.NoAutoHide();
	BackPaint();
	scroll.Set(imagesize.cx / 2, imagesize.cy / 2);
}

GUI_APP_MAIN
{
	DrawCrash().Run();
}
