#ifndef __PAINT_H__
#define __PAINT_H__
#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>
#include <string>

using namespace Upp;

inline Color JWhite() {
  return Color(255, 255, 255);
}
inline Color JLightGray() {
  return Color(192, 192, 192);
}
inline Color JGray() {
  return Color(128, 128, 128);
}
inline Color JDarkGray() {
  return Color(64, 64, 64);
}
inline Color JBlack() {
  return Color(0, 0, 0);
}
inline Color JRed() {
  return Color(255, 0, 0);
}
inline Color JPink() {
  return Color(255, 175, 175);
}
inline Color JOrange() {
  return Color(255, 200, 0);
}
inline Color JYellow() {
  return Color(255, 255, 0);
}
inline Color JGreen() {
  return Color(0, 255, 0);
}
inline Color JMagenta() {
  return Color(255, 0, 255);
}
inline Color JCyan() {
  return Color(0, 255, 255);
}
inline Color JBlue() {
  return Color(0, 0, 255);
}

inline Painter& paint_drawtext(BufferPainter* bp, double x, double y, const std::string& text, Font font, RGBA color, int align = 1) {
  double sub_y = 0.0;
  if(align == 1) {
    sub_y -= font.GetHeight();
  } else if(align) {
    sub_y -= font.GetHeight() / 2.0;
  }
  return bp->Text(x, y + sub_y, text.c_str(), font).Fill(color);
}

inline Painter& paint_drawrect(BufferPainter* bp, int x, int y, int width, int height, double stroke, RGBA stroke_color, RGBA fill_color = RGBAZero(),  bool center_from_point = true, const char* dash = "") {
  double center_of_line_x = 0;
  double center_of_line_y = 0;
  if(center_from_point) {
    center_of_line_x = (((((int)stroke) % 2) != 0)?0.5:0.0);
    center_of_line_y = (((((int)stroke) % 2) != 0)?0.5:0.0);
  } else {
    center_of_line_x = stroke / 2.0;
    center_of_line_y = stroke / 2.0;
  }
  return bp->Rectangle(x + center_of_line_x, y + center_of_line_y, width, height).Fill(fill_color).Dash(dash).Stroke(stroke, stroke_color);
}
#endif