#include "frm_main.h"

#define IMAGECLASS frm_main_images
#define IMAGEFILE <upp_demo/image.iml>
#include <Draw/iml.h>
#define IMAGECLASS frm_main_images

using namespace Upp;

frm_main::frm_main() {
  SetRect(0, 0, 800, 591);
  Sizeable();

  view_area.cx = 32767;
  view_area.cy = 32767;

  scroll.WhenScroll = THISBACK(scroll_action);
  scroll.NoAutoHide();
  BackPaint();

  AddFrame(scroll);

  scroll.SetPage(GetSize());
  scroll.SetTotal(view_area);
  center_scroll();

  for(int i = 0; i < 1089; i++) {
    icon_t* icon = new icon_t(IMAGECLASS::icon_icon_small);
    icons.push_back(std::pair<int, icon_t*>(i, icon));
    icons_zorder.insert(icons_zorder.begin(), icon);
    icon_auto_place(icon, icons.size() - 1);
  }
}

void frm_main::scroll_action() {
  SetFocus();
  Refresh();
}

void frm_main::Layout() {
  scroll.SetPage(GetSize());
}

icon_t* frm_main::return_icon(std::vector<std::pair<std::string, icon_t*>>::iterator it) {
  return it->second;
}

icon_t* frm_main::return_icon(std::vector<icon_t*>::iterator it) {
  return *it;
}

template <typename T>
void frm_main::_keep_icon_icons_in_frame_boundary(T& c) {
  int cnt = 0;
  int w =  view_area.cx;
  int h =  view_area.cy;
  bool got_stuck = false;

  for(auto curr = c.begin() ; curr != c.end();) {
    icon_t* icon   = return_icon(curr);
    int x_edge   = icon->get_x() + icon->get_width() - 1;
    int y_edge   = icon->get_y() + icon->get_height() - 1;
    int x        = icon->get_x();
    int y        = icon->get_y();
    int x_offset = 0;
    int y_offset = 0;

    if(cnt >= 10001) {
      got_stuck = true;
      break;
    }
    cnt++;

    if(x < 0 || y < 0 || x_edge > w || y_edge > h) {
      if(x < 0) {
        x_offset = abs(x);
      } else if(x_edge > w) {
        x_offset = abs(x_edge - w) * -1;
      }
      if(y < 0) {
        y_offset = abs(y);
      } else if(y_edge > h) {
        y_offset = abs(y_edge - h) * -1;
      }

      for(auto curr2 = c.begin() ; curr2 != c.end();) {
        icon_t* icon2  = return_icon(curr2);
        icon2->set_x(icon2->get_x() + x_offset);
        icon2->set_y(icon2->get_y() + y_offset);
      }
      curr = c.begin();
      continue;
    }
    curr++;
  }

  if(!got_stuck) {
    return;
  }

  printf("Fix: Got Stuck\n");
  for(auto curr = c.begin() ; curr != c.end(); curr++) {
    icon_t* icon = return_icon(curr);
    int x_edge    = icon->get_x() + icon->get_width() - 1;
    int y_edge    = icon->get_y() + icon->get_height() - 1;
    int x         = icon->get_x();
    int y         = icon->get_y();
    int x_offset  = 0;
    int y_offset  = 0;
    if(x < 0 || y < 0 || x_edge > w || y_edge > h) {
      if(x < 0) {
        x_offset = abs(icon->get_x());
      } else if(x_edge > w) {
        x_offset = abs(x_edge - w) * -1;
      }
      if(y < 0) {
        y_offset = abs(icon->get_y());
      } else if(y_edge > h) {
        y_offset = abs(y_edge - h) * -1;
      }
      icon->set_x(icon->get_x() + x_offset);
      icon->set_y(icon->get_y() + y_offset);
    }
  }
}

void frm_main::_icon_unselect_all_except(icon_t* icon) {
  for(auto curr : icons) {
    icon_t* curr_icon = curr.second;
    if(curr_icon == NULL || curr_icon != icon) {
      curr_icon->icon_state(RS_SELECTED, 0);
    }
  }
}

void frm_main::_icon_unselect_all() {
  _icon_unselect_all_except(NULL);
}

Image frm_main::MouseEvent(int event, Point p, int zdelta, dword keyflags) {
  int mouse_event = event & ~(LEFT | RIGHT | MIDDLE);
  dword mouse_flags =  keyflags & (K_MOUSELEFT | K_MOUSERIGHT | K_MOUSEMIDDLE | K_MOUSEDOUBLE | K_MOUSETRIPLE);
  if(mouse_event == REPEAT || mouse_event == CURSORIMAGE) {
    goto exit;
  }

  switch(mouse_event) {
    case MOUSEWHEEL: {
      MouseWheel(p, zdelta, keyflags);
      goto exit;
    }
    case MOUSEENTER: {
      MouseEnter(p, keyflags);
      goto exit;
    }
    case MOUSELEAVE: {
      MouseLeave();
      goto exit;
    }
  }

  if(mouse_event != UP && keyflags == 0) {
    mouse_state = 0;
  }

  if((mouse_state & MOUSE_UP)) {
    mouse_state = 0;
  }

  //Add rejection of other buttons once one is in use
  if((mouse_state & MOUSE_LEFT) != 0 && (keyflags & (K_MOUSERIGHT | K_MOUSEMIDDLE)) != 0) {
    goto exit;
  }
  if((mouse_state & MOUSE_RIGHT) != 0 && (keyflags & (K_MOUSELEFT | K_MOUSEMIDDLE)) != 0) {
    goto exit;
  }
  if((mouse_state & MOUSE_MIDDLE) != 0 && (keyflags & (K_MOUSERIGHT | K_MOUSELEFT)) != 0) {
    goto exit;
  }

  if((keyflags & K_MOUSELEFT) == K_MOUSELEFT) {
    mouse_state |= MOUSE_LEFT;
  } else if((keyflags & K_MOUSERIGHT) == K_MOUSERIGHT) {
    mouse_state |= MOUSE_RIGHT;
  } else if((keyflags & K_MOUSEMIDDLE) == K_MOUSEMIDDLE) {
    mouse_state |= MOUSE_MIDDLE;
  }

  if((keyflags & K_MOUSETRIPLE) == K_MOUSETRIPLE) {
    mouse_state &= ~(MOUSE_DOWN | MOUSE_UP | MOUSE_DOUBLE | MOUSE_MOVE | MOUSE_DRAG);
    mouse_state |= MOUSE_TRIPLE;
  } else if((keyflags & K_MOUSEDOUBLE) == K_MOUSEDOUBLE) {
    mouse_state &= ~(MOUSE_DOWN | MOUSE_UP  | MOUSE_MOVE | MOUSE_DRAG);
    mouse_state |= MOUSE_DOUBLE;
  } else if(mouse_event == DOWN) {
    mouse_state &= ~(MOUSE_UP | MOUSE_MOVE | MOUSE_MOVE | MOUSE_DRAG);
    mouse_state |= MOUSE_DOWN;
  } else if(mouse_event == UP) {
    mouse_state &= ~(MOUSE_DOWN | MOUSE_DOUBLE | MOUSE_TRIPLE | MOUSE_MOVE | MOUSE_DRAG);
    mouse_state |= MOUSE_UP;
  } else if(mouse_event == DRAG) {
    mouse_state &= ~(MOUSE_DOWN | MOUSE_MOVE | MOUSE_UP);
    mouse_state |= MOUSE_DRAG;
  } else if((mouse_state & MOUSE_DRAG) != MOUSE_DRAG) {
    mouse_state |= MOUSE_MOVE;
  }

  if(mouse_state & MOUSE_DRAG) {
    MouseDrag(p, keyflags, mouse_state & (MOUSE_LEFT | MOUSE_RIGHT | MOUSE_MIDDLE));
  } else if((mouse_state & MOUSE_DOWN) && (mouse_state & MOUSE_MOVE) == 0) {
    MouseClicked(p, keyflags, mouse_state & (MOUSE_LEFT | MOUSE_RIGHT | MOUSE_MIDDLE), 1);
  } else if((mouse_state & MOUSE_DOUBLE) && (mouse_state & MOUSE_MOVE) == 0) {
    MouseClicked(p, keyflags, mouse_state & (MOUSE_LEFT | MOUSE_RIGHT | MOUSE_MIDDLE), 2);
  } else if((mouse_state & MOUSE_TRIPLE) && (mouse_state & MOUSE_MOVE) == 0) {
    MouseClicked(p, keyflags, mouse_state & (MOUSE_LEFT | MOUSE_RIGHT | MOUSE_MIDDLE), 3);
  } else if(mouse_state & MOUSE_UP) {
    MouseReleased(p, keyflags, mouse_state & (MOUSE_LEFT | MOUSE_RIGHT | MOUSE_MIDDLE));
  } else if(mouse_state & MOUSE_MOVE) {
    MouseMove(p, keyflags);
  }

exit:
  return Image::Arrow();
}

void frm_main::MouseWheel(Point p, int zdelta, dword keyflags) {
  bool do_refresh = false;
  double d = ((zdelta > 0)? -1 : 1);

  if(!(keyflags & K_SHIFT)) {
    if(d <= 0) {
      scroll.SetY(scroll.GetY() - (100));
    } else {
      scroll.SetY(scroll.GetY() + (100));
    }
  } else {
    if(d <= 0) {
      scroll.SetX(scroll.GetX() - (100));
    } else {
      scroll.SetX(scroll.GetX() + (100));
    }
  }

  if(do_refresh) {
    Refresh();
  }
}

void frm_main::MouseClicked(Point pos, dword keyflags, unsigned int type, int clicks) {
  SetCapture();

  if(type == MOUSE_LEFT) {
    icon_t* icon;
    bool enabled;

    icon = _icon_get_clicked();

    if((keyflags & K_CTRL) == 0 && (keyflags & K_SHIFT) == 0) {
      _icon_unselect_all();
      icons_selected.clear();
    }

    if(icon != NULL) {
      icon->icon_offset.set_location(get_mouse_point() - get_icon_rect(icon).get_location());

      vector_set_element_position<icon_t*>(icons_zorder, icon, 0);
      icon->icon_state(0, RS_SELECTED);
      icons_selected.insert(icons_selected.begin(), icon);
    }

    for(auto ticon : icons_zorder) {
      ticon->icon_offset.set_location(get_mouse_point() - get_icon_rect(ticon).get_location());
    }
  } else if(type == MOUSE_RIGHT) {

  } else if(type == MOUSE_MIDDLE) {

  }
  Refresh();
}

void frm_main::MouseReleased(Point p, dword keyflags, unsigned int type) {
  ReleaseCapture();

  _keep_icon_icons_in_frame_boundary<std::vector<icon_t*>>(icons_selected);

  Refresh();
}

void frm_main::MouseDrag(Point p, dword keyflags,  unsigned int type) {
  bool needs_refresh = false;

  if(type == MOUSE_LEFT) {
    if(!icons_selected.empty()) {
      for(auto icon : icons_selected) {
        if(icon->icon_state_test(RS_SELECTED)) {
          point_f new_loc = (((get_mouse_point() - icon->icon_offset) / 10) * 10);
          icon->set_location(new_loc);
          needs_refresh = true;
        }
      }
    }
  }

  if(needs_refresh) {
    Refresh();
  }
}

void frm_main::MouseMove(Point p, dword keyflags) {
}

void frm_main::MouseEnter(Point p, dword keyflags) {
}

void frm_main::MouseLeave() {
}

bool frm_main::Key(dword key, int count) {
  Size sz = scroll.GetPage();
  Size sz2 = sz / 2;
  bool is_pressed = (key & K_KEYUP) == 0;
  key &= ~(key & K_KEYUP);

  scroll.SetPage(sz2);

  if(is_pressed) { //key is pressed
    switch(key) {
      case K_PAGEUP:
      case K_CTRL_UP: {
        scroll.PageUp();
        break;
      }

      case K_PAGEDOWN:
      case K_CTRL_DOWN: {
        scroll.PageDown();
        break;
      }

      case K_CTRL_PAGEUP:
      case K_CTRL_LEFT: {
        scroll.PageLeft();
        break;
      }

      case K_CTRL_PAGEDOWN:
      case K_CTRL_RIGHT: {
        scroll.PageRight();
        break;
      }

      case K_SHIFT_UP: {
        scroll.LineUp();
        break;
      }

      case K_SHIFT_DOWN: {
        scroll.LineDown();
        break;
      }

      case K_SHIFT_LEFT: {
        scroll.LineLeft();
        break;
      }

      case K_SHIFT_RIGHT: {
        scroll.LineRight();
        break;
      }

      case K_UP: {
        scroll.WheelY(120);
        break;
      }

      case K_DOWN: {
        scroll.WheelY(-120);
        break;
      }

      case K_LEFT: {
        scroll.WheelX(120);
        break;
      }

      case K_RIGHT: {
        scroll.WheelX(-120);
        break;
      }
    }
  }
  scroll.SetPage(sz);
  return true;
}

//void frm_main::_icons_paint(BufferPainter& sw, int x_offset, int y_offset, bool _render_everything) {
//  rect_f visible = rect_f(scroll.x, scroll.y, GetSize().cx, GetSize().cy);
//
//  sw.Begin();
//
//  for(auto it = icons_zorder.rbegin(); it != icons_zorder.rend() ; it++) {
//    icon_t* icon = *it;
//    rect_f ricon;
//
//    ricon = icon->get_bounds();
//
//    if(_render_everything || ricon.intersects(visible)) {
//      icon->icon_paint(&sw, x_offset, y_offset);
//    }
//  }
//
//#if 0
//  //Debug code
//  Point mp = GetMouseViewPos();
//  double hs = mouse_hit_size;
//  rect_f f = rect_f(((mp.x) - (hs / 2)), ((mp.y) - (hs / 2)), hs, hs);
//  paint_drawrect(&sw, f.x, f.y, f.width, f.height, 1, JGreen(), JGreen());
//#endif
//
//  sw.End();
//}

void frm_main::_icons_paint2(Draw& w, int x_offset, int y_offset, bool _render_everything)
{
  for(auto it = icons_zorder.rbegin(); it != icons_zorder.rend() ; it++) {
    icon_t* icon = *it;
    rect_f ricon;

    ricon = icon->get_bounds();
    w.Clip(GetSize());
    icon->icon_paint2(w, x_offset, y_offset);
    w.End();
  }

}

void frm_main::Paint(Draw& w) {
 	RTIMING(__FUNCTION__);
	w.DrawRect(GetSize(), White);
   _icons_paint2(w, scroll.Get().x, scroll.Get().y, render_everything);
}

void frm_main::_clear() {
  for(auto c : icons) {
    delete c.second;
  }
  icons.clear();
}

frm_main::~frm_main() {
  _clear();
}

point_f frm_main::get_point_pos(double x, double y) {
  point_f p = point_f(x, y);
  p.x += scroll.GetX();
  p.y += scroll.GetY();
  return p;
}

point_f frm_main::get_point_pos(point_f p) {
  return get_point_pos(p.x, p.y);
}

point_f frm_main::get_point_pos(Point p) {
  return get_point_pos(p.x, p.y);
}

point_f frm_main::get_mouse_point() {
  return get_point_pos(GetMouseViewPos());
}

rect_f frm_main::get_mouse_rect() {
  point_f p = get_mouse_point();
  double hs = mouse_hit_size;
  return rect_f(p.x - (hs / 2), p.y - (hs / 2), hs, hs);
}

rect_f frm_main::get_icon_rect(icon_t* icon) {
  rect_f ricon = icon->get_bounds();
  return ricon;
}

icon_t* frm_main::_icon_get_clicked() {
  icon_t* ret_icon = NULL;
  rect_f rmouse = get_mouse_rect();
  for(auto icon : icons_zorder) {
    rect_f ricon = get_icon_rect(icon);
    if(ricon.intersects(rmouse)) {
      ret_icon = icon;
      break;
    }
  }
  return ret_icon;
}

void frm_main::icon_auto_place(icon_t* icon, int icon_index) {
  int pos_x = 0;
  int pos_y = 0;
  if(origin_x == 0) {
    pos_x = (view_area.cx / 2);
    pos_y = (view_area.cy / 2);
    origin_x = pos_x;
    origin_y = pos_y;
  } else {
    pos_x = origin_x;
    pos_y = origin_y;
  }

  int unit_x = icon->get_width() + 20;
  int unit_y = icon->get_height() + 20;

  int loop = 0;
  int loop_dec = 8;
  int loop_pos = 0;
  int loop_side = 0;
  int q1 = 0;
  int q2 = 0;
  int q3 = 0;
  int q4 = 0;
  while(icon_index > 0) {
    icon_index -= loop_dec;
    loop_pos = (loop_dec + icon_index) - 1;
    loop_dec += 8;
    loop++;
  }
  loop_side = (loop * 2);
  q1 = loop_side;
  q2 = (loop_side * 2);
  q3 = (loop_side * 3);
  q4 = (loop_side * 4);

  if(loop_pos <= q1) {
    pos_x -= (unit_x * loop);
    pos_y -= (unit_y * loop);

    pos_y += (unit_y * loop_pos);
  } else if(loop_pos <= q2) {
    pos_x -= (unit_x * loop);
    pos_y += (unit_y * loop);

    pos_x += (unit_x * (loop_pos - q1));
  } else if(loop_pos <= q3) {
    pos_x += (unit_x * loop);
    pos_y += (unit_y * loop);

    pos_y -= (unit_y * (loop_pos - q2));
  } else if(loop_pos <= q4) {
    pos_x += (unit_x * loop);
    pos_y -= (unit_y * loop);

    pos_x -= (unit_x * (loop_pos - q3));
  }
  pos_x = (pos_x / 10) * 10;
  pos_y = (pos_y / 10) * 10;

  icon->set_location(pos_x, pos_y);
  Refresh();
}

GUI_APP_MAIN
{
  frm_main* mainapp = new frm_main();

  mainapp->Run();

  delete mainapp;
}