#ifndef _FRM_MAIN_H_
#define _FRM_MAIN_H_

#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <string.h>
#include <vector>
#include <algorithm>
#include <string>
#include <mutex>
#include <thread>

#include "paint.h"
#include "icon_t.h"
#include "line_t.h"
#include "rect_t.h"

using namespace Upp;

enum {
  MOUSE_NONE   = (0 << 0),
  MOUSE_LEFT   = (1 << 0),
  MOUSE_RIGHT  = (1 << 1),
  MOUSE_MIDDLE = (1 << 2),
  MOUSE_DOWN   = (1 << 3),
  MOUSE_UP     = (1 << 4),
  MOUSE_DOUBLE = (1 << 5),
  MOUSE_TRIPLE = (1 << 6),
  MOUSE_DRAG   = (1 << 7),
  MOUSE_MOVE   = (1 << 8),
};

class frm_main : public TopWindow {
  public:
    typedef frm_main CLASSNAME;

    ImageBuffer               dd_ib1;
    ImageBuffer               dd_ib2;

    std::vector<std::pair<int, icon_t*>> icons;
    std::vector<icon_t*>          icons_zorder;
    std::vector<icon_t*>          icons_selected;

    int origin_x = 0;
    int origin_y = 0;

    void center_scroll() {
      scroll.Set((scroll.GetTotal().cx / 2) - (scroll.GetViewSize().cx / 2), (scroll.GetTotal().cy / 2) - (scroll.GetViewSize().cy / 2));
    }

  private:
    std::mutex  m_refresh;
    std::mutex  m;
    dword       mouse_state  = 0;
    dword       mouse_clicks = 0;
    Size        view_area;

    ScrollBars  scroll;

    int         mouse_hit_size     = 12;

    bool        render_everything  = false;
    point_f     move_start;

    void scroll_action();
    void Layout();

    virtual Image MouseEvent(int event, Point p, int zdelta, dword keyflags);
    virtual void MouseWheel(Point p, int zdelta, dword keyflags);
    virtual bool Key(dword key, int count);

    virtual void MouseClicked(Point p, dword keyflags, unsigned int type, int clicks);
    virtual void MouseReleased(Point p, dword keyflags, unsigned int type);
    virtual void MouseDrag(Point p, dword keyflags, unsigned int type);
    virtual void MouseMove(Point p, dword keyflags);
    virtual void MouseEnter(Point p, dword keyflags);
    virtual void MouseLeave();

  public:
    frm_main();
    ~frm_main();
    void _clear();

    void Paint(Draw& w);

    void icon_auto_place(icon_t* icon, int icon_index);
    icon_t* _icon_get_clicked();
    icon_t* return_icon(std::vector<std::pair<std::string, icon_t*>>::iterator it);
    icon_t* return_icon(std::vector<icon_t*>::iterator it);
    void _icon_unselect_all_except(icon_t* icon);
    void _icon_unselect_all();

    rect_f get_icon_rect(icon_t* icon);
    rect_f get_mouse_rect();

    point_f get_point_pos(double x, double y);
    point_f get_point_pos(point_f p);
    point_f get_point_pos(Point p);
    point_f get_mouse_point();

    //void _icons_paint(BufferPainter& sw, int x_offset, int y_offset, bool _render_everything);
    void _icons_paint2(Draw& w, int x_offset, int y_offset, bool _render_everything);

    template <typename T>
    void _keep_icon_icons_in_frame_boundary(T& c);

    template<typename T> void vector_set_element_position(std::vector<T>& v, T lookup, int index) {
      if(index != 0 && index >= v.size()) {
        return;
      }

      auto found = std::find(v.begin(), v.end(), lookup);
      if(found != v.end()) {
        v.erase(found);
      }

      v.insert(v.begin() + index, lookup);
    }
};

#endif //_FRM_MAIN_H_