#ifndef _ICON_T_
#define _ICON_T_

#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>
#include "paint.h"
#include "rect_t.h"
#include "point_t.h"
#include <experimental/random>

using namespace Upp;

enum {
  RS_SELECTED                 = 1 << 0,
  RS_LAST_STATE_              = 1 << 1,
  RS_CLEAR_ALL_BITS   = (RS_LAST_STATE_ - 1),
};

class icon_t : public Value::Void {
  private:
    std::string s1;
    std::string s2;
    std::string s3;
    unsigned int _icon_state;
    unsigned int _icon_commited_state;

    Image icon;
    int icon_bdr_inner_line_w;
    int icon_bdr_center_line_w;
    int icon_bdr_outer_line_w;
    int icon_inset;

    int icon_summary_bdr_inner_line_w = 2;
    int icon_summary_bdr_center_line_w = 2;
    int icon_summary_bdr_outer_line_w = 2;
    int icon_summary_inset = icon_summary_bdr_inner_line_w + icon_summary_bdr_center_line_w + icon_summary_bdr_outer_line_w;
    int icon_summary_handle_line_w = 1;

  public:
    //java does doubles might want to do that here also
    point_f icon_offset;
    point_f icon_node;
    point_f icon_end_node;

    point_f icon_icon;
    point_f icon_mac;
    point_f icon_model;
    point_f icon_serial;
    point_f icon_root;

    rect_f icon_bounds;
    rect_f icon_bdr_outer;
    rect_f icon_bdr_center;
    rect_f icon_bdr_inner;

    int icon_handle_line_w;
    int icon_handle_hit_size;

    rect_f icon_lhandle;
    rect_f icon_rhandle;

    Color get_color() {
      return JBlue();
    }

    const char* get_stroke() {
      return "";
    }

    void icon_piant_borders_and_fill(Draw& w, int x_offset, int y_offset) {
      if(icon_state_test(RS_SELECTED)) {
        //outer border
        paint_drawrect(w, x_offset + icon_bdr_outer.x, y_offset + icon_bdr_outer.y, icon_bdr_outer.width, icon_bdr_outer.height, icon_bdr_outer_line_w, JBlack(), White(), true);

        //center border
        paint_drawrect(w, x_offset + icon_bdr_center.x, y_offset + icon_bdr_center.y, icon_bdr_center.width, icon_bdr_center.height, icon_bdr_center_line_w, White(), White(), true);
      }

      //inner boder

      //Fill with white first. just incase its dashed
      paint_drawrect(w, x_offset + icon_bdr_inner.x, y_offset + icon_bdr_inner.y, icon_bdr_inner.width, icon_bdr_inner.height, icon_bdr_center_line_w, JWhite(), JWhite(), true);

      //then fill the other
      paint_drawrect(w, x_offset + icon_bdr_inner.x, y_offset + icon_bdr_inner.y, icon_bdr_inner.width, icon_bdr_inner.height, icon_bdr_center_line_w, get_color(), JWhite(), true , get_stroke());
    }

    void icon_paint_handles(Draw& w, int x_offset, int y_offset) {
      Color c = JBlack();

      paint_drawrect(w, x_offset + icon_lhandle.x, y_offset + icon_lhandle.y, icon_lhandle.width, icon_lhandle.height, icon_handle_line_w, c, RGBAZero(), true);
      paint_drawrect(w, x_offset + icon_rhandle.x, y_offset + icon_rhandle.y, icon_rhandle.width, icon_rhandle.height, icon_handle_line_w, c, RGBAZero(), true);
    }

    void icon_paint_text(Draw& w, int x_offset, int y_offset) {
      Color c = JBlack();
      Font text_font = Monospace(12);
      icon_draw_text_centered(w, x_offset, y_offset, text_font, s1, icon_mac.y);

      icon_model.x = icon_inset;
      if(icon_model.x < (icon_bounds.width - (icon_inset * 2))) {
        icon_model.x = icon_inset + (((icon_bounds.width - (icon_inset * 2)) - (s2.length() * text_font.GetMonoWidth())) / 2);
      }
      icon_draw_text_centered(w, x_offset, y_offset, text_font, s2, icon_model.y);
      icon_draw_text_centered(w, x_offset, y_offset, text_font, s3, icon_serial.y);
    }

    void icon_draw_text_centered(Draw& w, int x_offset, int y_offset, Font f, const std::string& text, int y) {
      paint_drawtext(w, x_offset + (45 - ((f.GetMonoWidth() * ((int)text.length())) / 2)), y_offset + y, text, f, JBlack());
    }

//    void icon_paint_icon(BufferPainter* sw, int x_offset, int y_offset) {
//#if 1
//      //NOTE: This is way to slow
//      sw->DrawImage(x_offset , y_offset , icon);
//#else
//      //This is the new icon code
//      sw->Move(x_offset + 10.5, y_offset +    3).Line(x_offset + 10.5, y_offset +   19).Dash("").Stroke(1, JBlack());
//      sw->Move(x_offset + 27.5, y_offset +    3).Line(x_offset + 27.5, y_offset +   19).Dash("").Stroke(1, JBlack());
//      sw->Move(x_offset +    8, y_offset + 34.5).Line(x_offset +   13, y_offset + 34.5).Dash("").Stroke(1, JBlack());
//      sw->Move(x_offset +   25, y_offset + 34.5).Line(x_offset +   30, y_offset + 34.5).Dash("").Stroke(1, JBlack());
//      sw->Move(x_offset +    7, y_offset + 35.5).Line(x_offset +   31, y_offset + 35.5).Dash("").Stroke(1, JBlack());
//      sw->Move(x_offset +  4.5, y_offset +   42).Line(x_offset +  4.5, y_offset +   46).Dash("").Stroke(1, JBlack());
//      sw->Move(x_offset + 33.5, y_offset +   42).Line(x_offset + 33.5, y_offset +   46).Dash("").Stroke(1, JBlack());
//      sw->Move(x_offset +  5.5, y_offset +   41).Line(x_offset +  5.5, y_offset +   47).Dash("").Stroke(1, JBlack());
//      sw->Move(x_offset + 32.5, y_offset +   41).Line(x_offset + 32.5, y_offset +   47).Dash("").Stroke(1, JBlack());
//      sw->Move(x_offset +  4.5, y_offset +   56).Line(x_offset +  4.5, y_offset +   60).Dash("").Stroke(1, JBlack());
//      sw->Move(x_offset + 33.5, y_offset +   56).Line(x_offset + 33.5, y_offset +   60).Dash("").Stroke(1, JBlack());
//      sw->Move(x_offset +  5.5, y_offset +   55).Line(x_offset +  5.5, y_offset +   61).Dash("").Stroke(1, JBlack());
//      sw->Move(x_offset + 32.5, y_offset +   55).Line(x_offset + 32.5, y_offset +   61).Dash("").Stroke(1, JBlack());
//
//      sw->Rectangle(x_offset +  9.5, y_offset + 19.5,  2, 15).Fill(JBlack()).Dash("").Stroke(1, JBlack());
//      sw->Rectangle(x_offset + 26.5, y_offset + 19.5,  2, 15).Fill(JBlack()).Dash("").Stroke(1, JBlack());
//      sw->Rectangle(x_offset +  6.5, y_offset + 36.5, 25, 27).Fill(JBlack()).Dash("").Stroke(1, JBlack());
//#endif
//    }

    void icon_paint_icon2(Draw& w, int x_offset, int y_offset) {
      w.DrawImage(x_offset , y_offset , icon);
    }

//    void icon_paint(BufferPainter* sw, int x_offset, int y_offset) {
//      x_offset = get_x() - x_offset;
//      y_offset = get_y() - y_offset;
//      icon_piant_borders_and_fill(sw, x_offset, y_offset);
//      icon_paint_icon(sw, x_offset + icon_icon.x, y_offset + icon_icon.y);
//     // icon_paint_handles(sw, x_offset, y_offset);
//     // icon_paint_text(sw, x_offset, y_offset);
//    }

    void icon_paint2(Draw& w, int x_offset, int y_offset) {
      x_offset = get_x() - x_offset;
      y_offset = get_y() - y_offset;
      icon_piant_borders_and_fill(w, x_offset, y_offset);
      icon_paint_icon2(w, x_offset + icon_icon.x, y_offset + icon_icon.y);
      icon_paint_handles(w, x_offset, y_offset);
      icon_paint_text(w, x_offset, y_offset);
    }

    void set_bounds(int x, int y, int width, int height) {
      icon_bounds.x = x;
      icon_bounds.y = y;
      icon_bounds.width = width;
      icon_bounds.height = height;
    }

    rect_f get_bounds() {
      return icon_bounds;
    }

    void set_x(int x) {
      icon_bounds.x = x;
    }

    void set_y(int y) {
      icon_bounds.y = y;
    }

    void set_location(int x, int y) {
      set_x(x);
      set_y(y);
    }

    void set_location(point_f p) {
      set_x(p.x);
      set_y(p.y);
    }

    point_f get_location() {
      return get_bounds().get_location();
    }

    int get_x() {
      return icon_bounds.x;
    }

    int get_y() {
      return icon_bounds.y;
    }

    int get_width() {
      return icon_bounds.width;
    }

    int get_height() {
      return icon_bounds.height;
    }

    bool icon_state_test(unsigned int has_bits) {
      return ((_icon_state & has_bits) != 0);
    }

    bool icon_state_test(unsigned int rs, unsigned int has_bits) {
      return ((rs & has_bits) != 0);
    }

    unsigned int icon_state() {
      return _icon_state;
    }

    void icon_state(unsigned int unset_bits, unsigned int set_bits) {
      _icon_state = (set_bits | (_icon_state & ~unset_bits));
    }

    icon_t(Image ic) : icon(ic) {
      _icon_state = 0;
      _icon_commited_state = 0;

      icon_offset.Clear();
      icon_node.Clear();
      icon_end_node.Clear();

      icon_bdr_inner_line_w  = 2;
      icon_bdr_center_line_w = 2;
      icon_bdr_outer_line_w  = 2;
      icon_inset             = icon_bdr_inner_line_w + icon_bdr_center_line_w + icon_bdr_outer_line_w; //6
      icon_bounds            = rect_f(
                                0,
                                0,
                                (icon_inset * 2) + 78, //12 +  78 =  90
                                (icon_inset * 2) + 118 //12 + 118 = 130
                              );
      icon_bdr_outer         = rect_f(
                                icon_bdr_outer_line_w / 2, //2 / 2 = 1
                                icon_bdr_outer_line_w / 2, //2 / 2 = 1
                                icon_bounds.width  - icon_bdr_outer_line_w, //90 - 2 =  88
                                icon_bounds.height - icon_bdr_outer_line_w  //130 - 2 = 128
                              );
      icon_bdr_center        = rect_f(
                                icon_bdr_outer_line_w   + (icon_bdr_center_line_w / 2), //2 + 1 = 3
                                icon_bdr_outer_line_w   + (icon_bdr_center_line_w / 2), //2 + 1 = 3
                                icon_bounds.width  - ((icon_bdr_outer_line_w * 2) + icon_bdr_center_line_w), // 90 - (4 + 2) =  84
                                icon_bounds.height - ((icon_bdr_outer_line_w * 2) + icon_bdr_center_line_w)  //130 - (4 + 2) = 124
                              );
      icon_bdr_inner         = rect_f(
                                icon_bdr_outer_line_w   + icon_bdr_center_line_w + (icon_bdr_inner_line_w / 2), //2 + 2 + 1 = 5
                                icon_bdr_outer_line_w   + icon_bdr_center_line_w + (icon_bdr_inner_line_w / 2), //2 + 2 + 1 = 5
                                icon_bounds.width  - (((icon_bdr_outer_line_w + icon_bdr_center_line_w) * 2) + icon_bdr_inner_line_w), // 90 - (((2 + 2) * 2) + 2) =  80
                                icon_bounds.height - (((icon_bdr_outer_line_w + icon_bdr_center_line_w) * 2) + icon_bdr_inner_line_w) //130 - (((2 + 2) * 2) + 2) = 120
                              );
      icon_icon              = point_f(icon_inset + 20, icon_inset + 17 + 8); // 6 + 20  = 26, 6 +  17 =  23
      icon_mac               = point_f(icon_inset + 11, icon_inset + 13);     // 6 + 11  = 17, 6 +  13 =  19
      icon_model             = point_f(0, icon_inset + 93 + 8);               // X, 6 +  93 =  99
      icon_serial            = point_f(icon_inset + 13, icon_inset + 110 + 4);// 6 + 13 = 19, 6 + 110 = 116
      icon_root              = point_f(icon_inset + 35, icon_inset + 32);     // 6 + 35 = 41, 6 +  32 =  38

      icon_handle_line_w     = 1;
      icon_handle_hit_size   = 10;

      icon_lhandle           = rect_f(
                                icon_inset +  5, //6 +  5 = 11
                                icon_inset + 52, //6 + 52 = 58
                                icon_handle_hit_size, //10
                                icon_handle_hit_size  //10
                              );

      icon_rhandle           = rect_f(
                                icon_inset + 62, //6 + 62 = 68
                                icon_inset + 52, //6 + 52 = 58
                                icon_handle_hit_size, //10
                                icon_handle_hit_size  //10
                              );

      s1 = "";
      s2 = "";
      s3 = "";

      for(int i = 0; i < 9; i++) {
        s1 += (char)std::experimental::randint(0x30, 0x39);
      }

      for(int i = 0; i < 9; i++) {
        s2 += (char)std::experimental::randint(0x41, 0x5A);
      }

      for(int i = 0; i < 9; i++) {
        s3 += (char)std::experimental::randint(0x61, 0x7A);
      }
    }

    ~icon_t() {
    }
};

#endif //_ICON_T_