#ifndef _LINE_T_
#define _LINE_T_

#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>
#include "point_t.h"
#include "rect_t.h"

using namespace Upp;

template<class T>
struct line_: Moveable<line_<T>> {
  T x1;
  T y1;
  T x2;
  T y2;

  void Clear() {
    x1 = y1 = x2 = y2 = 0;
  }

  line_() {
    x1 = y1 = x2 = y2 = 0;
  }

  line_(T x1, T y1, T x2, T y2) {
    this->x1 = x1;
    this->y1 = y1;
    this->x2 = x2;
    this->y2 = y2;
  }

  friend line_ operator*(line_ a, T m) {
    return line_<T>(a.x1 * m, a.y1 * m, a.x2 * m, a.y2 * m);
  }

  friend line_ operator/(line_ a, T m) {
    return line_<T>(a.x1 / m, a.y1 / m, a.x2 / m, a.y2 / m);
  }

  point_<T> get_location1() {
    return point_<T>(x1, y1);
  }

  point_<T> get_location2() {
    return point_<T>(x2, y2);
  }

  bool intersects(rect_<T> r) {
    return r.intersects(x1, y1, x2, y2);
  }

};

typedef line_<double> line_f;

#endif //_LINE_T_