#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define IMAGECLASS Img
#define IMAGEFILE <ImageTest/Image.iml>
#include <Draw/iml_header.h>

#define IMAGECLASS Img
#define IMAGEFILE <ImageTest/Image.iml>
#include <Draw/iml_source.h>

void PaintImage(Painter& w, double rotate)
{
	Sizef sz = Img::icon().GetSize();
	w.Begin();
	w.Clear(RGBAZero());
	w.Rectangle(0, 0, sz.cx, sz.cy).Stroke(2, Green());
	w.Translate(Point(sz.cx / 2.0, sz.cy / 2.0));
	w.Rotate(rotate);
	w.DrawImage(-sz.cx / 2.0, -sz.cy / 2.0, Img::icon());
    w.End();
};

class CrudeImageMaker : public ImageMaker { // Basic image cache interface...
	Image image;
	double rotate;
	
public:
	virtual String Key() const;
	virtual Image  Make() const;
	CrudeImageMaker(const Image& image, double rotate) : image(image), rotate(rotate) {}
};

String CrudeImageMaker::Key() const
{
	String key;
	RawCat(key, image.GetSerialId());
	RawCat(key, rotate);
	return key;
}

Image CrudeImageMaker::Make() const
{
	ImagePainter ip(Img::icon().GetSize());
	PaintImage(ip, rotate);
	return ip.GetResult();
}

Image GetImage(const Image& img, double rotate = 0.0)
{
	CrudeImageMaker im(img, rotate);
	return MakeImage(im);
}

struct ImageTest : TopWindow {
	
	Image img;
	int    xoffset = 0, yoffset = 0;
	double rotate = 0.0;
	
	ImageTest()
	{
		Sizeable().Zoomable().CenterScreen().SetRect(0, 0, 1024, 800);
		img = GetImage(Img::icon());
	}
	
	void Paint(Draw& w) override
	{
		RTIMING(__FUNCTION__);
		Size sz = GetSize();
		w.DrawRect(sz, White());
		Size isz = img.GetSize();
		for(int y = 0; y < 100; y++)
			for(int x = 0 ; x < 100; x++) {
				w.DrawImage(x * isz.cx + xoffset, y * isz.cy + yoffset, img);
			}
	}
	
	
	bool Key(dword key, int count) override
	{
		if(key == K_UP) {
			yoffset -= 10;
			Refresh();
		}
		else
		if(key == K_DOWN) {
			yoffset += 10;
			Refresh();
		}
		else
		if(key == K_LEFT) {
			xoffset -= 10;
			Refresh();
		}
		else
		if(key == K_RIGHT) {
			xoffset += 10;
			Refresh();
		}
		else
		if(key == 'x') {
			rotate = fmod(rotate + M_PI / 2, 2 * M_PI);
			img = GetImage(Img::icon(), rotate);
			Refresh();
		}
		else
		if(key == 'z') {
			rotate = fmod(rotate - M_PI / 2, - 2 * M_PI);
			img = GetImage(Img::icon(), rotate);
			Refresh();
		}
		return TopWindow::Key(key, count);
	}
};

GUI_APP_MAIN
{
	StdLogSetup(LOG_FILE);
	ImageTest().Run();
}
