#ifndef _POINT_T_
#define _POINT_T_

#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>

using namespace Upp;

template<class T>
struct point_: Moveable<point_<T>> {
  T x;
  T y;

  void Clear() {
    x = y = 0;
  }

  point_() {
    x = y = 0;
  }

  point_(T x, T y) {
    this->x = x;
    this->y = y;
  }

  point_(point_<int> b) {
    this->x = b.x;
    this->y = b.y;
  }

  point_(point_<double> b) {
    this->x = b.x;
    this->y = b.y;
  }

  point_(Point_<int> b) {
    this->x = b.x;
    this->y = b.y;
  }

  void operator=(Point_<int> b) {
    x = b.x;
    y = b.y;
  }

  point_ operator()() {
    return point_(x, y);
  }

  friend point_ operator-(point_ a, point_<double> b) {
    a.x -= b.x;
    a.y -= b.y;
    return a;
  }
  friend point_ operator+(point_ a, point_<double> b) {
    a.x += b.x;
    a.y += b.y;
    return a;
  }
  friend point_ operator-(point_ a, double m) {
    a.x = a.x - m;
    a.y = a.y - m;
    return a;
  }
  friend point_ operator+(point_ a, double m) {
    a.x = a.x + m;
    a.y = a.y + m;
    return a;
  }
  friend point_ operator*(point_ a, double m) {
    a.x = a.x * m;
    a.y = a.y * m;
    return a;
  }
  friend point_ operator/(point_ a, double m) {
    a.x = a.x / m;
    a.y = a.y / m;
    return a;
  }

  friend point_ operator-(point_ a, point_<int> b) {
    a.x = (int)a.x - b.x;
    a.y = (int)a.y - b.y;
    return a;
  }
  friend point_ operator+(point_ a, point_<int> b) {
    a.x = (int)a.x + b.x;
    a.y = (int)a.y + b.y;
    return a;
  }
  friend point_ operator-(point_ a, int m) {
    a.x = (int)a.x - m;
    a.y = (int)a.y - m;
    return a;
  }
  friend point_ operator+(point_ a, int m) {
    a.x = (int)a.x + m;
    a.y = (int)a.y + m;
    return a;
  }
  friend point_ operator*(point_ a, int m) {
    a.x = (int)a.x * m;
    a.y = (int)a.y * m;
    return a;
  }
  friend point_ operator/(point_ a, int m) {
    a.x = (int)a.x / m;
    a.y = (int)a.y / m;
    return a;
  }

  void operator*=(point_<double> b) {
    x *= b.x;
    y *= b.y;
  }
  void operator/=(point_<double> b) {
    x /= b.x;
    y /= b.y;
  }
  void operator+=(point_<double> b) {
    x += b.x;
    y += b.y;
  }
  void operator-=(point_<double> b) {
    x -= b.x;
    y -= b.y;
  }
  void operator*=(point_<int> b) {
    x *= b.x;
    y *= b.y;
  }
  void operator/=(point_<int> b) {
    x /= b.x;
    y /= b.y;
  }
  void operator+=(point_<int> b) {
    x += b.x;
    y += b.y;
  }
  void operator-=(point_<int> b) {
    x -= b.x;
    y -= b.y;
  }
  void operator+=(T m) {
    x += m;
    y += m;
  }
  void operator-=(T m) {
    x -= m;
    y -= m;
  }
  void operator*=(T m) {
    x *= m;
    y *= m;
  }
  void operator/=(T m) {
    x /= m;
    y /= m;
  }

  bool operator==(const point_<int>& a) {
    return (x == a.x && y == a.y);
  }

  bool operator!=(const point_<int>& a) {
    return (x != a.x || y != a.y);
  }

  bool operator==(const point_<double>& a) {
    return (x == a.x && y == a.y);
  }

  bool operator!=(const point_<double>& a) {
    return (x != a.x || y != a.y);
  }

  T distance(T px, T py) {
    px -= x;
    py -= y;
    return sqrt((px * px) + (py * py));
  }

  T distance(point_<T> p) {
    return distance(p.x, p.y);
  }

  void set_location(T x, T y) {
    this->x = x;
    this->y = y;
  }

  void set_location(point_<T> p) {
    this->x = p.x;
    this->y = p.y;
  }

};

typedef point_<double> point_f;
typedef point_<int> point_i;

#endif //_POINT_T_