#include "frm_main.h"

#define IMAGECLASS frm_main_images
#define IMAGEFILE <upp_demo/image.iml>
#include <Draw/iml.h>
#define IMAGECLASS frm_main_images

using namespace Upp;

uint64_t time_get_msecs() {
  auto p2 = std::chrono::high_resolution_clock::now();
  return std::chrono::duration_cast<std::chrono::microseconds>(p2.time_since_epoch()).count() / 1000;
}


void frm_main::_Refresh() {
  if(show_fps) {
    return;
  }

  std::thread t([=] {
    if(!m_refresh.try_lock()) {
      return;
    }
    if(_need_refresh) {
      m_refresh.unlock();
      return;
    }
    _need_refresh = true;
    m_refresh.unlock();
    //std::this_thread::sleep_for(std::chrono::milliseconds(2));
    Upp::EnterGuiMutex();
    Refresh();
    Upp::LeaveGuiMutex();
  });
  t.detach();
}

frm_main::frm_main() {
  SetRect(0, 0, 800, 591);
  Sizeable();
  
  Title("UPP Demo");

  view_area.cx = 32767;
  view_area.cy = 32767;

  scroll.WhenScroll = THISBACK(scroll_action);
  scroll.NoAutoHide();
  BackPaint();

  AddFrame(scroll);

  scroll.SetPage(GetSize());
  scroll.SetTotal(view_area);
  center_scroll();

  icon_t* first_icon = NULL;
  for(int i = 0; i < 1089; i++) {
    icon_t* icon = new icon_t(IMAGECLASS::icon_icon_small, i);
    icons.push_back(std::pair<int, icon_t*>(i, icon));
    icons_zorder.insert(icons_zorder.begin(), icon);
    icon_auto_place(icon, icons.size() - 1);
    if(first_icon == NULL) {
      first_icon = icon;
    } else {
      _link_add(first_icon, icon);
    }
  }
}

void frm_main::scroll_action() {
  SetFocus();
  _Refresh();
}

void frm_main::Layout() {
  scroll.SetPage(GetSize());
}

icon_t* frm_main::return_icon(std::vector<std::pair<int, icon_t*>>::iterator it) {
  return it->second;
}

icon_t* frm_main::return_icon(std::vector<icon_t*>::iterator it) {
  return *it;
}

template <typename T>
void frm_main::_keep_icon_icons_in_frame_boundary(T& c) {
  int cnt = 0;
  int w =  view_area.cx;
  int h =  view_area.cy;
  bool got_stuck = false;

  for(auto curr = c.begin() ; curr != c.end();) {
    icon_t* icon   = return_icon(curr);
    int x_edge   = icon->get_x() + icon->get_width() - 1;
    int y_edge   = icon->get_y() + icon->get_height() - 1;
    int x        = icon->get_x();
    int y        = icon->get_y();
    int x_offset = 0;
    int y_offset = 0;

    if(cnt >= 10001) {
      got_stuck = true;
      break;
    }
    cnt++;

    if(x < 0 || y < 0 || x_edge > w || y_edge > h) {
      if(x < 0) {
        x_offset = abs(x);
      } else if(x_edge > w) {
        x_offset = abs(x_edge - w) * -1;
      }
      if(y < 0) {
        y_offset = abs(y);
      } else if(y_edge > h) {
        y_offset = abs(y_edge - h) * -1;
      }

      for(auto curr2 = c.begin() ; curr2 != c.end();) {
        icon_t* icon2  = return_icon(curr2);
        icon2->set_x(icon2->get_x() + x_offset);
        icon2->set_y(icon2->get_y() + y_offset);
      }
      curr = c.begin();
      continue;
    }
    curr++;
  }

  if(!got_stuck) {
    return;
  }

  printf("Fix: Got Stuck\n");
  for(auto curr = c.begin() ; curr != c.end(); curr++) {
    icon_t* icon = return_icon(curr);
    int x_edge    = icon->get_x() + icon->get_width() - 1;
    int y_edge    = icon->get_y() + icon->get_height() - 1;
    int x         = icon->get_x();
    int y         = icon->get_y();
    int x_offset  = 0;
    int y_offset  = 0;
    if(x < 0 || y < 0 || x_edge > w || y_edge > h) {
      if(x < 0) {
        x_offset = abs(icon->get_x());
      } else if(x_edge > w) {
        x_offset = abs(x_edge - w) * -1;
      }
      if(y < 0) {
        y_offset = abs(icon->get_y());
      } else if(y_edge > h) {
        y_offset = abs(y_edge - h) * -1;
      }
      icon->set_x(icon->get_x() + x_offset);
      icon->set_y(icon->get_y() + y_offset);
    }
  }
}

void frm_main::_icon_unselect_all_except(icon_t* icon) {
  for(auto curr : icons) {
    icon_t* curr_icon = curr.second;
    if(curr_icon == NULL || curr_icon != icon) {
      curr_icon->icon_state(RS_SELECTED, 0);
    }
  }
}

void frm_main::_icon_unselect_all() {
  _icon_unselect_all_except(NULL);
}

void frm_main::_link_unselect_all_except(link_t* pli) {
  for(auto link : links) {
    if(pli == NULL || link != pli) {
      link->link_state(PS_SELECTED, 0);
    }
  }
}

void frm_main::_link_unselect_all() {
  _link_unselect_all_except(NULL);
}

Image frm_main::MouseEvent(int event, Point p, int zdelta, dword keyflags) {
  int mouse_event = event & ~(LEFT | RIGHT | MIDDLE);
  dword mouse_flags =  keyflags & (K_MOUSELEFT | K_MOUSERIGHT | K_MOUSEMIDDLE | K_MOUSEDOUBLE | K_MOUSETRIPLE);
  if(mouse_event == REPEAT || mouse_event == CURSORIMAGE) {
    goto exit;
  }

  switch(mouse_event) {
    case MOUSEWHEEL: {
      MouseWheel(p, zdelta, keyflags);
      goto exit;
    }
    case MOUSEENTER: {
      MouseEnter(p, keyflags);
      goto exit;
    }
    case MOUSELEAVE: {
      MouseLeave();
      goto exit;
    }
  }

  if(mouse_event != UP && keyflags == 0) {
    mouse_state = 0;
  }

  if((mouse_state & MOUSE_UP)) {
    mouse_state = 0;
  }

  //Add rejection of other buttons once one is in use
  if((mouse_state & MOUSE_LEFT) != 0 && (keyflags & (K_MOUSERIGHT | K_MOUSEMIDDLE)) != 0) {
    goto exit;
  }
  if((mouse_state & MOUSE_RIGHT) != 0 && (keyflags & (K_MOUSELEFT | K_MOUSEMIDDLE)) != 0) {
    goto exit;
  }
  if((mouse_state & MOUSE_MIDDLE) != 0 && (keyflags & (K_MOUSERIGHT | K_MOUSELEFT)) != 0) {
    goto exit;
  }

  if((keyflags & K_MOUSELEFT) == K_MOUSELEFT) {
    mouse_state |= MOUSE_LEFT;
  } else if((keyflags & K_MOUSERIGHT) == K_MOUSERIGHT) {
    mouse_state |= MOUSE_RIGHT;
  } else if((keyflags & K_MOUSEMIDDLE) == K_MOUSEMIDDLE) {
    mouse_state |= MOUSE_MIDDLE;
  }

  if((keyflags & K_MOUSETRIPLE) == K_MOUSETRIPLE) {
    mouse_state &= ~(MOUSE_DOWN | MOUSE_UP | MOUSE_DOUBLE | MOUSE_MOVE | MOUSE_DRAG);
    mouse_state |= MOUSE_TRIPLE;
  } else if((keyflags & K_MOUSEDOUBLE) == K_MOUSEDOUBLE) {
    mouse_state &= ~(MOUSE_DOWN | MOUSE_UP  | MOUSE_MOVE | MOUSE_DRAG);
    mouse_state |= MOUSE_DOUBLE;
  } else if(mouse_event == DOWN) {
    mouse_state &= ~(MOUSE_UP | MOUSE_MOVE | MOUSE_MOVE | MOUSE_DRAG);
    mouse_state |= MOUSE_DOWN;
  } else if(mouse_event == UP) {
    mouse_state &= ~(MOUSE_DOWN | MOUSE_DOUBLE | MOUSE_TRIPLE | MOUSE_MOVE | MOUSE_DRAG);
    mouse_state |= MOUSE_UP;
  } else if(mouse_event == DRAG) {
    mouse_state &= ~(MOUSE_DOWN | MOUSE_MOVE | MOUSE_UP);
    mouse_state |= MOUSE_DRAG;
  } else if((mouse_state & MOUSE_DRAG) != MOUSE_DRAG) {
    mouse_state |= MOUSE_MOVE;
  }

  if(mouse_state & MOUSE_DRAG) {
    MouseDrag(p, keyflags, mouse_state & (MOUSE_LEFT | MOUSE_RIGHT | MOUSE_MIDDLE));
  } else if((mouse_state & MOUSE_DOWN) && (mouse_state & MOUSE_MOVE) == 0) {
    MouseClicked(p, keyflags, mouse_state & (MOUSE_LEFT | MOUSE_RIGHT | MOUSE_MIDDLE), 1);
  } else if((mouse_state & MOUSE_DOUBLE) && (mouse_state & MOUSE_MOVE) == 0) {
    MouseClicked(p, keyflags, mouse_state & (MOUSE_LEFT | MOUSE_RIGHT | MOUSE_MIDDLE), 2);
  } else if((mouse_state & MOUSE_TRIPLE) && (mouse_state & MOUSE_MOVE) == 0) {
    MouseClicked(p, keyflags, mouse_state & (MOUSE_LEFT | MOUSE_RIGHT | MOUSE_MIDDLE), 3);
  } else if(mouse_state & MOUSE_UP) {
    MouseReleased(p, keyflags, mouse_state & (MOUSE_LEFT | MOUSE_RIGHT | MOUSE_MIDDLE));
  } else if(mouse_state & MOUSE_MOVE) {
    MouseMove(p, keyflags);
  }

exit:
  return Image::Arrow();
}

void frm_main::MouseWheel(Point p, int zdelta, dword keyflags) {
  bool do_refresh = false;
  double d = ((zdelta > 0)? -1 : 1);

  if(show_overlay) {
    return;
  }

  if(keyflags & Upp::K_CTRL) {
    double factor = 0.01;

    if(keyflags & Upp::K_SHIFT) {
      factor *= 10;
    } else {
      factor *=  2;
    }

    if(scalefactor - (d * factor) >= 0.04) {
      scalefactor -= d * factor;
      scalefactor = round(scalefactor * 100.0) / 100.0;
    }

    _keep_icon_icons_in_frame_boundary<std::vector<std::pair<int, icon_t*>>>(icons);

    do_refresh = true;
  } else if(!(keyflags & K_SHIFT)) {
    if(d <= 0) {
      scroll.SetY(scroll.GetY() - (100 / scalefactor));
    } else {
      scroll.SetY(scroll.GetY() + (100 / scalefactor));
    }
  } else {
    if(d <= 0) {
      scroll.SetX(scroll.GetX() - (100 / scalefactor));
    } else {
      scroll.SetX(scroll.GetX() + (100 / scalefactor));
    }
  }

  if(do_refresh) {
    _Refresh();
  }
}

void frm_main::MouseClicked(Point pos, dword keyflags, unsigned int type, int clicks) {
  bool do_refesh = false;
  bool do_more   = true;

  SetCapture();

  if(mouse_hover_timer) {
    Upp::KillTimeCallback(&mouse_hover_timer);
    mouse_hover_timer = false;
  }

  if(show_overlay) {
    if(type == MOUSE_LEFT && progress_overlay.set_button_clicked(pos)) {
      show_overlay = false;
      do_refesh = true;
    }
    do_more = false;
  }

  //TODO: Add in overlay click action

  if(do_more == false) {
    if(do_refesh) {
      _Refresh();
    }
    return;
  }

  if(type == MOUSE_LEFT) {
    icon_t* icon;
    link_t* link;
    bool enabled;

    icon = _icon_get_clicked();
    link = _link_get_clicked();

    if((keyflags & K_CTRL) == 0 && (keyflags & K_SHIFT) == 0) {
      _icon_unselect_all();
      icons_selected.clear();

      _link_unselect_all();
      links_selected.clear();
    }

    if(icon != NULL && links_selected.empty()) {
      icon->icon_offset.set_location(get_mouse_point() - get_icon_rect(icon).get_location());

      if(icon->icon_is_handle(icon->icon_offset)) {
        icon->icon_state(0,RS_CONNECTING);
        linkhandle_t plh = icon->get_closest_handle(get_mouse_point(), icon->get_location());
        icon->icon_node = plh.point2;
        icon->icon_end_node = plh.point2;
        icons_selected.insert(icons_selected.begin(), icon);
      } else {
        vector_set_element_position<icon_t*>(icons_zorder, icon, 0);

        if((keyflags & Upp::K_CTRL) == 0 && (keyflags & Upp::K_SHIFT) == 0) {
          icon->icon_state(0, RS_SELECTED);
        } else {
          if((keyflags & Upp::K_SHIFT) != 0) {
            icon->icon_state(0, RS_SELECTED);
          } else {
            if(icon->icon_state_test(RS_SELECTED)) {
              icon->icon_state(RS_SELECTED, 0);
            } else {
              icon->icon_state(0, RS_SELECTED);
            }
          }
        }
        if(icon->icon_state_test(RS_SELECTED)) {
          if(std::find(icons_selected.begin(), icons_selected.end(), icon) == icons_selected.end()) {
            icons_selected.insert(icons_selected.begin(), icon);
          }
        } else {
          auto it = std::find(icons_selected.begin(), icons_selected.end(), icon);
          if(it != icons_selected.end()) {
            icons_selected.erase(it);
          }
          icon = 0;
        }
      }
    } else if(link != NULL && icons_selected.empty()) {
      vector_set_element_position<link_t*>(links, link, 0);
      if((keyflags & Upp::K_CTRL) == 0) {
        link->link_state(0, PS_SELECTED);
      } else {
        if((keyflags & Upp::K_SHIFT) != 0) {
          link->link_state(0, PS_SELECTED);
        } else {
          if(link->link_state_test(PS_SELECTED)) {
            link->link_state(PS_SELECTED, 0);
          } else {
            link->link_state(0, PS_SELECTED);
          }
        }
      }

      if(link->link_state_test(PS_SELECTED)) {
        if(std::find(links_selected.begin(), links_selected.end(), link) == links_selected.end()) {
          links_selected.insert(links_selected.begin(), link);
        }
      } else {
        auto it = std::find(links_selected.begin(), links_selected.end(), link);
        if(it != links_selected.end()) {
          links_selected.erase(it);
        }
        //FIXME: maybe don't do this its used below ?
        link = 0;
      }
    }

    for(auto ticon : icons_zorder) {
      ticon->icon_offset.set_location(get_mouse_point() - get_icon_rect(ticon).get_location());
    }
  } else if(type == MOUSE_RIGHT) {

  } else if(type == MOUSE_MIDDLE) {

  }
  _Refresh();
}

void frm_main::_mouseShowSummaryIcon() {
  bool found = false;
  rect_f rmouse = get_mouse_rect();
  for(auto icon : icons_zorder) {
    rect_f ricon = get_icon_rect(icon);
    if(ricon.intersects(rmouse)) {
      if((time_get_msecs() - mouse_hover_start) > mouse_hover_delay) {
        if(mouse_hover_timer && icon->show_summary_prep) {
          return;
        }
        //A JFrame has been already shown, then show a new one
        Upp::KillTimeCallback(&mouse_hover_timer);
        mouse_hover_start = time_get_msecs();
        mouse_hover_timer = true;
        icon->show_summary_prep = true;
        Upp::SetTimeCallback(mouse_hover_delay, [=]() {
          icon->show_summary = true;
          _Refresh();
        }, &mouse_hover_timer);
      }
      found = true;
    } else {
      icon->show_summary = false;
      icon->show_summary_prep = false;
    }
  }

  if(!found && mouse_hover_timer) {
    Upp::KillTimeCallback(&mouse_hover_timer);
    mouse_hover_timer = false;
    _Refresh();
  }
}

void frm_main::_link_add(icon_t* icon1, icon_t* icon2) {
  link_t* link = NULL;

  if(icon1 == NULL || icon2 == NULL) {
    return;
  }

  for(auto pl : links) {
    if(icon2 != NULL) {
      if((pl->icon1 == icon1 || pl->icon2 == icon1) && (pl->icon2 == icon2 || pl->icon1 == icon2)) {
        return;
      }
    }

    if((pl->icon1 == icon1 || pl->icon2 == icon1) && (pl->icon2_id == icon2->icon_id || pl->icon1_id == icon2->icon_id)) {
      link = pl;
      break;
    }
  }

  if(link == NULL) {
    link = new link_t(icon1, icon2);
    links.push_back(link);
    _Refresh();
  }
}

icon_t* frm_main::_check_snap_to(icon_t* icon, point_f p) {
  if(icon == NULL) {
    return NULL;
  }

  for(auto curr : icons) {
    icon_t* curr_icon = curr.second;
    rect_f rect = curr_icon->get_bounds();
    if(curr_icon != icon && curr_icon->icon_is_handle(p.x - rect.x, p.y - rect.y)) {
      return curr_icon;
    }
  }
  return NULL;
}

rect_f frm_main::get_select_rect() {
  int x1, y1, x2, y2;
  if(group_start.x < group_end.x) {
    x1 = (int)group_start.x;
    x2 = (int)group_end.x;
  } else {
    x1 = (int)group_end.x;
    x2 = (int)group_start.x;
  }
  if(group_start.y < group_end.y) {
    y1 = (int)group_start.y;
    y2 = (int)group_end.y;
  } else {
    y1 = (int)group_end.y;
    y2 = (int)group_start.y;
  }
  return rect_f(x1, y1, abs(x1 - x2), abs(y1 - y2));
}

void frm_main::MouseReleased(Point p, dword keyflags, unsigned int type) {
  ReleaseCapture();

  if(show_overlay) {
    return;
  }

  _mouseShowSummaryIcon();

  if(type == MOUSE_LEFT) {
    progress_overlay.set_button_released();

    if(move_viewarea) {
      move_viewarea = false;
    }

    if(group_selecting) {
      group_selecting = false;
      if((keyflags & (Upp::K_CTRL | Upp::K_SHIFT)) == 0) {
        for(auto icon : icons_selected) {
          icon->icon_state(RS_SELECTED, 0);
        }
        icons_selected.clear();
      }
      for(auto curr : icons) {
        auto icon = curr.second;
        rect_f group_sel = get_select_rect() / scalefactor;
        group_sel.x += scroll.x;
        group_sel.y += scroll.y;

        rect_f ricon = get_icon_rect(icon);
        if(group_sel.intersects(ricon)) {
          icon->icon_state(0, RS_SELECTED);
          icons_selected.insert(icons_selected.begin(), icon);
        }
      }
    }

    if(!icons_selected.empty()) {
      for(auto icon1 : icons_selected) {
        if(icon1->icon_state_test(RS_CONNECTING)) {
          icon_t* icon2 = _check_snap_to(icon1, icon1->icon_end_node());
          if(icon2 != NULL) {
            icon1->icon_state(RS_CONNECTING, 0);
            _link_add(icon1, icon2);

            if((keyflags & (Upp::K_CTRL | Upp::K_SHIFT)) == 0) {
              icon1->icon_state(RS_SELECTED, 0);
              auto it = std::find(icons_selected.begin(), icons_selected.end(), icon1);
              if(it != icons_selected.end()) {
                icons_selected.erase(it);
              }
            }
          }
          icon1->icon_state(RS_CONNECTING, 0);
          break;
        }
      }
    }
  }

  _keep_icon_icons_in_frame_boundary<std::vector<icon_t*>>(icons_selected);

  _Refresh();
}

void frm_main::MouseDrag(Point p, dword keyflags,  unsigned int type) {
  bool needs_refresh = false;

  if(mouse_hover_timer) {
    Upp::KillTimeCallback(&mouse_hover_timer);
    mouse_hover_timer = false;
    needs_refresh = true;
  }

  if(show_overlay) {
    return;
  }

  if(type == MOUSE_LEFT) {
    if(!icons_selected.empty()) {
      bool are_any_connecting = false;
      for(auto icon : icons_selected) {
        if(icon->icon_state_test(RS_CONNECTING)) {
          are_any_connecting = true;
          needs_refresh = true;
          break;
        }
      }


      for(auto icon : icons_selected) {
        if(icon->icon_state_test(RS_SELECTED) && !are_any_connecting) {
          point_f new_loc = (((get_mouse_point() - icon->icon_offset) / 10) * 10);
          icon->set_location(new_loc);
          needs_refresh = true;
        }
        if(icon->icon_state_test(RS_CONNECTING)) {
          point_f mp = get_mouse_point();
          icon_t* eicon = _check_snap_to(icon, mp);
          if(eicon != NULL) {
            linkhandle_t plh = icon->get_closest_handle(mp, eicon->get_location());
            icon->icon_end_node = plh.point2;
          } else {
            icon->icon_end_node = mp;
          }
        }
      }
    } else {
      point_f mp = p;
      if(!group_selecting && !move_viewarea && (keyflags & Upp::K_SHIFT) == 0) {
        move_start.set_location(mp);
        move_viewarea = true;
        needs_refresh = true;
      } else if(move_viewarea) {
        int x = 0;
        int y = 0;
        Upp::Point visible = scroll;
        if(mp.x > move_start.x) {
          x = -(int)(mp.x - move_start.x);
        } else if(mp.x < move_start.x) {
          x =  (int)(move_start.x - mp.x);
        }
        if(mp.y > move_start.y) {
          y = -(int)(mp.y - move_start.y);
        } else if(mp.y < move_start.y) {
          y =  (int)(move_start.y - mp.y);
        }

        visible.x += x / scalefactor;
        visible.y += y / scalefactor;

        scroll.Set(visible.x, visible.y);
        move_start.set_location(mp.x, mp.y);
        needs_refresh = true;
      }

      if(!group_selecting && !move_viewarea  && (keyflags & Upp::K_SHIFT) != 0) {
        group_start.set_location(mp);
        group_end.set_location(mp);
        group_selecting = true;
        needs_refresh = true;
      } else if(group_selecting) {
        group_end.set_location(mp);
        needs_refresh = true;
      }
    }
  }

  if(needs_refresh) {
    _Refresh();
  }
}

void frm_main::MouseMove(Point p, dword keyflags) {
  if(show_overlay) {
    if(mouse_hover_timer) {
      Upp::KillTimeCallback(&mouse_hover_timer);
      mouse_hover_timer = false;
      return;
    }
  }

  _mouseShowSummaryIcon();
}

void frm_main::MouseEnter(Point p, dword keyflags) {
}

void frm_main::MouseLeave() {
}

bool frm_main::Key(dword key, int count) {
  bool is_pressed = (key & K_KEYUP) == 0;
  key &= ~(key & K_KEYUP);

  if(is_pressed) { //key is pressed
    switch(key) {
      case K_DELETE: {
        if(links.empty()) {
          break;
        }
        for(auto link : links_selected) {
          for(auto it = links.begin(); it != links.end(); it++) {
            if(link == (*it)) {
              delete (*it);
              links.erase(it);
              break;
            }
          }
        }
        links_selected.clear();
        _Refresh();
        break;
      }
      case K_F1: {
        if(links.empty()) {
          break;
        }

        show_link_details = !show_link_details;
        _Refresh();
        break;
      }
      case K_F2: {
        show_overlay = !show_overlay;
        if(show_overlay) {
          progress_overlay.set_progress_text("Progress 1");
          progress_overlay.set_progress_percent((rand() % 101) / 100.0);
          progress_overlay.set_progress2_text("Progress 2");
          progress_overlay.set_progress2_percent((rand() % 101) / 100.0);
        }
        _Refresh();
        break;
      }
      case K_F3: {
        fps_count = 0;
        show_fps = !show_fps;
        Refresh();
        break;
      }
      case K_F4: {
        if(!links.empty()) {
          for(int i = 0; i < links.size(); i++) {
            delete links[i];
          }
          links.clear();
        } else {
          icon_t* first_icon = NULL;
          for(int i = 0; i < icons.size(); i++) {
            icon_t* icon = icons[i].second;
            if(first_icon == NULL) {
              first_icon = icon;
            } else {
              _link_add(first_icon, icon);
            }
          }
        }
        _Refresh();
        break;
      }
      case K_PAGEUP:
      case K_CTRL_UP: {
        scroll.PageUp();
        break;
      }

      case K_PAGEDOWN:
      case K_CTRL_DOWN: {
        scroll.PageDown();
        break;
      }

      case K_CTRL_PAGEUP:
      case K_CTRL_LEFT: {
        scroll.PageLeft();
        break;
      }

      case K_CTRL_PAGEDOWN:
      case K_CTRL_RIGHT: {
        scroll.PageRight();
        break;
      }

      case K_SHIFT_UP: {
        scroll.LineUp();
        break;
      }

      case K_SHIFT_DOWN: {
        scroll.LineDown();
        break;
      }

      case K_SHIFT_LEFT: {
        scroll.LineLeft();
        break;
      }

      case K_SHIFT_RIGHT: {
        scroll.LineRight();
        break;
      }

      case K_UP: {
        scroll.WheelY(120);
        break;
      }

      case K_DOWN: {
        scroll.WheelY(-120);
        break;
      }

      case K_LEFT: {
        scroll.WheelX(120);
        break;
      }

      case K_RIGHT: {
        scroll.WheelX(-120);
        break;
      }
    }
  }
  return true;
}

void frm_main::_icons_paint(Draw& w, int x_offset, int y_offset, bool _allow_scaling, bool _render_everything, Color overlay_color) {
  icon_t* summary_icon = NULL;
  rect_f visible = rect_f(scroll.x, scroll.y, GetSize().cx / scalefactor, GetSize().cy / scalefactor);

  w.Begin();

  for(int i = icons_zorder.size() - 1; i >= 0; i--) {
    icon_t* icon = icons_zorder[i];
    rect_f ricon;

    if(icon->show_summary) {
      summary_icon = icon;
      if(!mouse_hover_timer) {
        summary_icon = 0;
        icon->show_summary = false;
      }
    }

    ricon = icon->get_bounds();

    if(_render_everything || ricon.intersects(visible)) {
      if(_allow_scaling) {
        icon->set_scale(scalefactor);
      }
      if(show_overlay) {
        icon->set_background_color(overlay_color);
      } else {
        icon->set_background_color(JWhite());
      }
      icon->icon_paint(w, x_offset, y_offset);
    }
  }
  w.End();

  Upp::Size sz = GetSize();
  Upp::ImageBuffer ib(scroll.GetViewSize());
  Upp::BufferPainter bp(ib, Upp::MODE_ANTIALIASED);

  bp.Co();
  
  bp.Clear(Upp::RGBAZero());

  for(int j = links.size() - 1;j >= 0;j--) {
    link_t* link = links[j];
    if(link->icon2 != NULL && (link->icon1->get_bounds().intersects(visible) || link->icon2->get_bounds().intersects(visible))) {
        link->paint(bp, x_offset, y_offset, show_link_details);
    }
  }

  for(int i = icons_zorder.size() - 1; i >= 0; i--) {
    icon_t* icon = icons_zorder[i];
    point_f node;
    point_f end_node;
    point_f sc = point_f(x_offset, y_offset);

    if(!icon->icon_state_test(RS_CONNECTING)) {
      continue;
    }

    node = icon->icon_node - sc;
    end_node = icon->icon_end_node - sc;
    paint_drawline(bp, (int)node.x, (int)node.y, (int)end_node.x, (int)end_node.y, 2, JBlack());
  }

  if(group_selecting) {
    rect_f group_sel = get_select_rect() / scalefactor;
    paint_drawrect(bp, group_sel.x, group_sel.y, group_sel.width, group_sel.height, 2, JBlack());
  }

  if(summary_icon != NULL) {
    summary_icon->icon_summary_paint(bp, x_offset, y_offset);
  }

  if(show_overlay) {
    _paint_overlay(bp);
  }

  if(_allow_scaling) {
    bp.Scale(scalefactor, scalefactor);
  }

  bp.Finish();
  
  SetSurface(w, 0, 0, scroll.GetViewSize().cx, scroll.GetViewSize().cy, ~ib);

#if 0
  //Debug code
  Point mp = GetMouseViewPos();
  double hs = mouse_hit_size;
  rect_f f = rect_f(((mp.x / scalefactor) - (hs / 2)), ((mp.y / scalefactor) - (hs / 2)), hs, hs);
  paint_drawrect(bp, f.x, f.y, f.width, f.height, 1, JGreen(), JGreen());
#endif

}

void frm_main::_paint_overlay(Upp::BufferPainter& bp) {
  Upp::Size sz = scroll.GetViewSize();
  Upp::RGBA bg = RGBAZero();
  bg.a = 255 * 0.45;

  progress_overlay.set_location(((sz.cx / 2) - (progress_overlay.width() / 2)), ((sz.cy / 2) - (progress_overlay.height() / 2)));
  progress_overlay.Paint(bp, scroll.GetViewSize(), GetMouseViewPos());
}

void frm_main::Paint(Draw& w) {
  RGBA overlay_color = JBlack();
  overlay_color.r = 255 - (255 * 0.45);
  overlay_color.g = overlay_color.r;
  overlay_color.b = overlay_color.r;

  if(show_overlay) {
    w.DrawRect(scroll.GetViewSize(), overlay_color);
  } else {
    w.DrawRect(scroll.GetViewSize(), JWhite());
  }

  _icons_paint(w, scroll.Get().x, scroll.Get().y, allow_scaling, render_everything, overlay_color);

  
  if(show_fps) {
    fps_count++;
  	if(fps_start == 0) {
  	  fps_start = time_get_msecs();
  	} else if(time_get_msecs() - fps_start > 1000) {
  	  fps_start = time_get_msecs();
  	  fps = fps_count;
  	  fps_count = 0;
  	}
  	w.DrawText(10, 10, Upp::Format("FPS: %i", fps), Upp::Monospace(12), JRed());
  	Refresh();
    m_refresh.try_lock();
    m_refresh.unlock();
  } else {
    m_refresh.lock();
    _need_refresh = false;
    m_refresh.unlock();
  }

}

void frm_main::_clear() {
  for(auto c : icons) {
    delete c.second;
  }
  icons.clear();

  for(auto c : links) {
    delete c;
  }
  links.clear();
}

frm_main::~frm_main() {
  _clear();
}

point_f frm_main::get_point_pos(double x, double y) {
  point_f p = point_f(x / scalefactor, y / scalefactor);
  p.x += scroll.GetX();
  p.y += scroll.GetY();
  return p;
}

point_f frm_main::get_point_pos(point_f p) {
  return get_point_pos(p.x, p.y);
}

point_f frm_main::get_point_pos(Point p) {
  return get_point_pos(p.x, p.y);
}

point_f frm_main::get_mouse_point() {
  return get_point_pos(GetMouseViewPos());
}

rect_f frm_main::get_mouse_rect() {
  point_f p = get_mouse_point();
  double hs = mouse_hit_size;
  return rect_f(p.x - (hs / 2), p.y - (hs / 2), hs, hs);
}

rect_f frm_main::get_icon_rect(icon_t* icon) {
  rect_f ricon = icon->get_bounds();
  return ricon;
}

icon_t* frm_main::_icon_get_clicked() {
  icon_t* ret_icon = NULL;
  rect_f rmouse = get_mouse_rect();
  for(auto icon : icons_zorder) {
    rect_f ricon = get_icon_rect(icon);
    if(ricon.intersects(rmouse)) {
      ret_icon = icon;
      break;
    }
  }
  return ret_icon;
}

link_t* frm_main::_link_get_clicked() {
  point_f mp = get_mouse_point();
  link_t* ret = NULL;

  for(auto link : links) {
    icon_t* icon1 = link->icon1;
    icon_t* icon2 = link->icon2;
    if(icon1 != NULL && icon2 != NULL) {
      linkhandle_t plh = icon1->get_shortest_handle(icon2);
      rect_f rmouse = get_mouse_rect();
      point_f sp1 = plh.point1;
      point_f sp2 = plh.point2;
      line_f l1 = line_f(sp1.x, sp1.y, sp2.x, sp2.y);
      if(l1.intersects(rmouse)) {
        ret = link;
        break;
      }
    }
  }
  return ret;
}

void frm_main::icon_auto_place(icon_t* icon, int icon_index) {
  int pos_x = 0;
  int pos_y = 0;
  if(origin_x == 0) {
    pos_x = (view_area.cx / 2);
    pos_y = (view_area.cy / 2);
    origin_x = pos_x;
    origin_y = pos_y;
  } else {
    pos_x = origin_x;
    pos_y = origin_y;
  }

  int unit_x = icon->get_width() + 20;
  int unit_y = icon->get_height() + 20;

  int loop = 0;
  int loop_dec = 8;
  int loop_pos = 0;
  int loop_side = 0;
  int q1 = 0;
  int q2 = 0;
  int q3 = 0;
  int q4 = 0;
  while(icon_index > 0) {
    icon_index -= loop_dec;
    loop_pos = (loop_dec + icon_index) - 1;
    loop_dec += 8;
    loop++;
  }
  loop_side = (loop * 2);
  q1 = loop_side;
  q2 = (loop_side * 2);
  q3 = (loop_side * 3);
  q4 = (loop_side * 4);

  if(loop_pos <= q1) {
    pos_x -= (unit_x * loop);
    pos_y -= (unit_y * loop);

    pos_y += (unit_y * loop_pos);
  } else if(loop_pos <= q2) {
    pos_x -= (unit_x * loop);
    pos_y += (unit_y * loop);

    pos_x += (unit_x * (loop_pos - q1));
  } else if(loop_pos <= q3) {
    pos_x += (unit_x * loop);
    pos_y += (unit_y * loop);

    pos_y -= (unit_y * (loop_pos - q2));
  } else if(loop_pos <= q4) {
    pos_x += (unit_x * loop);
    pos_y -= (unit_y * loop);

    pos_x -= (unit_x * (loop_pos - q3));
  }
  pos_x = (pos_x / 10) * 10;
  pos_y = (pos_y / 10) * 10;

  icon->set_location(pos_x, pos_y);
  _Refresh();
}

GUI_APP_MAIN
{
  frm_main* mainapp = new frm_main();

  mainapp->Run();

  delete mainapp;
}