#ifndef __PAINT_H__
#define __PAINT_H__
#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>
#include <string>

inline Upp::Color JWhite() {
  return Upp::Color(255, 255, 255);
}
inline Upp::Color JLightGray() {
  return Upp::Color(192, 192, 192);
}
inline Upp::Color JGray() {
  return Upp::Color(128, 128, 128);
}
inline Upp::Color JDarkGray() {
  return Upp::Color(64, 64, 64);
}
inline Upp::Color JBlack() {
  return Upp::Color(0, 0, 0);
}
inline Upp::Color JRed() {
  return Upp::Color(255, 0, 0);
}
inline Upp::Color JPink() {
  return Upp::Color(255, 175, 175);
}
inline Upp::Color JOrange() {
  return Upp::Color(255, 200, 0);
}
inline Upp::Color JYellow() {
  return Upp::Color(255, 255, 0);
}
inline Upp::Color JGreen() {
  return Upp::Color(0, 255, 0);
}
inline Upp::Color JMagenta() {
  return Upp::Color(255, 0, 255);
}
inline Upp::Color JCyan() {
  return Upp::Color(0, 255, 255);
}
inline Upp::Color JBlue() {
  return Upp::Color(0, 0, 255);
}

inline void paint_drawline(Upp::Painter& bp, int x1, int y1, int x2, int y2, double stroke, Upp::RGBA color, const char* dash = "", bool center_from_point = true) {
  double center_of_line_x = 0;
  double center_of_line_y = 0;
  if(center_from_point) {
    if(x1 == x2) {
      center_of_line_x = (((((int)stroke) % 2) != 0)?0.5:0.0);
    }
    if(y1 == y2) {
      center_of_line_y = (((((int)stroke) % 2) != 0)?0.5:0.0);
    }
  } else {
    if(x1 == x2) {
      center_of_line_x = stroke / 2.0;
    }
    if(y1 == y2) {
      center_of_line_y = stroke / 2.0;
    }
  }

  bp.Move(x1 + center_of_line_x, y1 + center_of_line_y).Line(x2 + center_of_line_x, y2 + center_of_line_y).Dash(dash).Stroke(stroke, color);
}

inline void paint_drawtext(Upp::BufferPainter& bp, double x, double y, const std::string& text, Upp::Font font, Upp::RGBA color, int align = 1) {
  double sub_y = 0.0;
  if(align == 1) {
    sub_y -= font.GetHeight();
  } else if(align) {
    sub_y -= font.GetHeight() / 2.0;
  }
  bp.Text(x, y + sub_y, text.c_str(), font).Fill(color);
}

inline void paint_drawrect(Upp::BufferPainter& bp, int x, int y, int width, int height, double stroke, Upp::RGBA stroke_color, Upp::RGBA fill_color = Upp::RGBAZero(), bool center_from_point = true, const char* dash = "") {
  double center_of_line_x = 0;
  double center_of_line_y = 0;
  if(center_from_point) {
    center_of_line_x = (((((int)stroke) % 2) != 0)?0.5:0.0);
    center_of_line_y = (((((int)stroke) % 2) != 0)?0.5:0.0);
  } else {
    center_of_line_x = stroke / 2.0;
    center_of_line_y = stroke / 2.0;
  }
  bp.Rectangle(x + center_of_line_x, y + center_of_line_y, width, height).Fill(fill_color).Dash(dash).Stroke(stroke, stroke_color);
}

inline Upp::RGBA paint_color_lighter(Upp::Color c) {
  Upp::RGBA cc = c;

  int i = 1.0 / (1.0 - 0.7);

  if(cc.r == 0 && cc.g == 0 && cc.b == 0) {
    cc.r = i;
    cc.g = i;
    cc.b = i;
    return cc;
  }
  cc.r = Upp::min(((int)(cc.r / 0.7)), 255);
  cc.g = Upp::min(((int)(cc.g / 0.7)), 255);
  cc.b = Upp::min(((int)(cc.b / 0.7)), 255);
  return cc;
}

inline Upp::RGBA paint_color_darker(Upp::Color c) {
  Upp::RGBA cc = c;
  cc.r = Upp::max(((int)(cc.r * 0.7)), 0);
  cc.g = Upp::max(((int)(cc.g * 0.7)), 0);
  cc.b = Upp::max(((int)(cc.b * 0.7)), 0);
  return cc;
}

inline void paint_draw3drect(Upp::BufferPainter& bp, int x, int y, int width, int height, double stroke, Upp::RGBA stroke_color, Upp::RGBA fill_color, bool raised) {
  Upp::Color light = paint_color_lighter(stroke_color);
  Upp::Color dark  = paint_color_darker(stroke_color);

  //Fill Rect
  paint_drawrect(bp, x + 1, y + 1, width, height, 0, fill_color, fill_color, false, NULL);

  //Left Side
  paint_drawline(
    bp,
    x,
    y,
    x,
    y + height + 1,
    1,
    raised ? light : dark,
    0,
    true
  );

  //Top Side
  paint_drawline(
    bp,
    x + 1,
    y,
    x + width,
    y,
    1,
    raised ? light : dark,
    0,
    true
  );

  //Right Side
  paint_drawline(
    bp,
    x + width,
    y,
    x + width,
    y + height,
    1,
    raised ? dark : light,
    0,
    true
  );

  //Bottom Side
  paint_drawline(
    bp,
    x + 1,
    y + height,
    x + width + 1,
    y + height,
    1,
    raised ? dark : light,
    0,
    true
  );
}
#endif