#ifndef _PROGRESS_T_
#define _PROGRESS_T_

#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>
#include "paint.h"

class progress_t {
  protected:
    rect_f rect;

    int    button_state;
    Upp::Image  button_img;
    std::string button_text;
    rect_f button_rect;
    bool   button_has_focus;

    rect_f progress_rect;
    std::string progress_text;
    double progress_percent;

  public:

    progress_t() {
      rect             = rect_f(0, 0, 400, 65);
      button_state     = Upp::CTRL_NORMAL;
      button_has_focus = false;
      button_rect      = rect_f(0, 0, 90, 25);
      progress_rect    = rect_f(30, 10, 340, 20);
      progress_percent = 0.0;
      button_text      = "Cancel";
      update_button_location();
    }

    void set_location(double x, double y) {
      rect.x = x;
      rect.y = y;
      update_button_location();
    }

    void set_size(double width, double height) {
      rect.width  = width;
      rect.height = height;
      update_button_location();
    }

    double width() {
      return rect.width;
    }

    double height() {
      return rect.height;
    }

    void set_button_size(double width, double height) {
      button_rect.width  = width;
      button_rect.height = height;
      update_button_location();
    }

    void set_button_text(std::string text) {
      button_text = text;
    }

    void set_button_released() {
      button_state = Upp::CTRL_NORMAL;
    }

    bool set_button_clicked(Upp::Point mp) {
      rect_f mr = rect_f(mp.x, mp.y, 1, 1);
      if(button_rect.intersects(mr)) {
        button_state = Upp::CTRL_PRESSED;
        return true;
      } else {
        button_state = Upp::CTRL_NORMAL;
        return false;
      }
    }

    void set_progress_location(double x, double y) {
      progress_rect.x = x;
      progress_rect.y = y;
    }

    void set_progress_size(double width, double height) {
      progress_rect.width  = width;
      progress_rect.height = height;
    }

    void set_progress_text(std::string text) {
      this->progress_text = text;
    }

    void set_progress_percent(double percent) {
      progress_percent = percent;
    }

    void Paint(Upp::BufferPainter& bp, Upp::Size sz, Upp::Point mp) {
      rect_f mr = rect_f(mp.x, mp.y, 1, 1);

      if(button_state == Upp::CTRL_NORMAL || button_state == Upp::CTRL_HOT) {
        if(button_rect.intersects(mr)) {
          button_state = Upp::CTRL_HOT;
        } else {
          button_state = Upp::CTRL_NORMAL;
        }
      }

      //paint_draw3drect(bp, rect.x, rect.y, rect.width, rect.height, 1, SColorPaper(), SColorPaper(), true);
      paint_draw3drect(bp, rect.x, rect.y, rect.width, rect.height, 1, JGray(), JBlue(), true);

      paint_draw3drect(bp, rect.x + progress_rect.x, rect.y + progress_rect.y, progress_rect.width, progress_rect.height, 1, JWhite(), JWhite(), false);
      if(progress_percent > 0.0) {
        paint_draw3drect(bp, rect.x + progress_rect.x, rect.y + progress_rect.y, (progress_rect.width * progress_percent), progress_rect.height, 1, JOrange(), JOrange(), false);
      }
      paint_text(bp, progress_text, rect.x + progress_rect.x, rect.y + progress_rect.y, progress_rect.width, progress_rect.height, true);

      Upp::Button::PaintButton(
        bp,
        Upp::Rect(
          button_rect.x,
          button_rect.y,
          button_rect.x + button_rect.width,
          button_rect.y + button_rect.height
        ),
        Upp::Button::StyleOk(),
        button_state,
        button_has_focus,
        button_text.c_str(),
        Upp::StdFont(),
        button_img,
        false,
        0,
        false,
        true
      );
    }

  protected:
    void paint_text(Upp::BufferPainter& bp, std::string text, int x, int y, int width, int height, bool center) {
      Upp::Font font = Upp::SansSerif(13);
      int  xoff = font.GetWidth('F');
        if(center) {
        xoff = 0;
        for(int i = 0; i < text.length();i++) {
          xoff += font.GetWidth(text[i]);
        }
        xoff = (width - xoff) / 2;
        if(xoff < 0) {
          xoff = 0;
        }
      }
      paint_drawtext(bp, x + xoff, y + (height / 2.0) - 1.5, text, font, JBlack(), 2);
    }

    void update_button_location() {
      button_rect.x = rect.x + ((rect.width - button_rect.width) / 2.0);
      button_rect.y = rect.y + rect.height - button_rect.height - 5;
    }
};

class progress2_t : public progress_t {
  protected:
    rect_f progress2_rect;
    std::string progress2_text;
    double progress2_percent;

  public:
    void set_progress2_location(double x, double y) {
      progress2_rect.x = x;
      progress2_rect.y = y;
    }

    void set_progress2_size(double width, double height) {
      progress2_rect.width  = width;
      progress2_rect.height = height;
    }

    void set_progress2_text(std::string text) {
      progress2_text = text;
    }

    void set_progress2_percent(double percent) {
      progress2_percent = percent;
    }

    progress2_t() {
      rect.height       += 27;
      progress2_rect    = rect_f(progress_rect);
      progress2_rect.y += progress_rect.height + 4;
      progress2_percent = 0.0;
    }

    void Paint(Upp::BufferPainter& bp, Upp::Size sz, Upp::Point mp) {
      progress_t::Paint(bp, sz, mp);

      paint_draw3drect(bp, rect.x + progress2_rect.x, rect.y + progress2_rect.y, progress2_rect.width, progress2_rect.height, 1, JWhite(), JWhite(), true);
      if(progress2_percent > 0.0) {
        paint_draw3drect(bp, rect.x + progress2_rect.x, rect.y + progress2_rect.y, (progress2_rect.width * progress2_percent), progress2_rect.height, 1, JOrange(), JOrange(), true);
      }
      paint_text(bp, progress2_text, rect.x + progress2_rect.x, rect.y + progress2_rect.y, progress2_rect.width, progress2_rect.height, true);
    }
};

#endif //_PROGRESS_T_