#ifndef _LINK_T_H_
#define _LINK_T_H_

#include "icon_t.h"
#include "linkhandle_t.h"

enum {
  PS_NONE     = 0,
  PS_SELECTED = 1,
  PS_DISABLED = 2,
  PS_BACKUP   = 4,
  PS_BROKEN   = 8,
};

class link_t {
  public:
    icon_t* icon1 = 0;
    int     icon1_id = -1;
    icon_t* icon2 = 0;
    int     icon2_id = -1;

    unsigned int _link_state;

    bool link_state_test(unsigned int has_bits) {
      return ((_link_state & has_bits) != 0);
    }

    unsigned int link_state() {
      return _link_state;
    }

    void link_state(unsigned int unset_bits, unsigned int set_bits) {
      _link_state = (set_bits | (_link_state & ~unset_bits));
    }

    const char* link_default_stroke() {
      return "";
    }

    const char* link_backup_stroke() {
      return "4";
    }

    const char* link_stroke() {
      const char* bs = link_default_stroke();
      if(link_state_test(PS_BACKUP)) {
        bs = link_backup_stroke();
      }

      if(link_state_test(PS_SELECTED)) {
        bs = link_default_stroke();
      }
      return bs;
    }

    Upp::Color link_default_color() {
      return JBlack();
    }

    Upp::Color link_line_color() {
      Upp::Color c = link_default_color();

      if(link_state_test(PS_DISABLED)) {
        c = JMagenta();
      }
      if(link_state_test(PS_SELECTED)) {
        c = JCyan();
      }
      return c;
    }

    void paint_link_info(Upp::BufferPainter& bp,int x, int y) {
      Upp::Font text_font = Upp::Monospace(12);
      int fh = text_font.GetHeight();
      Upp::Color c = link_default_color();
      float stroke = 2;
      int aling = 2;
      paint_drawtext(bp, x + stroke, y + stroke + (fh / 2.0f), "VALUE1: VA1 TST", text_font, c, aling);
      paint_drawtext(bp, x + stroke, y + stroke + (fh / 2.0f) + 11, "VALUE2: VA2 TSTS", text_font, c, aling);
      paint_drawtext(bp, x + stroke, y + stroke + (fh / 2.0f) + 22, "TESTING: Y", text_font, c, aling);
      paint_drawtext(bp, x + stroke, y + stroke + (fh / 2.0f) + 33, "UNKNOWN", text_font, c, aling);
    }

    void paint(Upp::BufferPainter& bp, int x_offset, int y_offset, bool show_peerinfo) {
      int rx1;
      int rx2;
      int ry1;
      int ry2;
      int width;
      int height;
      int line_width;
      int x;
      int y;
      int rssi;
      int connected_assoc;
      int port_state;
      int chanwidth;
      float rate;
      bool is_backup;
      linkhandle_t plh;

      if(icon1 == NULL || icon2 == NULL) {
        return;
      }

      plh = icon1->get_shortest_handle(icon2);

      is_backup = false;

      paint_drawline(bp, plh.point1.x - x_offset, plh.point1.y - y_offset, plh.point2.x - x_offset, plh.point2.y - y_offset, 2, link_line_color(), ((is_backup)?link_backup_stroke():link_stroke()));

      if(!show_peerinfo) {
        return;
      }

      if(plh.point1.x < plh.point2.x) {
        rx1 = plh.point1.x;
        rx2 = plh.point2.x;
      } else {
        rx2 = plh.point1.x;
        rx1 = plh.point2.x;
      }
      if(plh.point1.y < plh.point2.y) {
        ry1 = plh.point1.y;
        ry2 = plh.point2.y;
      } else {
        ry2 = plh.point1.y;
        ry1 = plh.point2.y;
      }

      rx1 -= x_offset;
      rx2 -= x_offset;
      ry1 -= y_offset;
      ry2 -= y_offset;


      width      = 115;
      height     = 49;
      line_width = 2;
      x          = (rx1 + ((rx2 - rx1) / 2) - (int)(line_width / 2)) - (width / 2);
      y          = (ry1 + ((ry2 - ry1) / 2)) - (height / 2);

      paint_drawrect(bp, x, y, width, height, 2, link_line_color(), JWhite(), false);

      rssi            = 0;
      connected_assoc = 0;
      port_state      = 0;
      rate            = 0.0f;

      chanwidth = 0;

      paint_link_info(bp, x, y);
    }

    link_t(icon_t* icon1, icon_t* icon2) {
      this->_link_state = PS_NONE;
      this->icon1       = icon1;
      this->icon1_id    = icon1->icon_id;
      this->icon2       = icon2;
      this->icon2_id    = icon2->icon_id;
    }

    bool contains(uint64_t icon_id) {
      if(this->icon1_id == icon_id) {
        return true;
      }

      if(this->icon2_id == icon_id) {
        return true;
      }

      return false;
    }

    bool equals(uint64_t icon1_id, uint64_t icon2_id) {
      return (
        (this->icon1_id == icon1_id || this->icon1_id == icon2_id) &&
        (this->icon2_id == icon2_id || this->icon2_id == icon1_id)
      );
    }

    bool operator==(const link_t& a) {
      return equals(a.icon1_id, a.icon2_id);
    }
};

#endif //_LINK_T_H_