#ifndef _EOPTION_H_
#define _EOPTION_H_
#include "CtrlLib/CtrlLib.h"

namespace Upp {
  class eOption : public Pusher {
    public:
      virtual void   Paint(Draw& draw);
      virtual Size   GetMinSize() const;
      virtual void   SetData(const Value& data);
      virtual Value  GetData() const;
      virtual void   MouseEnter(Point, dword);
      virtual void   MouseLeave();
      virtual void   State(int);

    protected:
      virtual void  RefreshPush();
      virtual void  RefreshFocus();
      virtual void  PerformAction();

    protected:
      Image  edge, edged;
      int    option;
      bool   switchimage:1;
      bool   threestate:1;
      bool   notnull:1;
      bool   blackedge:1;
      bool   showlabel:1;
      bool   box:1;
      bool   autobox:1;
      bool   labelleft:1;
      int    labelgap;
      Color  color;

      void   AutoSync();

    public:
      eOption& Set(int b);
      int     Get() const                           { return option; }

      operator int() const                          { return option; }
      void operator=(int b)                         { Set(b); }

      void    EnableBox(bool b);
      void    EnableBox()                           { EnableBox(option); }

      eOption& LabelLeft(bool b = true)               { labelleft = b; Refresh(); return *this; }
      bool    IsLabelLeft() const                   { return labelleft; }
      eOption& LabelGap(int n = DPI(2))               { labelgap = n; Refresh(); return *this; }
      eOption& BlackEdge(bool b = true)              { blackedge = b; Refresh(); return *this; }
      bool    IsBlackEdge() const                   { return blackedge; }
      eOption& SwitchImage(bool b = true)            { switchimage = b; Refresh(); return *this; }
      bool    IsSwitchImage() const                 { return switchimage; }
      eOption& ThreeState(bool b = true)             { threestate = b; notnull = false; return *this; }
      bool    IsThreeState() const                  { return threestate; }
      eOption& ShowLabel(bool b = true)              { showlabel = b; Refresh(); return *this; }
      bool    IsShowLabel() const                   { return showlabel; }
      eOption& NotNull(bool nn = true)               { notnull = nn; Refresh(); return *this; }
      eOption& NoNotNull()                           { return NotNull(false); }
      bool    IsNotNull() const                     { return notnull; }
      eOption& SetColor(Color c)                     { color = c; Refresh(); return *this; }
      eOption& Box(bool b = true)                    { box = b; return *this; }
      eOption& AutoBox(bool b = true)                { Box(autobox = b); return *this; }

      eOption();
      virtual ~eOption();
  };
}

#endif //_EOPTION_H_