#include "eOption.h"

namespace Upp {
  void  eOption::MouseEnter(Point, dword)
  {
    RefreshPush();
  }

  void  eOption::MouseLeave()
  {
    RefreshPush();
    Pusher::MouseLeave();
  }

  void eOption::RefreshFocus() {
    Refresh();
  }

  void  eOption::State(int s)
  {
    AutoSync();
    Pusher::State(s);
  }

  void eOption::RefreshPush() {
    if(box)
      Refresh(0, 0, GetSize().cx, GetSmartTextSize(label, font).cy);
    else
    if(showlabel)
      Refresh((labelleft)?GetSmartTextSize(label, font).cx + DPI(labelgap):0, 0, CtrlsImg::O0().GetSize().cx, GetSize().cy);
    else
      Pusher::RefreshPush();
  }

  void eOption::EnableBox(bool b)
  {
    Ctrl *p = GetParent();
    if(!p)
      return;
    Rect r = GetScreenRect();
    for(Ctrl *q = p->GetFirstChild(); q; q = q->GetNext())
      if(q != this && r.Intersects(q->GetScreenRect()))
        q->Enable(b);
  }

  void eOption::AutoSync()
  {
    if(!autobox)
      return;
    Ctrl *p = GetParent();
    if(!p)
      return;
    Rect r = GetScreenRect();
    for(Ctrl *q = p->GetFirstChild(); q; q = q->GetNext())
      if(q != this && r.Intersects(q->GetScreenRect()))
        q->Enable(option);
  }

  Size eOption::GetMinSize() const {
    Size isz = CtrlsImg::O0().GetSize();
    return AddFrameSize(isz.cx + (GetSmartTextSize(label).cx + DPI(labelgap)) * showlabel,
                      max(isz.cy, StdFont().Info().GetHeight()) + 2);
  }

  void eOption::Paint(Draw& w) {
    Size sz = GetSize();

    if(!IsTransparent())
      w.DrawRect(0, 0, sz.cx, sz.cy, SColorFace);

    Size isz = CtrlsImg::O0().GetSize();
    Size tsz = GetSmartTextSize(label, font);
    int ix = 0;
    int d = tsz.cy >> 1;
    int ty = (sz.cy - tsz.cy) / 2;
    int iy = (tsz.cy - isz.cy) / 2 + ty;

    if(box) {
      ix = d + DPI(4);
      if(tsz.cy > isz.cy) {
        ty = 0;
        iy = (tsz.cy - isz.cy) / 2;
      }
      else {
        iy = 0;
        ty = (isz.cy - tsz.cy) / 2;
      }
    }
    else
    if(!showlabel) {
      ix = (sz.cx - isz.cx) / 2;
      iy = (sz.cy - isz.cy) / 2;
    }

    int q = GetVisualState();
    int g = (!notnull || threestate) && IsNull(option) ? CtrlsImg::I_O2
                                                      : option == 1 ? CtrlsImg::I_O1
                                                                    : CtrlsImg::I_O0;
    if(switchimage)
      g = option ? CtrlsImg::I_S1 : CtrlsImg::I_S0;

    int i_offset;
    int t_offset;
    if(labelleft) {
      i_offset = ix + tsz.cx + DPI(labelgap);
      t_offset = ix;
    } else {
      i_offset = ix;
      t_offset = ix + isz.cx + DPI(labelgap);
    }

    w.DrawImage(i_offset, iy, CtrlsImg::Get(g + q));

    if(showlabel) {
      bool ds = !IsShowEnabled();
      DrawSmartText(w, t_offset, ty, tsz.cx, label, font,
                    ds || IsReadOnly() ? SColorDisabled : Nvl(color, GetLabelTextColor(this)),
                    VisibleAccessKeys() ? accesskey : 0);
      if(HasFocus())
        DrawFocus(w, RectC(t_offset, ty - DPI(1), tsz.cx + DPI(3), tsz.cy + DPI(2)) & sz);
    }

    if(box) {
      w.Begin();
      w.ExcludeClip(ix - DPI(3), 0, isz.cx + DPI(8) + tsz.cx, tsz.cy);
      PaintLabelBox(w, sz, Null, d);
      w.End();
    }
  }

  void   eOption::SetData(const Value& data) {
    Set(IsString(data) ? String(data) == "1" ? 1
                                            : IsNull(data) ? (notnull ? 0 : int(Null)) : 0
                      : notnull ? Nvl((int)data, 0) : (int)data);
  }

  Value  eOption::GetData() const {
    return (int) option;
  }

  void  eOption::PerformAction() {
    if(option == 0)
      option = threestate ? Null : 1;
    else
    if(option == 1)
      option = 0;
    else
      option = 1;
    UpdateAction();
    RefreshPush();
    AutoSync();
  }

  eOption& eOption::Set(int b)
  {
    if(b != option) {
      option = b;
      Update();
      RefreshPush();
      AutoSync();
    }
    return *this;
  }

  eOption::eOption() {
    option = 0;
    notnull = true;
    switchimage = threestate = false;
    blackedge = false;
    showlabel = true;
    autobox = box = false;
    labelgap = DPI(2);
    labelleft = false;
    Transparent();
    font = StdFont();
    color = Null;
  }

  eOption::~eOption() {}
}
