#include "CrashTest.h"



CrashTest::CrashTest()
{
	CtrlLayout(*this, "Window title");
	
	
	
    m_grid.AddColumn("Wind Speed [m/s]",170).Edit(m_editSpeed);
    m_grid.AddColumn("Power [kW]",150).Edit(m_editPower);
    m_grid.AddColumn("Ct",150).Edit(m_editThrust);
    m_grid.AddColumn("RPM",130).Edit(m_editRPM);
    m_grid.RejectNullRow();

	m_grid.Appending().Removing().Editing().Accepting().Canceling();

	m_grid.SetRowCount(10);
	
	buttonAdd <<= THISBACK(OnAdd);
	buttonDelete <<= THISBACK(OnDelete);
	buttonLock <<= THISBACK(OnLock);	
	
	for(int i=0;i<10;i++)
	{
		m_grid.Set(i,0,i);
		m_grid.Set(i,1,Format("char=%c",(char)(i+40)));		
//		m_grid.GetRow(i).Editable(false);
	}
	
	
	
	
}

void CrashTest::OnLock()
{
	int i = m_grid.GetCurrentRow();
	m_grid.GetRow(i).Editable(false);	
	
}

void CrashTest::OnAdd()
{
	m_grid.Add();	
}

void CrashTest::OnDelete()
{
	int i=m_grid.GetCurrentRow();
	
	m_grid.Remove(i);
	
}

GUI_APP_MAIN
{
	CrashTest().Run();
}

